/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.api.storage;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public interface IDrawer {
    @Nonnull
    public ItemStack getStoredItemPrototype();

    @Nonnull
    public IDrawer setStoredItem(@Nonnull ItemStack var1);

    @Nonnull
    default public IDrawer setStoredItem(@Nonnull ItemStack itemPrototype, int amount) {
        IDrawer drawer = this.setStoredItem(itemPrototype);
        drawer.setStoredItemCount(amount);
        return drawer;
    }

    public int getStoredItemCount();

    public void setStoredItemCount(int var1);

    default public int adjustStoredItemCount(int amount) {
        if (amount > 0) {
            int insert = Math.min(amount, this.getRemainingCapacity());
            this.setStoredItemCount(this.getStoredItemCount() + insert);
            return amount - insert;
        }
        if (amount < 0) {
            int stored = this.getStoredItemCount();
            int destroy = Math.min(Math.abs(amount), this.getStoredItemCount());
            this.setStoredItemCount(stored - destroy);
            return amount + destroy;
        }
        return 0;
    }

    default public int getMaxCapacity() {
        return this.getMaxCapacity(this.getStoredItemPrototype());
    }

    public int getMaxCapacity(@Nonnull ItemStack var1);

    public int getRemainingCapacity();

    default public int getAcceptingRemainingCapacity() {
        return this.getRemainingCapacity();
    }

    default public int getStoredItemStackSize() {
        ItemStack protoStack = this.getStoredItemPrototype();
        if (protoStack.func_190926_b()) {
            return 0;
        }
        return protoStack.func_77973_b().getItemStackLimit(protoStack);
    }

    public boolean canItemBeStored(@Nonnull ItemStack var1, Predicate<ItemStack> var2);

    default public boolean canItemBeStored(@Nonnull ItemStack itemPrototype) {
        return this.canItemBeStored(itemPrototype, null);
    }

    public boolean canItemBeExtracted(@Nonnull ItemStack var1, Predicate<ItemStack> var2);

    default public boolean canItemBeExtracted(@Nonnull ItemStack itemPrototype) {
        return this.canItemBeExtracted(itemPrototype, null);
    }

    public boolean isEmpty();

    default public boolean isEnabled() {
        return true;
    }
}

