/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.chameleon.block.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemHandler;
import com.jaquadro.minecraft.storagedrawers.capabilities.DrawerItemRepository;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.jaquadro.minecraft.storagedrawers.util.CompactingHelper;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackOreMatcher;
import java.util.Stack;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;

public class FractionalDrawerGroup
extends TileDataShim
implements IDrawerGroup {
    @CapabilityInject(value=IItemHandler.class)
    public static Capability<IItemHandler> ITEM_HANDLER_CAPABILITY = null;
    @CapabilityInject(value=IItemRepository.class)
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;
    private FractionalStorage storage;
    private FractionalDrawer[] slots;
    private int[] order;
    private final IItemHandler itemHandler = new DrawerItemHandler(this);
    private final IItemRepository itemRepository = new DrawerItemRepository(this);

    public FractionalDrawerGroup(int slotCount) {
        this.storage = new FractionalStorage(this, slotCount);
        this.slots = new FractionalDrawer[slotCount];
        this.order = new int[slotCount];
        for (int i = 0; i < slotCount; ++i) {
            this.slots[i] = new FractionalDrawer(this.storage, i);
            this.order[i] = i;
        }
    }

    public void setCapabilityProvider(ICapabilityProvider capProvider) {
        this.storage.setCapabilityProvider(capProvider);
    }

    @Override
    public int getDrawerCount() {
        return this.slots.length;
    }

    @Override
    @Nonnull
    public IFractionalDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.slots.length) {
            return Drawers.DISABLED_FRACTIONAL;
        }
        return this.slots[slot];
    }

    @Override
    @Nonnull
    public int[] getAccessibleDrawerSlots() {
        return this.order;
    }

    public int getPooledCount() {
        return this.storage.getPooledCount();
    }

    public void setPooledCount(int count) {
        this.storage.setPooledCount(count);
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("Drawers")) {
            this.storage.deserializeNBT(tag.func_74775_l("Drawers"));
        } else if (tag.func_74764_b("Slots")) {
            this.storage.deserializeLegacyNBT(tag);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a("Drawers", (NBTBase)this.storage.serializeNBT());
        return tag;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == ITEM_HANDLER_CAPABILITY || capability == ITEM_REPOSITORY_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        if (capability == ITEM_REPOSITORY_CAPABILITY) {
            return (T)this.itemRepository;
        }
        return null;
    }

    public void syncAttributes() {
        this.storage.syncAttributes();
    }

    protected World getWorld() {
        return null;
    }

    protected void log(String message) {
    }

    protected int getStackCapacity() {
        return 0;
    }

    protected void onItemChanged() {
    }

    protected void onAmountChanged() {
    }

    private static class FractionalDrawer
    implements IFractionalDrawer {
        private FractionalStorage storage;
        private int slot;

        public FractionalDrawer(FractionalStorage storage, int slot) {
            this.storage = storage;
            this.slot = slot;
        }

        @Override
        @Nonnull
        public ItemStack getStoredItemPrototype() {
            return this.storage.getStack(this.slot);
        }

        @Override
        @Nonnull
        public IDrawer setStoredItem(@Nonnull ItemStack itemPrototype) {
            return this.storage.setStoredItem(this.slot, itemPrototype);
        }

        @Override
        public int getStoredItemCount() {
            return this.storage.getStoredCount(this.slot);
        }

        @Override
        public void setStoredItemCount(int amount) {
            this.storage.setStoredItemCount(this.slot, amount);
        }

        @Override
        public int adjustStoredItemCount(int amount) {
            return this.storage.adjustStoredItemCount(this.slot, amount);
        }

        @Override
        public int getMaxCapacity() {
            return this.storage.getMaxCapacity(this.slot);
        }

        @Override
        public int getMaxCapacity(@Nonnull ItemStack itemPrototype) {
            return this.storage.getMaxCapacity(this.slot, itemPrototype);
        }

        @Override
        public int getRemainingCapacity() {
            return this.storage.getRemainingCapacity(this.slot);
        }

        @Override
        public int getAcceptingRemainingCapacity() {
            return this.storage.getAcceptingRemainingCapacity(this.slot);
        }

        @Override
        public boolean canItemBeStored(@Nonnull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            return this.storage.canItemBeStored(this.slot, itemPrototype, matchPredicate);
        }

        @Override
        public boolean canItemBeExtracted(@Nonnull ItemStack itemPrototype, Predicate<ItemStack> matchPredicate) {
            return this.storage.canItemBeExtracted(this.slot, itemPrototype, matchPredicate);
        }

        @Override
        public boolean isEmpty() {
            return this.storage.isEmpty(this.slot);
        }

        @Override
        public boolean isEnabled() {
            return this.storage.isEnabled(this.slot);
        }

        @Override
        public int getConversionRate() {
            return this.storage.getConversionRate(this.slot);
        }

        @Override
        public int getStoredItemRemainder() {
            return this.storage.getStoredItemRemainder(this.slot);
        }

        @Override
        public boolean isSmallestUnit() {
            return this.storage.isSmallestUnit(this.slot);
        }
    }

    private static class FractionalStorage
    implements INBTSerializable<NBTTagCompound> {
        @CapabilityInject(value=IDrawerAttributes.class)
        static Capability<IDrawerAttributes> ATTR_CAPABILITY = null;
        private FractionalDrawerGroup group;
        private int slotCount;
        private ItemStack[] protoStack;
        private int[] convRate;
        private ItemStackMatcher[] matchers;
        private int pooledCount;
        IDrawerAttributes attrs;

        public FractionalStorage(FractionalDrawerGroup group, int slotCount) {
            this.group = group;
            this.slotCount = slotCount;
            this.protoStack = new ItemStack[slotCount];
            this.matchers = new ItemStackMatcher[slotCount];
            for (int i = 0; i < slotCount; ++i) {
                this.protoStack[i] = ItemStack.field_190927_a;
                this.matchers[i] = ItemStackMatcher.EMPTY;
            }
            this.convRate = new int[slotCount];
            this.attrs = new EmptyDrawerAttributes();
        }

        public void setCapabilityProvider(ICapabilityProvider capProvider) {
            IDrawerAttributes capAttrs = (IDrawerAttributes)capProvider.getCapability(ATTR_CAPABILITY, null);
            if (capAttrs != null) {
                this.attrs = capAttrs;
            }
        }

        public int getPooledCount() {
            return this.pooledCount;
        }

        public void setPooledCount(int count) {
            if (this.pooledCount != count) {
                this.pooledCount = count;
                this.group.onAmountChanged();
            }
        }

        @Nonnull
        public ItemStack getStack(int slot) {
            return this.protoStack[slot];
        }

        @Nonnull
        public ItemStack baseStack() {
            return this.protoStack[0];
        }

        public int baseRate() {
            return this.convRate[0];
        }

        public IFractionalDrawer setStoredItem(int slot, @Nonnull ItemStack itemPrototype) {
            if ((itemPrototype = ItemStackHelper.getItemPrototype(itemPrototype)).func_190926_b()) {
                this.reset();
                return this.group.getDrawer(slot);
            }
            if (this.baseRate() == 0) {
                this.populateSlots(itemPrototype);
                for (int i = 0; i < this.slotCount; ++i) {
                    if (!ItemStackOreMatcher.areItemsEqual(this.protoStack[i], itemPrototype)) continue;
                    slot = i;
                    this.pooledCount = 0;
                }
                this.group.onItemChanged();
            }
            return this.group.getDrawer(slot);
        }

        public int getStoredCount(int slot) {
            if (this.convRate[slot] == 0) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            return this.pooledCount / this.convRate[slot];
        }

        public void setStoredItemCount(int slot, int amount) {
            if (this.convRate[slot] == 0) {
                return;
            }
            if (this.attrs.isUnlimitedVending()) {
                return;
            }
            int oldCount = this.pooledCount;
            this.pooledCount = this.pooledCount % this.convRate[slot] + this.convRate[slot] * amount;
            this.pooledCount = Math.min(this.pooledCount, this.getMaxCapacity(0) * this.convRate[0]);
            this.pooledCount = Math.max(this.pooledCount, 0);
            if (this.pooledCount == oldCount) {
                return;
            }
            if (this.pooledCount == 0 && !this.attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset();
            } else {
                this.group.onAmountChanged();
            }
        }

        public int adjustStoredItemCount(int slot, int amount) {
            if (this.convRate[slot] == 0 || amount == 0) {
                return amount;
            }
            if (amount > 0) {
                int canAdd;
                int willAdd;
                if (this.attrs.isUnlimitedVending()) {
                    return 0;
                }
                int poolMax = this.getMaxCapacity(0) * this.convRate[0];
                if (poolMax < 0) {
                    poolMax = Integer.MAX_VALUE;
                }
                if ((willAdd = Math.min(amount, canAdd = (poolMax - this.pooledCount) / this.convRate[slot])) == 0) {
                    return amount;
                }
                this.pooledCount += this.convRate[slot] * willAdd;
                this.group.onAmountChanged();
                if (this.attrs.isVoid()) {
                    return 0;
                }
                return amount - willAdd;
            }
            int canRemove = this.pooledCount / this.convRate[slot];
            int willRemove = Math.min(amount = -amount, canRemove);
            if (willRemove == 0) {
                return amount;
            }
            this.pooledCount -= willRemove;
            if (this.pooledCount == 0 && !this.attrs.isItemLocked(LockAttribute.LOCK_POPULATED)) {
                this.reset();
            } else {
                this.group.onAmountChanged();
            }
            return amount - willRemove;
        }

        public int getMaxCapacity(int slot) {
            if (this.baseStack().func_190926_b() || this.convRate[slot] == 0) {
                return 0;
            }
            if (this.attrs.isUnlimitedStorage() || this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE / this.convRate[slot];
            }
            return this.baseStack().func_77973_b().getItemStackLimit(this.baseStack()) * this.group.getStackCapacity() * (this.baseRate() / this.convRate[slot]);
        }

        public int getMaxCapacity(int slot, @Nonnull ItemStack itemPrototype) {
            if (this.attrs.isUnlimitedStorage() || this.attrs.isUnlimitedVending()) {
                if (this.convRate[slot] == 0) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE / this.convRate[slot];
            }
            if (this.baseStack().func_190926_b()) {
                int itemStackLimit = 64;
                if (!itemPrototype.func_190926_b()) {
                    itemStackLimit = itemPrototype.func_77973_b().getItemStackLimit(itemPrototype);
                }
                return itemStackLimit * this.group.getStackCapacity();
            }
            if (ItemStackOreMatcher.areItemsEqual(this.protoStack[slot], itemPrototype)) {
                return this.getMaxCapacity(slot);
            }
            return 0;
        }

        public int getRemainingCapacity(int slot) {
            if (this.baseStack().func_190926_b() || this.convRate[slot] == 0) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending()) {
                return Integer.MAX_VALUE;
            }
            int rawMaxCapacity = this.baseStack().func_77973_b().getItemStackLimit(this.baseStack()) * this.group.getStackCapacity() * this.baseRate();
            int rawRemaining = rawMaxCapacity - this.pooledCount;
            return rawRemaining / this.convRate[slot];
        }

        public int getAcceptingRemainingCapacity(int slot) {
            if (this.baseStack().func_190926_b() || this.convRate[slot] == 0) {
                return 0;
            }
            if (this.attrs.isUnlimitedVending() || this.attrs.isVoid()) {
                return Integer.MAX_VALUE;
            }
            int rawMaxCapacity = this.baseStack().func_77973_b().getItemStackLimit(this.baseStack()) * this.group.getStackCapacity() * this.baseRate();
            int rawRemaining = rawMaxCapacity - this.pooledCount;
            return rawRemaining / this.convRate[slot];
        }

        public boolean isEmpty(int slot) {
            return this.protoStack[slot].func_190926_b();
        }

        public boolean isEnabled(int slot) {
            if (this.baseStack().func_190926_b()) {
                return true;
            }
            return !this.protoStack[slot].func_190926_b();
        }

        public boolean canItemBeStored(int slot, @Nonnull ItemStack itemPrototype, Predicate<ItemStack> predicate) {
            if (this.protoStack[slot].func_190926_b() && !this.attrs.isItemLocked(LockAttribute.LOCK_EMPTY)) {
                return true;
            }
            if (predicate == null) {
                return this.matchers[slot].matches(itemPrototype);
            }
            return predicate.test(this.protoStack[slot]);
        }

        public boolean canItemBeExtracted(int slot, @Nonnull ItemStack itemPrototype, Predicate<ItemStack> predicate) {
            if (this.protoStack[slot].func_190926_b()) {
                return false;
            }
            if (predicate == null) {
                return this.matchers[slot].matches(itemPrototype);
            }
            return predicate.test(this.protoStack[slot]);
        }

        public int getConversionRate(int slot) {
            if (this.baseStack().func_190926_b() || this.convRate[slot] == 0) {
                return 0;
            }
            return this.convRate[0] / this.convRate[slot];
        }

        public int getStoredItemRemainder(int slot) {
            if (this.convRate[slot] == 0) {
                return 0;
            }
            if (slot == 0) {
                return this.pooledCount / this.baseRate();
            }
            return this.pooledCount / this.convRate[slot] % (this.convRate[slot - 1] / this.convRate[slot]);
        }

        public boolean isSmallestUnit(int slot) {
            if (this.baseStack().func_190926_b() || this.convRate[slot] == 0) {
                return false;
            }
            return this.convRate[slot] == 1;
        }

        private void reset() {
            this.pooledCount = 0;
            for (int i = 0; i < this.slotCount; ++i) {
                this.protoStack[i] = ItemStack.field_190927_a;
                this.matchers[i] = ItemStackMatcher.EMPTY;
                this.convRate[i] = 0;
            }
            this.group.onItemChanged();
        }

        private void populateSlots(@Nonnull ItemStack itemPrototype) {
            CompactingHelper.Result lookup;
            int index;
            CompactingHelper.Result lookup2;
            World world = this.group.getWorld();
            if (world == null) {
                this.protoStack[0] = itemPrototype;
                this.convRate[0] = 1;
                this.matchers[0] = this.attrs.isDictConvertible() ? new ItemStackOreMatcher(this.protoStack[0]) : new ItemStackMatcher(this.protoStack[0]);
                return;
            }
            CompactingHelper compacting = new CompactingHelper(world);
            Stack<CompactingHelper.Result> resultStack = new Stack<CompactingHelper.Result>();
            ItemStack lookupTarget = itemPrototype;
            for (int i = 0; i < this.slotCount && !(lookup2 = compacting.findHigherTier(lookupTarget)).getStack().func_190926_b(); ++i) {
                resultStack.push(lookup2);
                lookupTarget = lookup2.getStack();
            }
            int n = resultStack.size();
            for (index = 0; index < n; ++index) {
                CompactingHelper.Result result = (CompactingHelper.Result)resultStack.pop();
                this.populateRawSlot(index, result.getStack(), result.getSize());
                this.group.log("Picked candidate " + result.getStack().toString() + " with conv=" + result.getSize());
                int i = 0;
                while (i < index - 1) {
                    int n2 = i++;
                    this.convRate[n2] = this.convRate[n2] * result.getSize();
                }
            }
            if (index == this.slotCount) {
                return;
            }
            this.populateRawSlot(index++, itemPrototype, 1);
            lookupTarget = itemPrototype;
            while (index < this.slotCount && !(lookup = compacting.findLowerTier(lookupTarget)).getStack().func_190926_b()) {
                this.populateRawSlot(index, lookup.getStack(), 1);
                this.group.log("Picked candidate " + lookup.getStack().toString() + " with conv=" + lookup.getSize());
                int i = 0;
                while (i < index) {
                    int n3 = i++;
                    this.convRate[n3] = this.convRate[n3] * lookup.getSize();
                }
                lookupTarget = lookup.getStack();
                ++index;
            }
        }

        private void populateRawSlot(int slot, @Nonnull ItemStack itemPrototype, int rate) {
            this.protoStack[slot] = itemPrototype;
            this.convRate[slot] = rate;
            this.matchers[slot] = this.attrs.isDictConvertible() ? new ItemStackOreMatcher(this.protoStack[slot]) : new ItemStackMatcher(this.protoStack[slot]);
        }

        public NBTTagCompound serializeNBT() {
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < this.slotCount; ++i) {
                if (this.protoStack[i].func_190926_b()) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                this.protoStack[i].func_77955_b(itemTag);
                NBTTagCompound slotTag = new NBTTagCompound();
                slotTag.func_74774_a("Slot", (byte)i);
                slotTag.func_74768_a("Conv", this.convRate[i]);
                slotTag.func_74782_a("Item", (NBTBase)itemTag);
                itemList.func_74742_a((NBTBase)slotTag);
            }
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Count", this.pooledCount);
            tag.func_74782_a("Items", (NBTBase)itemList);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
            for (int i = 0; i < this.slotCount; ++i) {
                this.protoStack[i] = ItemStack.field_190927_a;
                this.matchers[i] = ItemStackMatcher.EMPTY;
                this.convRate[i] = 0;
            }
            this.pooledCount = tag.func_74762_e("Count");
            NBTTagList itemList = tag.func_150295_c("Items", 10);
            for (int i = 0; i < itemList.func_74745_c(); ++i) {
                NBTTagCompound slotTag = itemList.func_150305_b(i);
                byte slot = slotTag.func_74771_c("Slot");
                this.protoStack[slot] = new ItemStack(slotTag.func_74775_l("Item"));
                this.convRate[slot] = slotTag.func_74771_c("Conv");
                this.matchers[slot] = this.attrs.isDictConvertible() ? new ItemStackOreMatcher(this.protoStack[slot]) : new ItemStackMatcher(this.protoStack[slot]);
            }
        }

        public void deserializeLegacyNBT(NBTTagCompound tag) {
            for (int i = 0; i < this.slotCount; ++i) {
                this.protoStack[i] = ItemStack.field_190927_a;
                this.convRate[i] = 0;
            }
            this.pooledCount = tag.func_74762_e("Count");
            if (tag.func_74764_b("Conv0")) {
                this.convRate[0] = tag.func_74771_c("Conv0");
            }
            if (tag.func_74764_b("Conv1")) {
                this.convRate[1] = tag.func_74771_c("Conv1");
            }
            if (tag.func_74764_b("Conv2")) {
                this.convRate[2] = tag.func_74771_c("Conv2");
            }
            NBTTagList slots = tag.func_150295_c("Slots", 10);
            for (int i = 0; i < this.slotCount; ++i) {
                Item item;
                NBTTagCompound slot = slots.func_150305_b(i);
                if (!slot.func_74764_b("Item") || (item = Item.func_150899_d((int)slot.func_74765_d("Item"))) == null) continue;
                ItemStack stack = new ItemStack(item);
                stack.func_77964_b((int)slot.func_74765_d("Meta"));
                if (slot.func_74764_b("Tags")) {
                    stack.func_77982_d(slot.func_74775_l("Tags"));
                }
                this.protoStack[i] = stack;
                this.matchers[i] = this.attrs.isDictConvertible() ? new ItemStackOreMatcher(this.protoStack[i]) : new ItemStackMatcher(this.protoStack[i]);
            }
        }

        public void syncAttributes() {
            for (int i = 0; i < this.slotCount; ++i) {
                if (this.protoStack[i].func_190926_b()) continue;
                this.matchers[i] = this.attrs.isDictConvertible() ? new ItemStackOreMatcher(this.protoStack[i]) : new ItemStackMatcher(this.protoStack[i]);
            }
        }
    }
}

