/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile.tiledata;

import com.jaquadro.minecraft.chameleon.block.tiledata.TileDataShim;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeCreative;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeRedstone;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStatus;
import com.jaquadro.minecraft.storagedrawers.item.EnumUpgradeStorage;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.MathHelper;

public class UpgradeData
extends TileDataShim {
    private final ItemStack[] upgrades;
    private int storageMultiplier;
    private EnumUpgradeStatus statusType;
    private EnumUpgradeRedstone redstoneType;
    private boolean hasOneStack;
    private boolean hasVoid;
    private boolean hasUnlimited;
    private boolean hasVending;
    private boolean hasConversion;
    private IDrawerAttributesModifiable attrs;

    public UpgradeData(int slotCount) {
        this.upgrades = new ItemStack[slotCount];
        for (int i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i] = ItemStack.field_190927_a;
        }
        this.syncStorageMultiplier();
    }

    public void setDrawerAttributes(IDrawerAttributesModifiable attrs) {
        this.attrs = attrs;
        this.syncUpgrades();
    }

    public int getSlotCount() {
        return this.upgrades.length;
    }

    @Nonnull
    public ItemStack getUpgrade(int slot) {
        slot = MathHelper.func_76125_a((int)slot, (int)0, (int)(this.upgrades.length - 1));
        return this.upgrades[slot];
    }

    public boolean addUpgrade(@Nonnull ItemStack upgrade) {
        int slot = this.getNextUpgradeSlot();
        if (slot == -1) {
            return false;
        }
        this.setUpgrade(slot, upgrade);
        return true;
    }

    public boolean setUpgrade(int slot, @Nonnull ItemStack upgrade) {
        ItemStack prevUpgrade;
        slot = MathHelper.func_76125_a((int)slot, (int)0, (int)(this.upgrades.length - 1));
        if (!upgrade.func_190926_b()) {
            upgrade = upgrade.func_77946_l();
            upgrade.func_190920_e(1);
        }
        if (!(prevUpgrade = this.upgrades[slot]).func_190926_b() && !this.canRemoveUpgrade(slot)) {
            return false;
        }
        this.upgrades[slot] = ItemStack.field_190927_a;
        this.syncStorageMultiplier();
        if (!this.canAddUpgrade(upgrade)) {
            this.upgrades[slot] = prevUpgrade;
            this.syncStorageMultiplier();
            return false;
        }
        this.upgrades[slot] = upgrade;
        this.syncUpgrades();
        this.onUpgradeChanged(prevUpgrade, upgrade);
        return true;
    }

    public boolean canAddUpgrade(@Nonnull ItemStack upgrade) {
        if (upgrade.func_190926_b()) {
            return false;
        }
        if (!(upgrade.func_77973_b() instanceof ItemUpgrade)) {
            return false;
        }
        ItemUpgrade candidate = (ItemUpgrade)upgrade.func_77973_b();
        if (candidate.getAllowMultiple()) {
            return true;
        }
        for (ItemStack stack : this.upgrades) {
            ItemUpgrade reference;
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemUpgrade) || candidate != (reference = (ItemUpgrade)stack.func_77973_b())) continue;
            return false;
        }
        return true;
    }

    public boolean canRemoveUpgrade(int slot) {
        return !this.upgrades[slot = MathHelper.func_76125_a((int)slot, (int)0, (int)(this.upgrades.length - 1))].func_190926_b();
    }

    public int getStorageMultiplier() {
        return this.storageMultiplier;
    }

    public EnumUpgradeStatus getStatusType() {
        return this.statusType;
    }

    public EnumUpgradeRedstone getRedstoneType() {
        return this.redstoneType;
    }

    public boolean hasOneStackUpgrade() {
        return this.hasOneStack;
    }

    public boolean hasUnlimitedUpgrade() {
        return this.hasUnlimited;
    }

    public boolean hasVendingUpgrade() {
        return this.hasVending;
    }

    public boolean hasConversionUpgrade() {
        return this.hasConversion;
    }

    private int getNextUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (!this.upgrades[i].func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    private void syncUpgrades() {
        if (this.attrs == null) {
            return;
        }
        this.syncStorageMultiplier();
        this.syncStatusLevel();
        this.syncRedstoneLevel();
        this.hasOneStack = false;
        this.hasVoid = false;
        this.hasUnlimited = false;
        this.hasVending = false;
        this.hasConversion = false;
        for (ItemStack stack : this.upgrades) {
            Item item = stack.func_77973_b();
            if (item == ModItems.upgradeOneStack) {
                this.hasOneStack = true;
                continue;
            }
            if (item == ModItems.upgradeVoid) {
                this.hasVoid = true;
                continue;
            }
            if (item == ModItems.upgradeConversion) {
                this.hasConversion = true;
                continue;
            }
            if (item != ModItems.upgradeCreative) continue;
            EnumUpgradeCreative type = EnumUpgradeCreative.byMetadata(stack.func_77960_j());
            if (type == EnumUpgradeCreative.STORAGE) {
                this.hasUnlimited = true;
                continue;
            }
            if (type != EnumUpgradeCreative.VENDING) continue;
            this.hasVending = true;
        }
        this.attrs.setIsVoid(this.hasVoid);
        this.attrs.setIsDictConvertible(this.hasConversion);
        this.attrs.setIsUnlimitedStorage(this.hasUnlimited);
        this.attrs.setIsUnlimitedVending(this.hasVending);
    }

    private void syncStorageMultiplier() {
        ConfigManager config = StorageDrawers.config;
        this.storageMultiplier = 0;
        for (ItemStack stack : this.upgrades) {
            if (stack.func_77973_b() != ModItems.upgradeStorage) continue;
            int level = EnumUpgradeStorage.byMetadata(stack.func_77960_j()).getLevel();
            this.storageMultiplier += config.getStorageUpgradeMultiplier(level);
        }
        if (this.storageMultiplier == 0) {
            this.storageMultiplier = config.getStorageUpgradeMultiplier(1);
        }
    }

    private void syncStatusLevel() {
        this.statusType = null;
        for (ItemStack stack : this.upgrades) {
            if (stack.func_77973_b() != ModItems.upgradeStatus) continue;
            this.statusType = EnumUpgradeStatus.byMetadata(stack.func_77960_j());
            break;
        }
    }

    private void syncRedstoneLevel() {
        this.redstoneType = null;
        for (ItemStack stack : this.upgrades) {
            if (stack.func_77973_b() != ModItems.upgradeRedstone) continue;
            this.redstoneType = EnumUpgradeRedstone.byMetadata(stack.func_77960_j());
            break;
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (int i = 0; i < this.upgrades.length; ++i) {
            this.upgrades[i] = ItemStack.field_190927_a;
        }
        if (!tag.func_74764_b("Upgrades")) {
            return;
        }
        NBTTagList tagList = tag.func_150295_c("Upgrades", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound upgradeTag = tagList.func_150305_b(i);
            byte slot = upgradeTag.func_74771_c("Slot");
            this.upgrades[slot] = new ItemStack(upgradeTag);
        }
        this.syncUpgrades();
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i].func_190926_b()) continue;
            NBTTagCompound upgradeTag = this.upgrades[i].func_77955_b(new NBTTagCompound());
            upgradeTag.func_74774_a("Slot", (byte)i);
            tagList.func_74742_a((NBTBase)upgradeTag);
        }
        tag.func_74782_a("Upgrades", (NBTBase)tagList);
        return tag;
    }

    protected void onUpgradeChanged(ItemStack oldUpgrade, ItemStack newUpgrade) {
    }
}

