/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class SlotDrawer
extends Slot {
    private static IInventory emptyInventory = new InventoryBasic("[Null]", true, 0);
    private ContainerDrawers container;
    private final IDrawerGroup group;
    private final IDrawer drawer;

    public SlotDrawer(ContainerDrawers container, IDrawerGroup drawerGroup, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.container = container;
        this.group = drawerGroup;
        this.drawer = this.group.getDrawer(index);
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        return !stack.func_190926_b() && this.drawer.canItemBeStored(stack);
    }

    @Nonnull
    public ItemStack func_75211_c() {
        ItemStack stack = ItemStackHelper.encodeItemStack(this.drawer.getStoredItemPrototype(), this.drawer.getStoredItemCount());
        this.container.setLastAccessedItem(stack);
        return stack;
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        IDrawer target = this.drawer.setStoredItem(stack);
        if (!ItemStackHelper.isStackEncoded(stack)) {
            target.setStoredItemCount(stack.func_190916_E());
        }
    }

    public void func_75220_a(@Nonnull ItemStack p_75220_1_, @Nonnull ItemStack p_75220_2_) {
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        return Math.min(stack.func_77976_d(), this.drawer.getRemainingCapacity());
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        return false;
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        int withdraw = Math.min(amount, this.drawer.getStoredItemCount());
        this.drawer.setStoredItemCount(withdraw);
        ItemStack stack = this.drawer.getStoredItemPrototype().func_77946_l();
        stack.func_190920_e(this.drawer.getStoredItemCount() - withdraw);
        return stack;
    }

    public IDrawerGroup getDrawerGroup() {
        return this.group;
    }

    public boolean isSameInventory(Slot other) {
        return other instanceof SlotDrawer && ((SlotDrawer)other).getDrawerGroup() == this.group;
    }
}

