/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod.common;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class FoamyArrayBackedDataManagerMap<V>
implements Map<Integer, V> {
    private final Collection<Object> objects = new ArrayList<Object>();
    private Object[] keys = new Object[32];
    private int size = 0;

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object o) {
        return this.get(o) != null;
    }

    public boolean containsKey(int i) {
        return this.get(i) != null;
    }

    @Override
    public boolean containsValue(Object o) {
        return this.objects.contains(o);
    }

    public V get(int i) {
        return (V)(i >= 0 && i < 256 ? this.keys[i] : null);
    }

    @Override
    public V get(Object o) {
        int i = (Integer)o;
        return (V)(i >= 0 && i < 256 ? this.keys[i] : null);
    }

    protected abstract void addKey(int var1);

    protected abstract void removeKey(int var1);

    @Override
    public V put(Integer integer, V v) {
        int i = integer;
        if (i >= 0 && i < 256) {
            if (i >= this.keys.length) {
                int newSize;
                for (newSize = this.keys.length; newSize <= i; newSize *= 2) {
                }
                Object[] newKeys = new Object[newSize];
                System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
                this.keys = newKeys;
            }
            Object old = this.keys[i];
            this.keys[i] = v;
            if (old == null) {
                this.addKey(i);
                ++this.size;
            } else {
                this.objects.remove(old);
            }
            this.objects.add(v);
            return (V)old;
        }
        throw new RuntimeException("EntityDataManager entry outside of the [0, 255] range (" + i + ") was attempted to be added. Please disable EntityDataManager-related optimizations and report this to the FoamFix developers.");
    }

    @Override
    public V remove(Object o) {
        int i = (Integer)o;
        if (i >= 0 && i < 256) {
            Object old = this.keys[i];
            this.keys[i] = null;
            this.removeKey(i);
            this.objects.remove(old);
            if (old != null) {
                --this.size;
            }
            return (V)old;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.keys[i] = null;
        }
        this.keySet().clear();
        this.size = 0;
    }

    @Override
    public Collection<V> values() {
        return this.objects;
    }

    public static class OneTwelve<V>
    extends FoamyArrayBackedDataManagerMap<V> {
        private final IntOpenHashSet keySet = new IntOpenHashSet();

        @Override
        public Set<Integer> keySet() {
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<Integer, V>> entrySet() {
            HashSet<Map.Entry<Integer, V>> e = new HashSet<Map.Entry<Integer, V>>();
            IntIterator ii = this.keySet.iterator();
            while (ii.hasNext()) {
                final int i = ii.nextInt();
                e.add(new Map.Entry<Integer, V>(){

                    @Override
                    public Integer getKey() {
                        return i;
                    }

                    @Override
                    public V getValue() {
                        return this.get(i);
                    }

                    @Override
                    public V setValue(V v) {
                        return this.put(i, v);
                    }
                });
            }
            return e;
        }

        @Override
        protected void addKey(int i) {
            this.keySet.add(i);
        }

        @Override
        protected void removeKey(int i) {
            this.keySet.rem(i);
        }
    }
}

