/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.media.IMediaProvider;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.api.permissions.ITurtlePermissionProvider;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.redstone.IBundledRedstoneProvider;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class ComputerCraftAPI {
    private static boolean ccSearched = false;
    private static Class<?> computerCraft = null;
    private static Method computerCraft_getVersion = null;
    private static Method computerCraft_createUniqueNumberedSaveDir = null;
    private static Method computerCraft_createSaveDirMount = null;
    private static Method computerCraft_createResourceMount = null;
    private static Method computerCraft_registerPeripheralProvider = null;
    private static Method computerCraft_registerTurtleUpgrade = null;
    private static Method computerCraft_registerBundledRedstoneProvider = null;
    private static Method computerCraft_getDefaultBundledRedstoneOutput = null;
    private static Method computerCraft_registerMediaProvider = null;
    private static Method computerCraft_registerPermissionProvider = null;
    private static Method computerCraft_registerPocketUpgrade = null;
    private static Method computerCraft_getWirelessNetwork = null;

    public static boolean isInstalled() {
        ComputerCraftAPI.findCC();
        return computerCraft != null;
    }

    @Nonnull
    public static String getInstalledVersion() {
        ComputerCraftAPI.findCC();
        if (computerCraft_getVersion != null) {
            try {
                return (String)computerCraft_getVersion.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Nonnull
    public static String getAPIVersion() {
        return "1.80pr0";
    }

    public static int createUniqueNumberedSaveDir(@Nonnull World world, @Nonnull String parentSubPath) {
        ComputerCraftAPI.findCC();
        if (computerCraft_createUniqueNumberedSaveDir != null) {
            try {
                return (Integer)computerCraft_createUniqueNumberedSaveDir.invoke(null, world, parentSubPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    @Nullable
    public static IWritableMount createSaveDirMount(@Nonnull World world, @Nonnull String subPath, long capacity) {
        ComputerCraftAPI.findCC();
        if (computerCraft_createSaveDirMount != null) {
            try {
                return (IWritableMount)computerCraft_createSaveDirMount.invoke(null, world, subPath, capacity);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public static IMount createResourceMount(@Nonnull Class<?> modClass, @Nonnull String domain, @Nonnull String subPath) {
        ComputerCraftAPI.findCC();
        if (computerCraft_createResourceMount != null) {
            try {
                return (IMount)computerCraft_createResourceMount.invoke(null, modClass, domain, subPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static void registerPeripheralProvider(@Nonnull IPeripheralProvider handler) {
        ComputerCraftAPI.findCC();
        if (computerCraft_registerPeripheralProvider != null) {
            try {
                computerCraft_registerPeripheralProvider.invoke(null, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void registerTurtleUpgrade(@Nonnull ITurtleUpgrade upgrade) {
        if (upgrade != null) {
            ComputerCraftAPI.findCC();
            if (computerCraft_registerTurtleUpgrade != null) {
                try {
                    computerCraft_registerTurtleUpgrade.invoke(null, upgrade);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void registerBundledRedstoneProvider(@Nonnull IBundledRedstoneProvider handler) {
        ComputerCraftAPI.findCC();
        if (computerCraft_registerBundledRedstoneProvider != null) {
            try {
                computerCraft_registerBundledRedstoneProvider.invoke(null, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getBundledRedstoneOutput(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        ComputerCraftAPI.findCC();
        if (computerCraft_getDefaultBundledRedstoneOutput != null) {
            try {
                return (Integer)computerCraft_getDefaultBundledRedstoneOutput.invoke(null, world, pos, side);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    public static void registerMediaProvider(@Nonnull IMediaProvider handler) {
        ComputerCraftAPI.findCC();
        if (computerCraft_registerMediaProvider != null) {
            try {
                computerCraft_registerMediaProvider.invoke(null, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void registerPermissionProvider(@Nonnull ITurtlePermissionProvider handler) {
        ComputerCraftAPI.findCC();
        if (computerCraft_registerPermissionProvider != null) {
            try {
                computerCraft_registerPermissionProvider.invoke(null, handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void registerPocketUpgrade(@Nonnull IPocketUpgrade upgrade) {
        ComputerCraftAPI.findCC();
        if (computerCraft_registerPocketUpgrade != null) {
            try {
                computerCraft_registerPocketUpgrade.invoke(null, upgrade);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static IPacketNetwork getWirelessNetwork() {
        ComputerCraftAPI.findCC();
        if (computerCraft_getWirelessNetwork != null) {
            try {
                return (IPacketNetwork)computerCraft_getWirelessNetwork.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static void findCC() {
        if (!ccSearched) {
            try {
                computerCraft = Class.forName("dan200.computercraft.ComputerCraft");
                computerCraft_getVersion = ComputerCraftAPI.findCCMethod("getVersion", new Class[0]);
                computerCraft_createUniqueNumberedSaveDir = ComputerCraftAPI.findCCMethod("createUniqueNumberedSaveDir", new Class[]{World.class, String.class});
                computerCraft_createSaveDirMount = ComputerCraftAPI.findCCMethod("createSaveDirMount", new Class[]{World.class, String.class, Long.TYPE});
                computerCraft_createResourceMount = ComputerCraftAPI.findCCMethod("createResourceMount", new Class[]{Class.class, String.class, String.class});
                computerCraft_registerPeripheralProvider = ComputerCraftAPI.findCCMethod("registerPeripheralProvider", new Class[]{IPeripheralProvider.class});
                computerCraft_registerTurtleUpgrade = ComputerCraftAPI.findCCMethod("registerTurtleUpgrade", new Class[]{ITurtleUpgrade.class});
                computerCraft_registerBundledRedstoneProvider = ComputerCraftAPI.findCCMethod("registerBundledRedstoneProvider", new Class[]{IBundledRedstoneProvider.class});
                computerCraft_getDefaultBundledRedstoneOutput = ComputerCraftAPI.findCCMethod("getDefaultBundledRedstoneOutput", new Class[]{World.class, BlockPos.class, EnumFacing.class});
                computerCraft_registerMediaProvider = ComputerCraftAPI.findCCMethod("registerMediaProvider", new Class[]{IMediaProvider.class});
                computerCraft_registerPermissionProvider = ComputerCraftAPI.findCCMethod("registerPermissionProvider", new Class[]{ITurtlePermissionProvider.class});
                computerCraft_registerPocketUpgrade = ComputerCraftAPI.findCCMethod("registerPocketUpgrade", new Class[]{IPocketUpgrade.class});
                computerCraft_getWirelessNetwork = ComputerCraftAPI.findCCMethod("getWirelessNetwork", new Class[0]);
            }
            catch (Exception e) {
                System.out.println("ComputerCraftAPI: ComputerCraft not found.");
            }
            finally {
                ccSearched = true;
            }
        }
    }

    private static Method findCCMethod(String name, Class<?>[] args) {
        try {
            if (computerCraft != null) {
                return computerCraft.getMethod(name, args);
            }
            return null;
        }
        catch (NoSuchMethodException e) {
            System.out.println("ComputerCraftAPI: ComputerCraft method " + name + " not found.");
            return null;
        }
    }
}

