/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http;

import com.google.common.base.Joiner;
import com.google.common.io.ByteStreams;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.HTTPRequestException;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.handles.BinaryInputHandle;
import dan200.computercraft.core.apis.handles.EncodedInputHandle;
import dan200.computercraft.core.apis.http.HTTPTask;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class HTTPRequest
implements HTTPTask.IHTTPTask {
    private final URL m_url;
    private final String m_urlString;
    private final String m_postText;
    private final Map<String, String> m_headers;
    private boolean m_success = false;
    private String m_encoding;
    private byte[] m_result;
    private boolean m_binary;
    private int m_responseCode = -1;
    private Map<String, String> m_responseHeaders;
    private String m_errorMessage;

    public static URL checkURL(String urlString) throws HTTPRequestException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new HTTPRequestException("URL malformed");
        }
        String protocol = url.getProtocol().toLowerCase();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new HTTPRequestException("URL not http");
        }
        if (!ComputerCraft.http_whitelist.matches(url.getHost()) || ComputerCraft.http_blacklist.matches(url.getHost())) {
            throw new HTTPRequestException("Domain not permitted");
        }
        return url;
    }

    public static InetAddress checkHost(URL url) throws HTTPRequestException {
        try {
            InetAddress resolved = InetAddress.getByName(url.getHost());
            if (!ComputerCraft.http_whitelist.matches(resolved) || ComputerCraft.http_blacklist.matches(resolved)) {
                throw new HTTPRequestException("Domain not permitted");
            }
            return resolved;
        }
        catch (UnknownHostException e) {
            throw new HTTPRequestException("Unknown host");
        }
    }

    public HTTPRequest(String urlString, URL url, String postText, Map<String, String> headers, boolean binary) throws HTTPRequestException {
        this.m_urlString = urlString;
        this.m_url = url;
        this.m_binary = binary;
        this.m_postText = postText;
        this.m_headers = headers;
    }

    public InputStream getContents() {
        byte[] result = this.m_result;
        if (result != null) {
            return new ByteArrayInputStream(result);
        }
        return null;
    }

    @Override
    public void run() {
        try {
            HTTPRequest.checkHost(this.m_url);
        }
        catch (HTTPRequestException e) {
            this.m_success = false;
            this.m_errorMessage = e.getMessage();
            return;
        }
        try {
            boolean responseSuccess;
            InputStream is;
            int code;
            HttpURLConnection connection = (HttpURLConnection)this.m_url.openConnection();
            if (this.m_postText != null) {
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
            } else {
                connection.setRequestMethod("GET");
            }
            connection.setRequestProperty("accept-charset", "UTF-8");
            if (this.m_postText != null) {
                connection.setRequestProperty("content-type", "application/x-www-form-urlencoded; charset=utf-8");
                connection.setRequestProperty("content-encoding", "UTF-8");
            }
            if (this.m_postText != null) {
                for (Map.Entry<String, String> header : this.m_headers.entrySet()) {
                    connection.setRequestProperty(header.getKey(), header.getValue());
                }
            }
            if (this.m_postText != null) {
                OutputStreamWriter osw;
                OutputStream os = connection.getOutputStream();
                try {
                    osw = new OutputStreamWriter(os, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    osw = new OutputStreamWriter(os);
                }
                BufferedWriter writer = new BufferedWriter(osw);
                writer.write(this.m_postText, 0, this.m_postText.length());
                writer.close();
            }
            if ((code = connection.getResponseCode()) >= 200 && code < 400) {
                is = connection.getInputStream();
                responseSuccess = true;
            } else {
                is = connection.getErrorStream();
                responseSuccess = false;
            }
            byte[] result = ByteStreams.toByteArray((InputStream)is);
            is.close();
            this.m_success = responseSuccess;
            this.m_result = result;
            this.m_responseCode = connection.getResponseCode();
            this.m_encoding = connection.getContentEncoding();
            Joiner joiner = Joiner.on((char)',');
            this.m_responseHeaders = new HashMap<String, String>();
            HashMap<String, String> headers = this.m_responseHeaders;
            for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
                headers.put(header.getKey(), joiner.join((Iterable)header.getValue()));
            }
            connection.disconnect();
        }
        catch (IOException e) {
            this.m_success = false;
        }
    }

    @Override
    public void whenFinished(IAPIEnvironment environment) {
        String url = this.m_urlString;
        if (this.m_success) {
            InputStream contents = this.getContents();
            ILuaObject result = HTTPRequest.wrapStream(this.m_binary ? new BinaryInputHandle(contents) : new EncodedInputHandle(contents, this.m_encoding), this.m_responseCode, this.m_responseHeaders);
            environment.queueEvent("http_success", new Object[]{url, result});
        } else {
            String error = "Could not connect";
            if (this.m_errorMessage != null) {
                error = this.m_errorMessage;
            }
            InputStream contents = this.getContents();
            ILuaObject result = null;
            if (contents != null) {
                result = HTTPRequest.wrapStream(this.m_binary ? new BinaryInputHandle(contents) : new EncodedInputHandle(contents, this.m_encoding), this.m_responseCode, this.m_responseHeaders);
            }
            environment.queueEvent("http_failure", new Object[]{url, error, result});
        }
    }

    private static ILuaObject wrapStream(final ILuaObject reader, final int responseCode, final Map<String, String> responseHeaders) {
        String[] oldMethods = reader.getMethodNames();
        final int methodOffset = oldMethods.length;
        final String[] newMethods = Arrays.copyOf(oldMethods, oldMethods.length + 2);
        newMethods[methodOffset + 0] = "getResponseCode";
        newMethods[methodOffset + 1] = "getResponseHeaders";
        return new ILuaObject(){

            @Override
            @Nonnull
            public String[] getMethodNames() {
                return newMethods;
            }

            @Override
            public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException, InterruptedException {
                if (method < methodOffset) {
                    return reader.callMethod(context, method, args);
                }
                switch (method - methodOffset) {
                    case 0: {
                        return new Object[]{responseCode};
                    }
                    case 1: {
                        return new Object[]{responseHeaders};
                    }
                }
                return null;
            }
        };
    }
}

