/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.core.filesystem.FileSystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;

public class JarMount
implements IMount {
    private ZipFile m_zipFile;
    private FileInZip m_root;
    private String m_rootPath;

    public JarMount(File jarFile, String subPath) throws IOException {
        if (!jarFile.exists() || jarFile.isDirectory()) {
            throw new FileNotFoundException();
        }
        try {
            this.m_zipFile = new ZipFile(jarFile);
        }
        catch (Exception e) {
            throw new IOException("Error loading zip file");
        }
        if (this.m_zipFile.getEntry(subPath) == null) {
            this.m_zipFile.close();
            throw new IOException("Zip does not contain path");
        }
        Enumeration<? extends ZipEntry> zipEntries = this.m_zipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(subPath)) continue;
            entryName = FileSystem.toLocal(entryName, subPath);
            if (this.m_root == null) {
                if (!entryName.equals("")) continue;
                this.m_root = new FileInZip(entryName, entry.isDirectory(), entry.getSize());
                this.m_rootPath = subPath;
                if (this.m_root.isDirectory()) continue;
                break;
            }
            FileInZip parent = this.m_root.getParent(entryName);
            if (parent == null) continue;
            parent.insertChild(new FileInZip(entryName, entry.isDirectory(), entry.getSize()));
        }
    }

    @Override
    public boolean exists(@Nonnull String path) throws IOException {
        FileInZip file = this.m_root.getFile(path);
        return file != null;
    }

    @Override
    public boolean isDirectory(@Nonnull String path) throws IOException {
        FileInZip file = this.m_root.getFile(path);
        if (file != null) {
            return file.isDirectory();
        }
        return false;
    }

    @Override
    public void list(@Nonnull String path, @Nonnull List<String> contents) throws IOException {
        FileInZip file = this.m_root.getFile(path);
        if (file == null || !file.isDirectory()) {
            throw new IOException("Not a directory");
        }
        file.list(contents);
    }

    @Override
    public long getSize(@Nonnull String path) throws IOException {
        FileInZip file = this.m_root.getFile(path);
        if (file != null) {
            return file.getSize();
        }
        throw new IOException("No such file");
    }

    @Override
    @Nonnull
    public InputStream openForRead(@Nonnull String path) throws IOException {
        FileInZip file = this.m_root.getFile(path);
        if (file != null && !file.isDirectory()) {
            try {
                ZipEntry entry;
                String fullPath = this.m_rootPath;
                if (path.length() > 0) {
                    fullPath = fullPath + "/" + path;
                }
                if ((entry = this.m_zipFile.getEntry(fullPath)) != null) {
                    return this.m_zipFile.getInputStream(entry);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IOException("No such file");
    }

    private class FileInZip {
        private String m_path;
        private boolean m_directory;
        private long m_size;
        private Map<String, FileInZip> m_children;

        public FileInZip(String path, boolean directory, long size) {
            this.m_path = path;
            this.m_directory = directory;
            this.m_size = this.m_directory ? 0L : size;
            this.m_children = new LinkedHashMap<String, FileInZip>();
        }

        public String getPath() {
            return this.m_path;
        }

        public boolean isDirectory() {
            return this.m_directory;
        }

        public long getSize() {
            return this.m_size;
        }

        public void list(List<String> contents) {
            contents.addAll(this.m_children.keySet());
        }

        public void insertChild(FileInZip child) {
            String localPath = FileSystem.toLocal(child.getPath(), this.m_path);
            this.m_children.put(localPath, child);
        }

        public FileInZip getFile(String path) {
            FileInZip subFile;
            if (path.equals(this.m_path)) {
                return this;
            }
            String localPath = FileSystem.toLocal(path, this.m_path);
            int slash = localPath.indexOf("/");
            if (slash >= 0) {
                localPath = localPath.substring(0, slash);
            }
            if ((subFile = this.m_children.get(localPath)) != null) {
                return subFile.getFile(path);
            }
            return null;
        }

        public FileInZip getParent(String path) {
            if (path.length() == 0) {
                return null;
            }
            FileInZip file = this.getFile(FileSystem.getDirectory(path));
            if (file.isDirectory()) {
                return file;
            }
            return null;
        }
    }
}

