/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.common;

import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.IPeripheralItem;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ItemPeripheralBase
extends ItemBlock
implements IPeripheralItem {
    protected ItemPeripheralBase(Block block) {
        super(block);
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    public abstract PeripheralType getPeripheralType(int var1);

    public final int func_77647_b(int damage) {
        return damage;
    }

    public boolean func_179222_a(World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, EntityPlayer player, @Nonnull ItemStack stack) {
        PeripheralType type = this.getPeripheralType(stack);
        switch (type) {
            case WirelessModem: 
            case WiredModem: 
            case AdvancedModem: {
                return world.isSideSolid(pos, side);
            }
            case Cable: {
                return true;
            }
        }
        return super.func_179222_a(world, pos, side, player, stack);
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        PeripheralType type = this.getPeripheralType(stack);
        switch (type) {
            default: {
                return "tile.computercraft:drive";
            }
            case Printer: {
                return "tile.computercraft:printer";
            }
            case Monitor: {
                return "tile.computercraft:monitor";
            }
            case AdvancedMonitor: {
                return "tile.computercraft:advanced_monitor";
            }
            case WirelessModem: {
                return "tile.computercraft:wireless_modem";
            }
            case WiredModem: 
            case WiredModemWithCable: {
                return "tile.computercraft:wired_modem";
            }
            case Cable: {
                return "tile.computercraft:cable";
            }
            case AdvancedModem: {
                return "tile.computercraft:advanced_modem";
            }
            case Speaker: 
        }
        return "tile.computercraft:speaker";
    }

    @Override
    public final PeripheralType getPeripheralType(@Nonnull ItemStack stack) {
        return this.getPeripheralType(stack.func_77952_i());
    }
}

