/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.core.apis.TermAPI;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import dan200.computercraft.shared.util.Palette;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.ArrayUtils;

public class MonitorPeripheral
implements IPeripheral {
    private final TileMonitor m_monitor;

    public MonitorPeripheral(TileMonitor monitor) {
        this.m_monitor = monitor;
    }

    @Override
    @Nonnull
    public String getType() {
        return "monitor";
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"write", "scroll", "setCursorPos", "setCursorBlink", "getCursorPos", "getSize", "clear", "clearLine", "setTextScale", "setTextColour", "setTextColor", "setBackgroundColour", "setBackgroundColor", "isColour", "isColor", "getTextColour", "getTextColor", "getBackgroundColour", "getBackgroundColor", "blit", "setPaletteColour", "setPaletteColor", "getPaletteColour", "getPaletteColor"};
    }

    @Override
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                String text = args.length > 0 && args[0] != null ? args[0].toString() : "";
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                terminal.write(text);
                terminal.setCursorPos(terminal.getCursorX() + text.length(), terminal.getCursorY());
                return null;
            }
            case 1: {
                int value = ArgumentHelper.getInt(args, 0);
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                terminal.scroll(value);
                return null;
            }
            case 2: {
                int x = ArgumentHelper.getInt(args, 0) - 1;
                int y = ArgumentHelper.getInt(args, 1) - 1;
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                terminal.setCursorPos(x, y);
                return null;
            }
            case 3: {
                boolean blink = ArgumentHelper.getBoolean(args, 0);
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                terminal.setCursorBlink(blink);
                return null;
            }
            case 4: {
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                return new Object[]{terminal.getCursorX() + 1, terminal.getCursorY() + 1};
            }
            case 5: {
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                return new Object[]{terminal.getWidth(), terminal.getHeight()};
            }
            case 6: {
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                terminal.clear();
                return null;
            }
            case 7: {
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                terminal.clearLine();
                return null;
            }
            case 8: {
                int scale = (int)(ArgumentHelper.getReal(args, 0) * 2.0);
                if (scale < 1 || scale > 10) {
                    throw new LuaException("Expected number in range 0.5-5");
                }
                this.m_monitor.setTextScale(scale);
                return null;
            }
            case 9: 
            case 10: {
                int colour = TermAPI.parseColour(args);
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                terminal.setTextColour(colour);
                return null;
            }
            case 11: 
            case 12: {
                int colour = TermAPI.parseColour(args);
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                terminal.setBackgroundColour(colour);
                return null;
            }
            case 13: 
            case 14: {
                return new Object[]{this.m_monitor.getTerminal().isColour()};
            }
            case 15: 
            case 16: {
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                return TermAPI.encodeColour(terminal.getTextColour());
            }
            case 17: 
            case 18: {
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                return TermAPI.encodeColour(terminal.getBackgroundColour());
            }
            case 19: {
                String text = ArgumentHelper.getString(args, 0);
                String textColour = ArgumentHelper.getString(args, 1);
                String backgroundColour = ArgumentHelper.getString(args, 2);
                if (textColour.length() != text.length() || backgroundColour.length() != text.length()) {
                    throw new LuaException("Arguments must be the same length");
                }
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                terminal.blit(text, textColour, backgroundColour);
                terminal.setCursorPos(terminal.getCursorX() + text.length(), terminal.getCursorY());
                return null;
            }
            case 20: 
            case 21: {
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                int colour = 15 - TermAPI.parseColour(args);
                if (args.length == 2) {
                    int hex = ArgumentHelper.getInt(args, 1);
                    double[] rgb = Palette.decodeRGB8(hex);
                    TermAPI.setColour(terminal, colour, rgb[0], rgb[1], rgb[2]);
                } else {
                    double r = ArgumentHelper.getReal(args, 1);
                    double g = ArgumentHelper.getReal(args, 2);
                    double b = ArgumentHelper.getReal(args, 3);
                    TermAPI.setColour(terminal, colour, r, g, b);
                }
                return null;
            }
            case 22: 
            case 23: {
                Terminal terminal = this.m_monitor.getTerminal().getTerminal();
                Palette palette = terminal.getPalette();
                int colour = 15 - TermAPI.parseColour(args);
                if (palette != null) {
                    return ArrayUtils.toObject((double[])palette.getColour(colour));
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public void attach(@Nonnull IComputerAccess computer) {
        this.m_monitor.addComputer(computer);
    }

    @Override
    public void detach(@Nonnull IComputerAccess computer) {
        this.m_monitor.removeComputer(computer);
    }

    @Override
    public boolean equals(IPeripheral other) {
        if (other != null && other instanceof MonitorPeripheral) {
            MonitorPeripheral otherMonitor = (MonitorPeripheral)other;
            if (otherMonitor.m_monitor == this.m_monitor) {
                return true;
            }
        }
        return false;
    }
}

