/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryUtil {
    public static boolean areItemsEqual(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return a == b || ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    public static boolean areItemsStackable(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        return a == b || ItemHandlerHelper.canItemStacksStack((ItemStack)a, (ItemStack)b);
    }

    @Nonnull
    public static ItemStack copyItem(@Nonnull ItemStack a) {
        return a.func_77946_l();
    }

    public static IItemHandler getInventory(World world, BlockPos pos, EnumFacing side) {
        Entity entity;
        EnumFacing dir;
        Vec3d vecDir;
        Vec3d vecStart;
        Pair<Entity, Vec3d> hit;
        TileEntity tileEntity;
        int y = pos.func_177956_o();
        if (y >= 0 && y < world.func_72800_K() && (tileEntity = world.func_175625_s(pos)) != null) {
            IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
            if (itemHandler != null) {
                return itemHandler;
            }
            if (side != null && tileEntity instanceof ISidedInventory) {
                return new SidedInvWrapper((ISidedInventory)tileEntity, side);
            }
            if (tileEntity instanceof IInventory) {
                return new InvWrapper((IInventory)tileEntity);
            }
        }
        if ((hit = WorldUtil.rayTraceEntities(world, vecStart = new Vec3d((double)pos.func_177958_n() + 0.5 + 0.6 * (double)side.func_82601_c(), (double)pos.func_177956_o() + 0.5 + 0.6 * (double)side.func_96559_d(), (double)pos.func_177952_p() + 0.5 + 0.6 * (double)side.func_82599_e()), vecDir = new Vec3d((double)(dir = side.func_176734_d()).func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e()), 1.1)) != null && (entity = (Entity)hit.getKey()) instanceof IInventory) {
            return new InvWrapper((IInventory)entity);
        }
        return null;
    }

    @Nonnull
    public static ItemStack storeItems(@Nonnull ItemStack itemstack, IItemHandler inventory, int start, int range, int begin) {
        int[] slots = InventoryUtil.makeSlotList(start, range, begin);
        return InventoryUtil.storeItems(itemstack, inventory, slots);
    }

    @Nonnull
    public static ItemStack storeItems(@Nonnull ItemStack itemstack, IItemHandler inventory, int begin) {
        int[] slots = InventoryUtil.makeSlotList(0, inventory.getSlots(), begin);
        return InventoryUtil.storeItems(itemstack, inventory, slots);
    }

    @Nonnull
    public static ItemStack storeItems(@Nonnull ItemStack itemstack, IItemHandler inventory) {
        int[] slots = InventoryUtil.makeSlotList(0, inventory.getSlots(), 0);
        return InventoryUtil.storeItems(itemstack, inventory, slots);
    }

    @Nonnull
    public static ItemStack takeItems(int count, IItemHandler inventory, int start, int range, int begin) {
        int[] slots = InventoryUtil.makeSlotList(start, range, begin);
        return InventoryUtil.takeItems(count, inventory, slots);
    }

    @Nonnull
    public static ItemStack takeItems(int count, IItemHandler inventory, int begin) {
        int[] slots = InventoryUtil.makeSlotList(0, inventory.getSlots(), begin);
        return InventoryUtil.takeItems(count, inventory, slots);
    }

    @Nonnull
    public static ItemStack takeItems(int count, IItemHandler inventory) {
        int[] slots = InventoryUtil.makeSlotList(0, inventory.getSlots(), 0);
        return InventoryUtil.takeItems(count, inventory, slots);
    }

    private static int[] makeSlotList(int start, int range, int begin) {
        if (start < 0 || range == 0) {
            return null;
        }
        int[] slots = new int[range];
        for (int n = 0; n < slots.length; ++n) {
            slots[n] = start + (n + (begin - start)) % range;
        }
        return slots;
    }

    @Nonnull
    private static ItemStack storeItems(@Nonnull ItemStack stack, IItemHandler inventory, int[] slots) {
        if (slots == null || slots.length == 0) {
            return stack;
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack remainder = stack.func_77946_l();
        for (int slot : slots) {
            if (remainder.func_190926_b()) break;
            remainder = inventory.insertItem(slot, remainder, false);
        }
        return InventoryUtil.areItemsEqual(stack, remainder) ? stack : remainder;
    }

    @Nonnull
    private static ItemStack takeItems(int count, IItemHandler inventory, int[] slots) {
        if (slots == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack partialStack = ItemStack.field_190927_a;
        int countRemaining = count;
        for (int slot : slots) {
            ItemStack extracted;
            if (countRemaining <= 0) break;
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.func_190926_b() || !partialStack.func_190926_b() && !InventoryUtil.areItemsStackable(stack, partialStack) || (extracted = inventory.extractItem(slot, countRemaining, false)).func_190926_b()) continue;
            countRemaining -= extracted.func_190916_E();
            if (partialStack.func_190926_b()) {
                partialStack = extracted;
                continue;
            }
            partialStack.func_190917_f(extracted.func_190916_E());
        }
        return partialStack;
    }
}

