/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReflectionUtil {
    public static Class<?> getOptionalClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Class<?> getOptionalInnerClass(Class<?> enclosingClass, String name) {
        if (enclosingClass != null) {
            try {
                Class<?>[] declaredClasses = enclosingClass.getDeclaredClasses();
                if (declaredClasses != null) {
                    for (Class<?> declaredClass : declaredClasses) {
                        if (!declaredClass.getSimpleName().equals(name)) continue;
                        return declaredClass;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Method getOptionalMethod(Class<?> clazz, String name, Class<?>[] arguments) {
        if (clazz != null) {
            try {
                return clazz.getDeclaredMethod(name, arguments);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> Constructor<T> getOptionalConstructor(Class<T> clazz, Class<?>[] arguments) {
        if (clazz != null) {
            try {
                return clazz.getConstructor(arguments);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Field getOptionalField(Class<?> clazz, String name) {
        if (clazz != null) {
            try {
                Field field = clazz.getDeclaredField(name);
                if (field != null) {
                    try {
                        field.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return field;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T safeNew(Constructor<T> constructor, Object[] arguments, Class<T> resultClass) {
        if (constructor != null) {
            try {
                T result = constructor.newInstance(arguments);
                if (result != null && resultClass.isInstance(result)) {
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean safeInstanceOf(Object object, Class<?> clazz) {
        if (clazz != null) {
            return clazz.isInstance(object);
        }
        return false;
    }

    public static void safeInvoke(Method method, Object object, Object[] arguments) {
        if (method != null) {
            try {
                if (object == null || method.getClass().isInstance(object)) {
                    method.invoke(object, arguments);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> T safeInvoke(Method method, Object object, Object[] arguments, Class<T> resultClass) {
        if (method != null) {
            try {
                Object result;
                if ((object == null && Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().isInstance(object)) && (result = method.invoke(object, arguments)) != null && resultClass.isInstance(result)) {
                    return (T)result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T safeGet(Field field, Object object, Class<T> resultClass) {
        if (field != null) {
            try {
                Object result;
                if ((object == null && Modifier.isStatic(field.getModifiers()) || field.getDeclaringClass().isInstance(object)) && (result = field.get(object)) != null && resultClass.isInstance(result)) {
                    return (T)result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> T safeSet(Field field, Object object, T value) {
        if (field != null) {
            try {
                if (object == null || field.getClass().isInstance(object)) {
                    field.set(object, value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

