/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import org.luaj.vm2.Buffer;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.MathLib;
import org.luaj.vm2.lib.StringLib;

public class LuaString
extends LuaValue {
    public static LuaValue s_metatable;
    public final byte[] m_bytes;
    public final int m_offset;
    public final int m_length;
    private static final Hashtable index_java;

    private static final LuaString index_get(Hashtable hashtable, Object object) {
        WeakReference weakReference = (WeakReference)hashtable.get(object);
        return weakReference != null ? (LuaString)weakReference.get() : null;
    }

    private static final void index_set(Hashtable hashtable, Object object, LuaString luaString) {
        hashtable.put(object, new WeakReference<LuaString>(luaString));
    }

    public static LuaString valueOf(String string) {
        LuaString luaString = LuaString.index_get(index_java, string);
        if (luaString != null) {
            return luaString;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            char c = cArray[i];
            byArray[i] = c < '\u0100' ? (int)c : 63;
        }
        luaString = LuaString.valueOf(byArray, 0, byArray.length);
        LuaString.index_set(index_java, string, luaString);
        return luaString;
    }

    public static LuaString valueOf(byte[] byArray, int n, int n2) {
        return new LuaString(byArray, n, n2);
    }

    public static LuaString valueOf(char[] cArray) {
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return LuaString.valueOf(byArray, 0, n);
    }

    public static LuaString valueOf(byte[] byArray) {
        return LuaString.valueOf(byArray, 0, byArray.length);
    }

    private LuaString(byte[] byArray, int n, int n2) {
        this.m_bytes = byArray;
        this.m_offset = n;
        this.m_length = n2;
    }

    public boolean isstring() {
        return true;
    }

    public LuaValue getmetatable() {
        return s_metatable;
    }

    public int type() {
        return 4;
    }

    public String typename() {
        return "string";
    }

    public String tojstring() {
        char[] cArray = new char[this.m_length];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(this.m_bytes[this.m_offset + i] & 0xFF);
        }
        return new String(cArray);
    }

    public LuaValue get(LuaValue luaValue) {
        return s_metatable != null ? LuaString.gettable(this, luaValue) : StringLib.instance.get(luaValue);
    }

    public LuaValue neg() {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? super.neg() : LuaString.valueOf(-d);
    }

    public LuaValue add(LuaValue luaValue) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(ADD, luaValue) : luaValue.add(d);
    }

    public LuaValue add(double d) {
        return LuaString.valueOf(this.checkarith() + d);
    }

    public LuaValue add(int n) {
        return LuaString.valueOf(this.checkarith() + (double)n);
    }

    public LuaValue sub(LuaValue luaValue) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(SUB, luaValue) : luaValue.subFrom(d);
    }

    public LuaValue sub(double d) {
        return LuaString.valueOf(this.checkarith() - d);
    }

    public LuaValue sub(int n) {
        return LuaString.valueOf(this.checkarith() - (double)n);
    }

    public LuaValue subFrom(double d) {
        return LuaString.valueOf(d - this.checkarith());
    }

    public LuaValue mul(LuaValue luaValue) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(MUL, luaValue) : luaValue.mul(d);
    }

    public LuaValue mul(double d) {
        return LuaString.valueOf(this.checkarith() * d);
    }

    public LuaValue mul(int n) {
        return LuaString.valueOf(this.checkarith() * (double)n);
    }

    public LuaValue pow(LuaValue luaValue) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(POW, luaValue) : luaValue.powWith(d);
    }

    public LuaValue pow(double d) {
        return MathLib.dpow(this.checkarith(), d);
    }

    public LuaValue pow(int n) {
        return MathLib.dpow(this.checkarith(), n);
    }

    public LuaValue powWith(double d) {
        return MathLib.dpow(d, this.checkarith());
    }

    public LuaValue powWith(int n) {
        return MathLib.dpow(n, this.checkarith());
    }

    public LuaValue div(LuaValue luaValue) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(DIV, luaValue) : luaValue.divInto(d);
    }

    public LuaValue div(double d) {
        return LuaDouble.ddiv(this.checkarith(), d);
    }

    public LuaValue div(int n) {
        return LuaDouble.ddiv(this.checkarith(), n);
    }

    public LuaValue divInto(double d) {
        return LuaDouble.ddiv(d, this.checkarith());
    }

    public LuaValue mod(LuaValue luaValue) {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? this.arithmt(MOD, luaValue) : luaValue.modFrom(d);
    }

    public LuaValue mod(double d) {
        return LuaDouble.dmod(this.checkarith(), d);
    }

    public LuaValue mod(int n) {
        return LuaDouble.dmod(this.checkarith(), n);
    }

    public LuaValue modFrom(double d) {
        return LuaDouble.dmod(d, this.checkarith());
    }

    public LuaValue lt(LuaValue luaValue) {
        return luaValue.strcmp(this) > 0 ? LuaValue.TRUE : FALSE;
    }

    public boolean lt_b(LuaValue luaValue) {
        return luaValue.strcmp(this) > 0;
    }

    public boolean lt_b(int n) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public boolean lt_b(double d) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public LuaValue lteq(LuaValue luaValue) {
        return luaValue.strcmp(this) >= 0 ? LuaValue.TRUE : FALSE;
    }

    public boolean lteq_b(LuaValue luaValue) {
        return luaValue.strcmp(this) >= 0;
    }

    public boolean lteq_b(int n) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public boolean lteq_b(double d) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public LuaValue gt(LuaValue luaValue) {
        return luaValue.strcmp(this) < 0 ? LuaValue.TRUE : FALSE;
    }

    public boolean gt_b(LuaValue luaValue) {
        return luaValue.strcmp(this) < 0;
    }

    public boolean gt_b(int n) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public boolean gt_b(double d) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public LuaValue gteq(LuaValue luaValue) {
        return luaValue.strcmp(this) <= 0 ? LuaValue.TRUE : FALSE;
    }

    public boolean gteq_b(LuaValue luaValue) {
        return luaValue.strcmp(this) <= 0;
    }

    public boolean gteq_b(int n) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public boolean gteq_b(double d) {
        this.typerror("attempt to compare string with number");
        return false;
    }

    public LuaValue concat(LuaValue luaValue) {
        return luaValue.concatTo(this);
    }

    public Buffer concat(Buffer buffer) {
        return buffer.concatTo(this);
    }

    public LuaValue concatTo(LuaNumber luaNumber) {
        return this.concatTo(luaNumber.strvalue());
    }

    public LuaValue concatTo(LuaString luaString) {
        byte[] byArray = new byte[luaString.m_length + this.m_length];
        System.arraycopy(luaString.m_bytes, luaString.m_offset, byArray, 0, luaString.m_length);
        System.arraycopy(this.m_bytes, this.m_offset, byArray, luaString.m_length, this.m_length);
        return new LuaString(byArray, 0, byArray.length);
    }

    public int strcmp(LuaValue luaValue) {
        return -luaValue.strcmp(this);
    }

    public int strcmp(LuaString luaString) {
        int n = 0;
        for (int i = 0; n < this.m_length && i < luaString.m_length; ++n, ++i) {
            if (this.m_bytes[this.m_offset + n] == luaString.m_bytes[luaString.m_offset + i]) continue;
            return this.m_bytes[this.m_offset + n] - luaString.m_bytes[luaString.m_offset + i];
        }
        return this.m_length - luaString.m_length;
    }

    private double checkarith() {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            this.aritherror();
        }
        return d;
    }

    public int checkint() {
        return (int)this.checkdouble();
    }

    public LuaInteger checkinteger() {
        return LuaString.valueOf(this.checkint());
    }

    public long checklong() {
        return (long)this.checkdouble();
    }

    public double checkdouble() {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            this.argerror("number");
        }
        return d;
    }

    public LuaNumber checknumber() {
        return LuaString.valueOf(this.checkdouble());
    }

    public LuaNumber checknumber(String string) {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            LuaString.error(string);
        }
        return LuaString.valueOf(d);
    }

    public LuaValue tonumber() {
        return this.tonumber(10);
    }

    public boolean isnumber() {
        double d = this.scannumber(10);
        return !Double.isNaN(d);
    }

    public boolean isint() {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            return false;
        }
        int n = (int)d;
        return (double)n == d;
    }

    public boolean islong() {
        double d = this.scannumber(10);
        if (Double.isNaN(d)) {
            return false;
        }
        long l = (long)d;
        return (double)l == d;
    }

    public byte tobyte() {
        return (byte)this.toint();
    }

    public char tochar() {
        return (char)this.toint();
    }

    public double todouble() {
        double d = this.scannumber(10);
        return Double.isNaN(d) ? 0.0 : d;
    }

    public float tofloat() {
        return (float)this.todouble();
    }

    public int toint() {
        return (int)this.tolong();
    }

    public long tolong() {
        return (long)this.todouble();
    }

    public short toshort() {
        return (short)this.toint();
    }

    public double optdouble(double d) {
        return this.checknumber().checkdouble();
    }

    public int optint(int n) {
        return this.checknumber().checkint();
    }

    public LuaInteger optinteger(LuaInteger luaInteger) {
        return this.checknumber().checkinteger();
    }

    public long optlong(long l) {
        return this.checknumber().checklong();
    }

    public LuaNumber optnumber(LuaNumber luaNumber) {
        return this.checknumber().checknumber();
    }

    public LuaString optstring(LuaString luaString) {
        return this;
    }

    public LuaValue tostring() {
        return this;
    }

    public String optjstring(String string) {
        return this.tojstring();
    }

    public LuaString strvalue() {
        return this;
    }

    public LuaString substring(int n, int n2) {
        return new LuaString(this.m_bytes, this.m_offset + n, n2 - n);
    }

    public int hashCode() {
        int n = this.m_length;
        int n2 = (this.m_length >> 5) + 1;
        for (int i = this.m_length; i >= n2; i -= n2) {
            n ^= (n << 5) + (n >> 2) + (this.m_bytes[this.m_offset + i - 1] & 0xFF);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof LuaString) {
            return this.raweq((LuaString)object);
        }
        return false;
    }

    public LuaValue eq(LuaValue luaValue) {
        return luaValue.raweq(this) ? TRUE : FALSE;
    }

    public boolean eq_b(LuaValue luaValue) {
        return luaValue.raweq(this);
    }

    public boolean raweq(LuaValue luaValue) {
        return luaValue.raweq(this);
    }

    public boolean raweq(LuaString luaString) {
        if (this == luaString) {
            return true;
        }
        if (luaString.m_length != this.m_length) {
            return false;
        }
        if (luaString.m_bytes == this.m_bytes && luaString.m_offset == this.m_offset) {
            return true;
        }
        if (luaString.hashCode() != this.hashCode()) {
            return false;
        }
        for (int i = 0; i < this.m_length; ++i) {
            if (luaString.m_bytes[luaString.m_offset + i] == this.m_bytes[this.m_offset + i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(LuaString luaString, int n, LuaString luaString2, int n2, int n3) {
        return LuaString.equals(luaString.m_bytes, luaString.m_offset + n, luaString2.m_bytes, luaString2.m_offset + n2, n3);
    }

    public static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray.length < n + n3 || byArray2.length < n2 + n3) {
            return false;
        }
        while (--n3 >= 0) {
            if (byArray[n++] == byArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    public void write(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        dataOutputStream.write(this.m_bytes, this.m_offset + n, n2);
    }

    public LuaValue len() {
        return LuaInteger.valueOf(this.m_length);
    }

    public int length() {
        return this.m_length;
    }

    public int luaByte(int n) {
        return this.m_bytes[this.m_offset + n] & 0xFF;
    }

    public int charAt(int n) {
        if (n < 0 || n >= this.m_length) {
            throw new IndexOutOfBoundsException();
        }
        return this.luaByte(n);
    }

    public String checkjstring() {
        return this.tojstring();
    }

    public LuaString checkstring() {
        return this;
    }

    public InputStream toInputStream() {
        return new ByteArrayInputStream(this.m_bytes, this.m_offset, this.m_length);
    }

    public void copyInto(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.m_bytes, this.m_offset + n, byArray, n2, n3);
    }

    public int indexOfAny(LuaString luaString) {
        int n = this.m_offset + this.m_length;
        int n2 = luaString.m_offset + luaString.m_length;
        for (int i = this.m_offset; i < n; ++i) {
            for (int j = luaString.m_offset; j < n2; ++j) {
                if (this.m_bytes[i] != luaString.m_bytes[j]) continue;
                return i - this.m_offset;
            }
        }
        return -1;
    }

    public int indexOf(byte by, int n) {
        int n2 = this.m_offset + n;
        for (int i = 0; i < this.m_length; ++i) {
            if (this.m_bytes[n2++] != by) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(LuaString luaString, int n) {
        int n2 = luaString.length();
        int n3 = this.m_offset + this.m_length - n2;
        for (int i = this.m_offset + n; i <= n3; ++i) {
            if (!LuaString.equals(this.m_bytes, i, luaString.m_bytes, luaString.m_offset, n2)) continue;
            return i - this.m_offset;
        }
        return -1;
    }

    public int lastIndexOf(LuaString luaString) {
        int n;
        int n2 = luaString.length();
        for (int i = n = this.m_offset + this.m_length - n2; i >= this.m_offset; --i) {
            if (!LuaString.equals(this.m_bytes, i, luaString.m_bytes, luaString.m_offset, n2)) continue;
            return i - this.m_offset;
        }
        return -1;
    }

    private static String decodeAsUtf8(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        int n5 = 0;
        while (n3 < n4) {
            switch (0xE0 & byArray[n3++]) {
                case 224: {
                    ++n3;
                }
                case 192: {
                    ++n3;
                }
            }
            ++n5;
        }
        char[] cArray = new char[n5];
        n3 = n;
        n4 = n + n2;
        n5 = 0;
        while (n3 < n4) {
            int n6;
            cArray[n5++] = (char)((n6 = byArray[n3++]) >= 0 || n3 >= n4 ? n6 : (n6 < -32 || n3 + 1 >= n4 ? (n6 & 0x3F) << 6 | byArray[n3++] & 0x3F : (n6 & 0xF) << 12 | (byArray[n3++] & 0x3F) << 6 | byArray[n3++] & 0x3F));
        }
        return new String(cArray);
    }

    private static int lengthAsUtf8(char[] cArray) {
        int n;
        int n2 = n = cArray.length;
        while (--n2 >= 0) {
            char c = cArray[n2];
            if (c < '\u0080') continue;
            n += c >= '\u0800' ? 2 : 1;
        }
        return n;
    }

    private static void encodeToUtf8(char[] cArray, byte[] byArray, int n) {
        int n2 = cArray.length;
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i];
            if (c < '\u0080') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n3++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            byArray[n3++] = (byte)(0xE0 | c >> 12 & 0xF);
            byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray[n3++] = (byte)(0x80 | c & 0x3F);
        }
    }

    public boolean isValidUtf8() {
        boolean bl = false;
        int n = this.m_offset;
        int n2 = this.m_offset + this.m_length;
        int n3 = 0;
        while (n < n2) {
            byte by;
            if (!((by = this.m_bytes[n++]) >= 0 || (by & 0xE0) == 192 && n < n2 && (this.m_bytes[n++] & 0xC0) == 128 || (by & 0xF0) == 224 && n + 1 < n2 && (this.m_bytes[n++] & 0xC0) == 128 && (this.m_bytes[n++] & 0xC0) == 128)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public LuaValue tonumber(int n) {
        double d = this.scannumber(n);
        return Double.isNaN(d) ? NIL : LuaString.valueOf(d);
    }

    public double scannumber(int n) {
        if (n >= 2 && n <= 36) {
            double d;
            int n2;
            int n3 = this.m_offset + this.m_length;
            for (n2 = this.m_offset; n2 < n3 && this.m_bytes[n2] == 32; ++n2) {
            }
            while (n2 < n3 && this.m_bytes[n3 - 1] == 32) {
                --n3;
            }
            if (n2 >= n3) {
                return Double.NaN;
            }
            if (!(n != 10 && n != 16 || this.m_bytes[n2] != 48 || n2 + 1 >= n3 || this.m_bytes[n2 + 1] != 120 && this.m_bytes[n2 + 1] != 88)) {
                n = 16;
                n2 += 2;
            }
            return Double.isNaN(d = this.scanlong(n, n2, n3)) && n == 10 ? this.scandouble(n2, n3) : d;
        }
        return Double.NaN;
    }

    private double scanlong(int n, int n2, int n3) {
        int n4;
        long l = 0L;
        boolean bl = this.m_bytes[n2] == 45;
        int n5 = n4 = bl ? n2 + 1 : n2;
        while (n4 < n3) {
            int n6 = this.m_bytes[n4] - (n <= 10 || this.m_bytes[n4] >= 48 && this.m_bytes[n4] <= 57 ? 48 : (this.m_bytes[n4] >= 65 && this.m_bytes[n4] <= 90 ? 55 : 87));
            if (n6 < 0 || n6 >= n) {
                return Double.NaN;
            }
            l = l * (long)n + (long)n6;
            ++n4;
        }
        return bl ? (double)(-l) : (double)l;
    }

    private double scandouble(int n, int n2) {
        if (n2 > n + 64) {
            n2 = n + 64;
        }
        block5: for (int i = n; i < n2; ++i) {
            switch (this.m_bytes[i]) {
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: 
                case 101: {
                    continue block5;
                }
                default: {
                    return Double.NaN;
                }
            }
        }
        char[] cArray = new char[n2 - n];
        for (int i = n; i < n2; ++i) {
            cArray[i - n] = (char)this.m_bytes[i];
        }
        try {
            return Double.parseDouble(new String(cArray));
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    static {
        index_java = new Hashtable();
    }
}

