/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lua2java;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.ast.Block;
import org.luaj.vm2.ast.Chunk;
import org.luaj.vm2.ast.Exp;
import org.luaj.vm2.ast.FuncArgs;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.Name;
import org.luaj.vm2.ast.NameResolver;
import org.luaj.vm2.ast.ParList;
import org.luaj.vm2.ast.Stat;
import org.luaj.vm2.ast.TableConstructor;
import org.luaj.vm2.ast.TableField;
import org.luaj.vm2.ast.Variable;
import org.luaj.vm2.ast.Visitor;
import org.luaj.vm2.lua2java.JavaScope;

public class JavaCodeGen {
    final Chunk chunk;
    final String packagename;
    final String classname;
    Writer writer;

    public JavaCodeGen(Chunk chunk, Writer writer, String string, String string2) {
        this.chunk = chunk;
        this.writer = writer;
        this.packagename = string;
        this.classname = string2;
        chunk.accept(new NameResolver());
        chunk.accept(new JavaClassWriterVisitor());
    }

    private static String quotedStringInitializer(LuaString luaString) {
        byte[] byArray = luaString.m_bytes;
        int n = luaString.m_offset;
        int n2 = luaString.m_length;
        StringBuffer stringBuffer = new StringBuffer(n2 + 2);
        if (!luaString.isValidUtf8()) {
            stringBuffer.append("new byte[]{");
            block15: for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                byte by = byArray[n + i];
                switch (by) {
                    case 10: {
                        stringBuffer.append("'\\n'");
                        continue block15;
                    }
                    case 13: {
                        stringBuffer.append("'\\r'");
                        continue block15;
                    }
                    case 9: {
                        stringBuffer.append("'\\t'");
                        continue block15;
                    }
                    case 92: {
                        stringBuffer.append("'\\\\'");
                        continue block15;
                    }
                    default: {
                        if (by >= 32) {
                            stringBuffer.append('\'');
                            stringBuffer.append((char)by);
                            stringBuffer.append('\'');
                            continue block15;
                        }
                        stringBuffer.append(String.valueOf(by));
                    }
                }
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        stringBuffer.append('\"');
        block16: for (int i = 0; i < n2; ++i) {
            byte by = byArray[n + i];
            switch (by) {
                case 8: {
                    stringBuffer.append("\\b");
                    continue block16;
                }
                case 12: {
                    stringBuffer.append("\\f");
                    continue block16;
                }
                case 10: {
                    stringBuffer.append("\\n");
                    continue block16;
                }
                case 13: {
                    stringBuffer.append("\\r");
                    continue block16;
                }
                case 9: {
                    stringBuffer.append("\\t");
                    continue block16;
                }
                case 34: {
                    stringBuffer.append("\\\"");
                    continue block16;
                }
                case 92: {
                    stringBuffer.append("\\\\");
                    continue block16;
                }
                default: {
                    if (by >= 32) {
                        stringBuffer.append((char)by);
                        continue block16;
                    }
                    int n3 = 0xFF & by;
                    if (n3 >= 192 && i + 1 < n2) {
                        if (n3 >= 224 && i + 2 < n2) {
                            n3 = (n3 & 0xF) << 12 | (0x3F & byArray[i + 1]) << 6 | 0x3F & byArray[i + 2];
                            i += 2;
                        } else {
                            n3 = (n3 & 0x1F) << 6 | 0x3F & byArray[++i];
                        }
                    }
                    stringBuffer.append("\\u");
                    stringBuffer.append(Integer.toHexString(65536 + n3).substring(1));
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    class JavaClassWriterVisitor
    extends Visitor {
        JavaScope javascope = null;
        List constantDeclarations = new ArrayList();
        Map stringConstants = new HashMap();
        Map numberConstants = new HashMap();
        String indent = "";
        Map callerExpects = new HashMap();

        JavaClassWriterVisitor() {
        }

        void addindent() {
            this.indent = this.indent + "   ";
        }

        void subindent() {
            this.indent = this.indent.substring(3);
        }

        void out(String string) {
            try {
                JavaCodeGen.this.writer.write(string);
            }
            catch (IOException iOException) {
                throw new RuntimeException("write failed: " + iOException, iOException);
            }
        }

        void outi(String string) {
            this.out(this.indent);
            this.out(string);
        }

        void outl(String string) {
            this.outi(string);
            this.out("\n");
        }

        void outr(String string) {
            this.out(string);
            this.out("\n");
        }

        void outb(String string) {
            this.outl(string);
            this.addindent();
        }

        void oute(String string) {
            this.subindent();
            this.outl(string);
        }

        public void visit(Chunk chunk) {
            if (JavaCodeGen.this.packagename != null) {
                this.outl("package " + JavaCodeGen.this.packagename + ";");
            }
            this.outl("import org.luaj.vm2.*;");
            this.outl("import org.luaj.vm2.lib.*;");
            this.outb("public class " + JavaCodeGen.this.classname + " extends VarArgFunction {");
            this.outl("public Varargs onInvoke(Varargs $arg) {");
            this.addindent();
            this.javascope = JavaScope.newJavaScope(chunk);
            this.writeBodyBlock(chunk.block);
            this.oute("}");
            int n = this.constantDeclarations.size();
            for (int i = 0; i < n; ++i) {
                this.outl((String)this.constantDeclarations.get(i));
            }
            this.subindent();
            this.outi("}");
        }

        void writeBodyBlock(Block block) {
            if (this.javascope.needsbinoptmp) {
                this.outl("LuaValue $b;");
            }
            super.visit(block);
            if (!this.endsInReturn(block)) {
                this.outl("return NONE;");
            }
        }

        public void visit(Block block) {
            this.outb("{");
            super.visit(block);
            this.oute("}");
        }

        private boolean endsInReturn(Block block) {
            int n = block.stats.size();
            if (n <= 0) {
                return false;
            }
            Stat stat = (Stat)block.stats.get(n - 1);
            if (stat instanceof Stat.Return || stat instanceof Stat.Break) {
                return true;
            }
            if (this.isInfiniteLoop(stat)) {
                return true;
            }
            if (stat instanceof Stat.IfThenElse) {
                Stat.IfThenElse ifThenElse = (Stat.IfThenElse)stat;
                if (ifThenElse.elseblock == null || !this.endsInReturn(ifThenElse.ifblock) || !this.endsInReturn(ifThenElse.elseblock)) {
                    return false;
                }
                if (ifThenElse.elseifblocks != null) {
                    int n2 = ifThenElse.elseifblocks.size();
                    for (int i = 0; i < n2; ++i) {
                        if (this.endsInReturn((Block)ifThenElse.elseifblocks.get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        private boolean isInfiniteLoop(Stat stat) {
            if (stat instanceof Stat.WhileDo && "true".equals(this.evalBoolean(((Stat.WhileDo)stat).exp))) {
                return true;
            }
            return stat instanceof Stat.RepeatUntil && "false".equals(this.evalBoolean(((Stat.RepeatUntil)stat).exp));
        }

        public void visit(Stat.Return return_) {
            int n = return_.nreturns();
            switch (n) {
                case 0: {
                    this.outl("return NONE;");
                    break;
                }
                case 1: {
                    this.outl("return " + this.evalLuaValue((Exp)return_.values.get(0)) + ";");
                    break;
                }
                default: {
                    if (return_.values.size() == 1 && ((Exp)return_.values.get(0)).isfunccall()) {
                        this.tailCall((Exp)return_.values.get(0));
                        break;
                    }
                    this.outl("return " + this.evalListAsVarargs(return_.values) + ";");
                }
            }
        }

        public void visit(Exp.AnonFuncDef anonFuncDef) {
            super.visit(anonFuncDef);
        }

        public void visit(Stat.Assign assign) {
            this.multiAssign(assign.vars, assign.exps);
        }

        public void visit(Stat.LocalAssign localAssign) {
            int n;
            List list = localAssign.names;
            List list2 = localAssign.values;
            int n2 = list.size();
            int n3 = list2 != null ? list2.size() : 0;
            boolean bl = n3 > 0 && n3 < n2 && ((Exp)list2.get(n3 - 1)).isvarargexp();
            for (n = 0; n < n2 && n < (bl ? n3 - 1 : n3); ++n) {
                if (((Name)list.get((int)n)).variable.isConstant()) continue;
                this.singleLocalDeclareAssign((Name)list.get(n), this.evalLuaValue((Exp)list2.get(n)));
            }
            if (bl) {
                String string = this.javascope.getJavaName(this.tmpJavaVar((String)"t").variable);
                this.outl("final Varargs " + string + " = " + this.evalVarargs((Exp)list2.get(n3 - 1)) + ";");
                for (int i = n3 - 1; i < n2; ++i) {
                    this.singleLocalDeclareAssign((Name)list.get(i), string + (i == n3 - 1 ? ".arg1()" : ".arg(" + (i - n3 + 2) + ")"));
                }
            } else {
                for (n = n3; n < n2; ++n) {
                    if (((Name)list.get((int)n)).variable.isConstant()) continue;
                    this.singleLocalDeclareAssign((Name)list.get(n), "NIL");
                }
            }
            for (int i = n2; i < n3; ++i) {
                String string = this.javascope.getJavaName(this.tmpJavaVar((String)"t").variable);
                this.outl("final Varargs " + string + " = " + this.evalVarargs((Exp)list2.get(i)));
            }
        }

        private void multiAssign(List list, List list2) {
            final boolean[] blArray = new boolean[]{false};
            if (list2.size() > 1) {
                new Visitor(){

                    public void visit(FuncBody funcBody) {
                    }

                    public void visit(Exp.FieldExp fieldExp) {
                        blArray[0] = true;
                    }

                    public void visit(Exp.FuncCall funcCall) {
                        blArray[0] = true;
                    }

                    public void visit(Exp.IndexExp indexExp) {
                        blArray[0] = true;
                    }

                    public void visit(Exp.MethodCall methodCall) {
                        blArray[0] = true;
                    }

                    public void visit(Exp.NameExp nameExp) {
                        blArray[0] = true;
                    }
                }.visitExps(list2);
            }
            if (blArray[0]) {
                this.tmpvarsMultiAssign(list, list2);
            } else {
                this.directMultiAssign(list, list2);
            }
        }

        private void directMultiAssign(List list, List list2) {
            int n;
            int n2 = list.size();
            int n3 = list2 != null ? list2.size() : 0;
            boolean bl = n3 > 0 && n3 < n2 && ((Exp)list2.get(n3 - 1)).isvarargexp();
            for (n = 0; n < n2 && n < (bl ? n3 - 1 : n3); ++n) {
                this.singleVarOrNameAssign(list.get(n), this.evalLuaValue((Exp)list2.get(n)));
            }
            if (bl) {
                String string = this.javascope.getJavaName(this.tmpJavaVar((String)"v").variable);
                this.outl("final Varargs " + string + " = " + this.evalVarargs((Exp)list2.get(n3 - 1)) + ";");
                for (int i = n3 - 1; i < n2; ++i) {
                    this.singleVarOrNameAssign(list.get(i), string + (i == n3 - 1 ? ".arg1()" : ".arg(" + (i - n3 + 2) + ")"));
                }
            } else {
                for (n = n3; n < n2; ++n) {
                    this.singleVarOrNameAssign(list.get(n), "NIL");
                }
            }
            for (int i = n2; i < n3; ++i) {
                String string = this.javascope.getJavaName(this.tmpJavaVar((String)"tmp").variable);
                this.outl("final Varargs " + string + " = " + this.evalVarargs((Exp)list2.get(i)));
            }
        }

        private void tmpvarsMultiAssign(List list, List list2) {
            int n;
            int n2 = list.size();
            int n3 = list2 != null ? list2.size() : 0;
            boolean bl = n3 > 0 && n3 < n2 && ((Exp)list2.get(n3 - 1)).isvarargexp();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < n3; ++n) {
                arrayList.add(this.javascope.getJavaName(this.tmpJavaVar((String)"t").variable));
                if (bl && n == n3 - 1) {
                    this.outl("final Varargs " + arrayList.get(n) + " = " + this.evalVarargs((Exp)list2.get(n)) + ";");
                    continue;
                }
                this.outl("final LuaValue " + arrayList.get(n) + " = " + this.evalLuaValue((Exp)list2.get(n)) + ";");
            }
            for (n = 0; n < n2; ++n) {
                if (n < (bl ? n3 - 1 : n3)) {
                    this.singleVarOrNameAssign(list.get(n), (String)arrayList.get(n));
                    continue;
                }
                if (bl) {
                    this.singleVarOrNameAssign(list.get(n), arrayList.get(n3 - 1) + (n == n3 - 1 ? ".arg1()" : ".arg(" + (n - n3 + 2) + ")"));
                    continue;
                }
                this.singleVarOrNameAssign(list.get(n), "NIL");
            }
        }

        private void singleVarOrNameAssign(Object object, final String string) {
            Visitor visitor = new Visitor(){

                public void visit(Exp.FieldExp fieldExp) {
                    JavaClassWriterVisitor.this.outl(JavaClassWriterVisitor.this.evalLuaValue(fieldExp.lhs) + ".set(" + JavaClassWriterVisitor.this.evalStringConstant(fieldExp.name.name) + "," + string + ");");
                }

                public void visit(Exp.IndexExp indexExp) {
                    JavaClassWriterVisitor.this.outl(JavaClassWriterVisitor.this.evalLuaValue(indexExp.lhs) + ".set(" + JavaClassWriterVisitor.this.evalLuaValue(indexExp.exp) + "," + string + ");");
                }

                public void visit(Exp.NameExp nameExp) {
                    JavaClassWriterVisitor.this.singleAssign(nameExp.name, string);
                }
            };
            if (object instanceof Exp.VarExp) {
                ((Exp.VarExp)object).accept(visitor);
            } else if (object instanceof Name) {
                this.singleAssign((Name)object, string);
            } else {
                throw new IllegalStateException("can't assign to " + object.getClass());
            }
        }

        private void singleAssign(Name name, String string) {
            if (name.variable.isLocal()) {
                if (name.variable.isConstant()) {
                    return;
                }
                this.outi("");
                this.singleReference(name);
                this.outr(" = " + string + ";");
            } else {
                this.outl("env.set(" + this.evalStringConstant(name.name) + "," + string + ");");
            }
        }

        private void singleReference(Name name) {
            if (name.variable.isLocal()) {
                if (name.variable.isConstant()) {
                    this.out(this.evalConstant(name.variable.initialValue));
                    return;
                }
                this.out(this.javascope.getJavaName(name.variable));
                if (name.variable.isupvalue && name.variable.hasassignments) {
                    this.out("[0]");
                }
            } else {
                this.out("env.get(" + this.evalStringConstant(name.name) + ")");
            }
        }

        private void singleLocalDeclareAssign(Name name, String string) {
            this.singleLocalDeclareAssign(name.variable, string);
        }

        private void singleLocalDeclareAssign(Variable variable, String string) {
            String string2 = this.javascope.getJavaName(variable);
            if (variable.isConstant()) {
                return;
            }
            if (variable.isupvalue && variable.hasassignments) {
                this.outl("final LuaValue[] " + string2 + " = {" + string + "};");
            } else if (variable.isupvalue) {
                this.outl("final LuaValue " + string2 + (string != null ? " = " + string : "") + ";");
            } else {
                this.outl((variable.hasassignments ? "LuaValue " : "final LuaValue ") + string2 + (string != null ? " = " + string : "") + ";");
            }
        }

        public void visit(Stat.Break break_) {
            this.outl("break;");
        }

        private Writer pushWriter() {
            Writer writer = JavaCodeGen.this.writer;
            JavaCodeGen.this.writer = new CharArrayWriter();
            return writer;
        }

        private String popWriter(Writer writer) {
            Writer writer2 = JavaCodeGen.this.writer;
            JavaCodeGen.this.writer = writer;
            return writer2.toString();
        }

        public String evalListAsVarargs(List list) {
            int n = list != null ? list.size() : 0;
            switch (n) {
                case 0: {
                    return "NONE";
                }
                case 1: {
                    return this.evalVarargs((Exp)list.get(0));
                }
            }
            Writer writer = this.pushWriter();
            this.out(n > 3 ? "varargsOf(new LuaValue[] {" : "varargsOf(");
            for (int i = 1; i < n; ++i) {
                this.out(this.evalLuaValue((Exp)list.get(i - 1)) + ",");
            }
            if (n > 3) {
                this.out("},");
            }
            this.out(this.evalVarargs((Exp)list.get(n - 1)) + ")");
            return this.popWriter(writer);
        }

        public String evalLuaValue(Exp exp) {
            Writer writer = this.pushWriter();
            this.callerExpects.put(exp, 1);
            exp.accept(this);
            return this.popWriter(writer);
        }

        public String evalVarargs(Exp exp) {
            Writer writer = this.pushWriter();
            this.callerExpects.put(exp, -1);
            exp.accept(this);
            return this.popWriter(writer);
        }

        public String evalBoolean(Exp exp) {
            Writer writer = this.pushWriter();
            exp.accept(new Visitor(){

                public void visit(Exp.UnopExp unopExp) {
                    switch (unopExp.op) {
                        case 19: {
                            String string = JavaClassWriterVisitor.this.evalBoolean(unopExp.rhs);
                            JavaClassWriterVisitor.this.out("true".equals(string) ? "false" : ("false".equals(string) ? "true" : "(!" + string + ")"));
                            break;
                        }
                        default: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(unopExp) + ".toboolean()");
                        }
                    }
                }

                public void visit(Exp.BinopExp binopExp) {
                    switch (binopExp.op) {
                        case 60: {
                            JavaClassWriterVisitor.this.out("(" + JavaClassWriterVisitor.this.evalBoolean(binopExp.lhs) + "&&" + JavaClassWriterVisitor.this.evalBoolean(binopExp.rhs) + ")");
                            return;
                        }
                        case 59: {
                            JavaClassWriterVisitor.this.out("(" + JavaClassWriterVisitor.this.evalBoolean(binopExp.lhs) + "||" + JavaClassWriterVisitor.this.evalBoolean(binopExp.rhs) + ")");
                            return;
                        }
                        case 63: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(binopExp.lhs) + ".gt_b(" + JavaClassWriterVisitor.this.evalLuaValue(binopExp.rhs) + ")");
                            return;
                        }
                        case 62: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(binopExp.lhs) + ".gteq_b(" + JavaClassWriterVisitor.this.evalLuaValue(binopExp.rhs) + ")");
                            return;
                        }
                        case 24: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(binopExp.lhs) + ".lt_b(" + JavaClassWriterVisitor.this.evalLuaValue(binopExp.rhs) + ")");
                            return;
                        }
                        case 25: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(binopExp.lhs) + ".lteq_b(" + JavaClassWriterVisitor.this.evalLuaValue(binopExp.rhs) + ")");
                            return;
                        }
                        case 23: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(binopExp.lhs) + ".eq_b(" + JavaClassWriterVisitor.this.evalLuaValue(binopExp.rhs) + ")");
                            return;
                        }
                        case 61: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(binopExp.lhs) + ".neq_b(" + JavaClassWriterVisitor.this.evalLuaValue(binopExp.rhs) + ")");
                            return;
                        }
                    }
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(binopExp) + ".toboolean()");
                }

                public void visit(Exp.Constant constant) {
                    switch (constant.value.type()) {
                        case 1: {
                            JavaClassWriterVisitor.this.out(constant.value.toboolean() ? "true" : "false");
                            break;
                        }
                        default: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(constant) + ".toboolean()");
                        }
                    }
                }

                public void visit(Exp.ParensExp parensExp) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalBoolean(parensExp.exp));
                }

                public void visit(Exp.VarargsExp varargsExp) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(varargsExp) + ".toboolean()");
                }

                public void visit(Exp.FieldExp fieldExp) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(fieldExp) + ".toboolean()");
                }

                public void visit(Exp.IndexExp indexExp) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(indexExp) + ".toboolean()");
                }

                public void visit(Exp.NameExp nameExp) {
                    if (nameExp.name.variable.isConstant()) {
                        JavaClassWriterVisitor.this.out(nameExp.name.variable.initialValue.toboolean() ? "true" : "false");
                        return;
                    }
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(nameExp) + ".toboolean()");
                }

                public void visit(Exp.FuncCall funcCall) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(funcCall) + ".toboolean()");
                }

                public void visit(Exp.MethodCall methodCall) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(methodCall) + ".toboolean()");
                }

                public void visit(TableConstructor tableConstructor) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(tableConstructor) + ".toboolean()");
                }
            });
            return this.popWriter(writer);
        }

        public String evalNumber(Exp exp) {
            Writer writer = this.pushWriter();
            exp.accept(new Visitor(){

                public void visit(Exp.UnopExp unopExp) {
                    switch (unopExp.op) {
                        case 20: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(unopExp.rhs) + ".length()");
                            break;
                        }
                        case 18: {
                            JavaClassWriterVisitor.this.out("(-" + JavaClassWriterVisitor.this.evalNumber(unopExp.rhs) + ")");
                            break;
                        }
                        default: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(unopExp) + ".checkdouble()");
                        }
                    }
                }

                public void visit(Exp.BinopExp binopExp) {
                    switch (binopExp.op) {
                        case 12: 
                        case 13: 
                        case 14: {
                            String string = binopExp.op == 12 ? "+" : (binopExp.op == 13 ? "-" : "*");
                            JavaClassWriterVisitor.this.out("(" + JavaClassWriterVisitor.this.evalNumber(binopExp.lhs) + string + JavaClassWriterVisitor.this.evalNumber(binopExp.rhs) + ")");
                            break;
                        }
                        case 17: {
                            JavaClassWriterVisitor.this.out("MathLib.dpow_d(" + JavaClassWriterVisitor.this.evalNumber(binopExp.lhs) + "," + JavaClassWriterVisitor.this.evalNumber(binopExp.rhs) + ")");
                            break;
                        }
                        case 15: {
                            JavaClassWriterVisitor.this.out("LuaDouble.ddiv_d(" + JavaClassWriterVisitor.this.evalNumber(binopExp.lhs) + "," + JavaClassWriterVisitor.this.evalNumber(binopExp.rhs) + ")");
                            break;
                        }
                        case 16: {
                            JavaClassWriterVisitor.this.out("LuaDouble.dmod_d(" + JavaClassWriterVisitor.this.evalNumber(binopExp.lhs) + "," + JavaClassWriterVisitor.this.evalNumber(binopExp.rhs) + ")");
                            break;
                        }
                        default: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(binopExp) + ".checkdouble()");
                        }
                    }
                }

                public void visit(Exp.Constant constant) {
                    switch (constant.value.type()) {
                        case 3: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalNumberLiteral(constant.value.checkdouble()));
                            break;
                        }
                        default: {
                            JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(constant) + ".checkdouble()");
                        }
                    }
                }

                public void visit(Exp.ParensExp parensExp) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalNumber(parensExp.exp));
                }

                public void visit(Exp.VarargsExp varargsExp) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(varargsExp) + ".checkdouble()");
                }

                public void visit(Exp.FieldExp fieldExp) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(fieldExp) + ".checkdouble()");
                }

                public void visit(Exp.IndexExp indexExp) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(indexExp) + ".checkdouble()");
                }

                public void visit(Exp.NameExp nameExp) {
                    if (nameExp.name.variable.isConstant() && nameExp.name.variable.initialValue.isnumber()) {
                        JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalNumberLiteral(nameExp.name.variable.initialValue.checkdouble()));
                        return;
                    }
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(nameExp) + ".checkdouble()");
                }

                public void visit(Exp.FuncCall funcCall) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(funcCall) + ".checkdouble()");
                }

                public void visit(Exp.MethodCall methodCall) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(methodCall) + ".checkdouble()");
                }

                public void visit(TableConstructor tableConstructor) {
                    JavaClassWriterVisitor.this.out(JavaClassWriterVisitor.this.evalLuaValue(tableConstructor) + ".checkdouble()");
                }
            });
            return this.popWriter(writer);
        }

        public void visit(Stat.FuncCallStat funcCallStat) {
            this.outi("");
            funcCallStat.funccall.accept(this);
            this.outr(";");
        }

        public void visit(Exp.BinopExp binopExp) {
            switch (binopExp.op) {
                case 59: 
                case 60: {
                    String string = binopExp.op == 60 ? "!" : "";
                    this.out("(" + string + "($b=" + this.evalLuaValue(binopExp.lhs) + ").toboolean()?$b:" + this.evalLuaValue(binopExp.rhs) + ")");
                    return;
                }
            }
            switch (binopExp.op) {
                case 12: {
                    this.out("valueOf(" + this.evalNumber(binopExp.lhs) + "+" + this.evalNumber(binopExp.rhs) + ")");
                    return;
                }
                case 13: {
                    this.out("valueOf(" + this.evalNumber(binopExp.lhs) + "-" + this.evalNumber(binopExp.rhs) + ")");
                    return;
                }
                case 14: {
                    this.out("valueOf(" + this.evalNumber(binopExp.lhs) + "*" + this.evalNumber(binopExp.rhs) + ")");
                    return;
                }
                case 17: {
                    this.out("MathLib.dpow(" + this.evalNumber(binopExp.lhs) + "," + this.evalNumber(binopExp.rhs) + ")");
                    return;
                }
                case 15: {
                    this.out("LuaDouble.ddiv(" + this.evalNumber(binopExp.lhs) + "," + this.evalNumber(binopExp.rhs) + ")");
                    return;
                }
                case 16: {
                    this.out("LuaDouble.dmod(" + this.evalNumber(binopExp.lhs) + "," + this.evalNumber(binopExp.rhs) + ")");
                    return;
                }
                case 63: {
                    this.out(this.evalLuaValue(binopExp.lhs) + ".gt(" + this.evalLuaValue(binopExp.rhs) + ")");
                    return;
                }
                case 62: {
                    this.out(this.evalLuaValue(binopExp.lhs) + ".gteq(" + this.evalLuaValue(binopExp.rhs) + ")");
                    return;
                }
                case 24: {
                    this.out(this.evalLuaValue(binopExp.lhs) + ".lt(" + this.evalLuaValue(binopExp.rhs) + ")");
                    return;
                }
                case 25: {
                    this.out(this.evalLuaValue(binopExp.lhs) + ".lteq(" + this.evalLuaValue(binopExp.rhs) + ")");
                    return;
                }
                case 23: {
                    this.out(this.evalLuaValue(binopExp.lhs) + ".eq(" + this.evalLuaValue(binopExp.rhs) + ")");
                    return;
                }
                case 61: {
                    this.out(this.evalLuaValue(binopExp.lhs) + ".neq(" + this.evalLuaValue(binopExp.rhs) + ")");
                    return;
                }
                case 21: {
                    if (this.isConcatExp(binopExp.rhs)) {
                        this.out(this.evalLuaValue(binopExp.lhs));
                        Exp exp = binopExp.rhs;
                        String string = "";
                        while (this.isConcatExp(exp)) {
                            this.out(".concat(" + this.evalLuaValue(((Exp.BinopExp)exp).lhs));
                            string = string + ')';
                            exp = ((Exp.BinopExp)exp).rhs;
                        }
                        this.out(".concat(" + this.evalLuaValue(exp) + ".buffer())");
                        this.out(string);
                        this.out(".value()");
                    } else {
                        this.out(this.evalLuaValue(binopExp.lhs) + ".concat(" + this.evalLuaValue(binopExp.rhs) + ")");
                    }
                    return;
                }
            }
            throw new IllegalStateException("unknown bin op:" + binopExp.op);
        }

        private boolean isConcatExp(Exp exp) {
            return exp instanceof Exp.BinopExp && ((Exp.BinopExp)exp).op == 21;
        }

        public void visit(Exp.UnopExp unopExp) {
            unopExp.rhs.accept(this);
            switch (unopExp.op) {
                case 19: {
                    this.out(".not()");
                    break;
                }
                case 20: {
                    this.out(".len()");
                    break;
                }
                case 18: {
                    this.out(".neg()");
                }
            }
        }

        public void visit(Exp.Constant constant) {
            this.out(this.evalConstant(constant.value));
        }

        protected String evalConstant(LuaValue luaValue) {
            switch (luaValue.type()) {
                case 4: {
                    return this.evalLuaStringConstant(luaValue.checkstring());
                }
                case 0: {
                    return "NIL";
                }
                case 1: {
                    return luaValue.toboolean() ? "TRUE" : "FALSE";
                }
                case 3: {
                    return this.evalNumberConstant(luaValue.todouble());
                }
            }
            throw new IllegalStateException("unknown constant type: " + luaValue.typename());
        }

        private String evalStringConstant(String string) {
            return this.evalLuaStringConstant(LuaValue.valueOf(string));
        }

        private String evalLuaStringConstant(LuaString luaString) {
            if (this.stringConstants.containsKey(luaString)) {
                return (String)this.stringConstants.get(luaString);
            }
            String string = JavaCodeGen.quotedStringInitializer(luaString);
            String string2 = this.javascope.createConstantName(luaString.tojstring());
            this.constantDeclarations.add("static final LuaValue " + string2 + " = valueOf(" + string + ");");
            this.stringConstants.put(luaString, string2);
            return string2;
        }

        private String evalNumberConstant(double d) {
            if (d == 0.0) {
                return "ZERO";
            }
            if (d == -1.0) {
                return "MINUSONE";
            }
            if (d == 1.0) {
                return "ONE";
            }
            if (this.numberConstants.containsKey(d)) {
                return (String)this.numberConstants.get(d);
            }
            String string = this.evalNumberLiteral(d);
            String string2 = this.javascope.createConstantName(string);
            this.constantDeclarations.add("static final LuaValue " + string2 + " = valueOf(" + string + ");");
            this.numberConstants.put(d, string2);
            return string2;
        }

        private String evalNumberLiteral(double d) {
            int n = (int)d;
            String string = d == (double)n ? String.valueOf(n) : String.valueOf(d);
            return d < 0.0 ? "(" + string + ")" : string;
        }

        public void visit(Exp.FieldExp fieldExp) {
            fieldExp.lhs.accept(this);
            this.out(".get(" + this.evalStringConstant(fieldExp.name.name) + ")");
        }

        public void visit(Exp.IndexExp indexExp) {
            indexExp.lhs.accept(this);
            this.out(".get(");
            indexExp.exp.accept(this);
            this.out(")");
        }

        public void visit(Exp.NameExp nameExp) {
            this.singleReference(nameExp.name);
        }

        public void visit(Exp.ParensExp parensExp) {
            if (parensExp.exp.isvarargexp()) {
                this.out(this.evalLuaValue(parensExp.exp));
            } else {
                parensExp.exp.accept(this);
            }
        }

        public void visit(Exp.VarargsExp varargsExp) {
            int n = this.callerExpects.containsKey(varargsExp) ? (Integer)this.callerExpects.get(varargsExp) : 0;
            this.out(n == 1 ? "$arg.arg1()" : "$arg");
        }

        public void visit(Exp.MethodCall methodCall) {
            int n;
            List list = methodCall.args.exps;
            int n2 = list != null ? list.size() : 0;
            int n3 = n = this.callerExpects.containsKey(methodCall) ? (Integer)this.callerExpects.get(methodCall) : 0;
            if (n == -1) {
                n2 = -1;
            }
            this.out(this.evalLuaValue(methodCall.lhs));
            switch (n2) {
                case 0: {
                    this.out(".method(" + this.evalStringConstant(methodCall.name) + ")");
                    break;
                }
                case 1: 
                case 2: {
                    this.out(".method(" + this.evalStringConstant(methodCall.name) + ",");
                    methodCall.args.accept(this);
                    this.out(")");
                    break;
                }
                default: {
                    this.out(".invokemethod(" + this.evalStringConstant(methodCall.name) + (list == null || list.size() == 0 ? "" : "," + this.evalListAsVarargs(methodCall.args.exps)) + ")");
                    if (n != 1) break;
                    this.out(".arg1()");
                }
            }
        }

        public void visit(Exp.FuncCall funcCall) {
            int n;
            int n2;
            List list = funcCall.args.exps;
            int n3 = n2 = list != null ? list.size() : 0;
            if (n2 > 0 && ((Exp)list.get(n2 - 1)).isvarargexp()) {
                n2 = -1;
            }
            int n4 = n = this.callerExpects.containsKey(funcCall) ? (Integer)this.callerExpects.get(funcCall) : 0;
            if (n == -1) {
                n2 = -1;
            }
            this.out(this.evalLuaValue(funcCall.lhs));
            switch (n2) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.out(".call(");
                    funcCall.args.accept(this);
                    this.out(")");
                    break;
                }
                default: {
                    this.out(".invoke(" + (list == null || list.size() == 0 ? "" : this.evalListAsVarargs(list)) + ")");
                    if (n != 1) break;
                    this.out(".arg1()");
                }
            }
        }

        public void tailCall(Exp exp) {
            if (exp instanceof Exp.MethodCall) {
                Exp.MethodCall methodCall = (Exp.MethodCall)exp;
                this.outl("return new TailcallVarargs(" + this.evalLuaValue(methodCall.lhs) + "," + this.evalStringConstant(methodCall.name) + "," + this.evalListAsVarargs(methodCall.args.exps) + ");");
            } else if (exp instanceof Exp.FuncCall) {
                Exp.FuncCall funcCall = (Exp.FuncCall)exp;
                this.outl("return new TailcallVarargs(" + this.evalLuaValue(funcCall.lhs) + "," + this.evalListAsVarargs(funcCall.args.exps) + ");");
            } else {
                throw new IllegalArgumentException("can't tail call " + exp);
            }
        }

        public void visit(FuncArgs funcArgs) {
            int n;
            if (funcArgs.exps != null && (n = funcArgs.exps.size()) > 0) {
                for (int i = 1; i < n; ++i) {
                    this.out(this.evalLuaValue((Exp)funcArgs.exps.get(i - 1)) + ",");
                }
                this.out(this.evalVarargs((Exp)funcArgs.exps.get(n - 1)));
            }
        }

        public void visit(FuncBody funcBody) {
            int n;
            this.javascope = this.javascope.pushJavaScope(funcBody);
            int n2 = this.javascope.nreturns;
            int n3 = n = funcBody.parlist.names != null ? funcBody.parlist.names.size() : 0;
            if (n2 >= 0 && n2 <= 1 && n <= 3 && !funcBody.parlist.isvararg) {
                switch (n) {
                    case 0: {
                        this.outr("new ZeroArgFunction(env) {");
                        this.addindent();
                        this.outb("public LuaValue call() {");
                        break;
                    }
                    case 1: {
                        this.outr("new OneArgFunction(env) {");
                        this.addindent();
                        this.outb("public LuaValue call(" + this.declareArg((Name)funcBody.parlist.names.get(0)) + ") {");
                        this.assignArg((Name)funcBody.parlist.names.get(0));
                        break;
                    }
                    case 2: {
                        this.outr("new TwoArgFunction(env) {");
                        this.addindent();
                        this.outb("public LuaValue call(" + this.declareArg((Name)funcBody.parlist.names.get(0)) + "," + this.declareArg((Name)funcBody.parlist.names.get(1)) + ") {");
                        this.assignArg((Name)funcBody.parlist.names.get(0));
                        this.assignArg((Name)funcBody.parlist.names.get(1));
                        break;
                    }
                    case 3: {
                        this.outr("new ThreeArgFunction(env) {");
                        this.addindent();
                        this.outb("public LuaValue call(" + this.declareArg((Name)funcBody.parlist.names.get(0)) + "," + this.declareArg((Name)funcBody.parlist.names.get(1)) + "," + this.declareArg((Name)funcBody.parlist.names.get(2)) + ") {");
                        this.assignArg((Name)funcBody.parlist.names.get(0));
                        this.assignArg((Name)funcBody.parlist.names.get(1));
                        this.assignArg((Name)funcBody.parlist.names.get(2));
                    }
                }
            } else {
                Object object;
                this.outr("new VarArgFunction(env) {");
                this.addindent();
                this.outb("public Varargs invoke(Varargs $arg) {");
                for (int i = 0; i < n; ++i) {
                    object = (Name)funcBody.parlist.names.get(i);
                    String string = i > 0 ? "$arg.arg(" + (i + 1) + ")" : "$arg.arg1()";
                    this.singleLocalDeclareAssign((Name)object, string);
                }
                if (funcBody.parlist.isvararg) {
                    Variable variable = funcBody.scope.find("arg");
                    this.javascope.setJavaName(variable, "arg");
                    if (n > 0) {
                        this.outl("$arg = $arg.subargs(" + (n + 1) + ");");
                    }
                    object = this.javascope.usesvarargs ? "NIL" : "LuaValue.tableOf($arg,1)";
                    this.singleLocalDeclareAssign(variable, (String)object);
                }
            }
            this.writeBodyBlock(funcBody.block);
            this.oute("}");
            this.subindent();
            this.outi("}");
            this.javascope = this.javascope.popJavaScope();
        }

        private String declareArg(Name name) {
            String string = this.javascope.getJavaName(name.variable);
            return "LuaValue " + string + (name.variable.isupvalue ? "$0" : "");
        }

        private void assignArg(Name name) {
            if (name.variable.isupvalue) {
                String string = this.javascope.getJavaName(name.variable);
                this.singleLocalDeclareAssign(name, string + "$0");
            }
        }

        public void visit(Stat.FuncDef funcDef) {
            boolean bl;
            Writer writer = this.pushWriter();
            funcDef.body.accept(this);
            String string = this.popWriter(writer);
            int n = funcDef.name.dots != null ? funcDef.name.dots.size() : 0;
            boolean bl2 = bl = funcDef.name.method != null;
            if (n > 0 && !bl && funcDef.name.name.variable.isLocal()) {
                this.singleAssign(funcDef.name.name, string);
            } else if (n == 0 && !bl) {
                this.singleAssign(funcDef.name.name, string);
            } else {
                this.singleReference(funcDef.name.name);
                for (int i = 0; i < n - 1 || bl && i < n; ++i) {
                    this.out(".get(" + this.evalStringConstant((String)funcDef.name.dots.get(i)) + ")");
                }
                this.outr(".set(" + this.evalStringConstant(bl ? funcDef.name.method : (String)funcDef.name.dots.get(n)) + ", " + string + ");");
            }
        }

        public void visit(Stat.LocalFuncDef localFuncDef) {
            final Name name = localFuncDef.name;
            final boolean[] blArray = new boolean[]{false};
            localFuncDef.body.accept(new Visitor(){

                public void visit(Name name2) {
                    if (name2.variable == name.variable) {
                        blArray[0] = true;
                        name2.variable.hasassignments = true;
                    }
                }
            });
            Writer writer = this.pushWriter();
            super.visit(localFuncDef);
            String string = this.popWriter(writer);
            if (blArray[0]) {
                String string2 = this.javascope.getJavaName(name.variable);
                this.outl("final LuaValue[] " + string2 + " = new LuaValue[1];");
                this.outl(string2 + "[0] = " + string + ";");
            } else {
                this.singleLocalDeclareAssign(name, string);
            }
        }

        public void visit(Stat.NumericFor numericFor) {
            String string = this.javascope.getJavaName(numericFor.name.variable);
            String string2 = string + "$0";
            this.outi("for ( double " + string2 + "=" + this.evalLuaValue(numericFor.initial) + ".checkdouble(), " + string + "$limit=" + this.evalLuaValue(numericFor.limit) + ".checkdouble()");
            if (numericFor.step == null) {
                this.outr("; " + string2 + "<=" + string + "$limit; ++" + string2 + " ) {");
            } else {
                this.out(", " + string + "$step=" + this.evalLuaValue(numericFor.step) + ".checkdouble()");
                this.out("; " + string + "$step>0? (" + string2 + "<=" + string + "$limit): (" + string2 + ">=" + string + "$limit);");
                this.outr(" " + string2 + "+=" + string + "$step ) {");
            }
            this.addindent();
            this.singleLocalDeclareAssign(numericFor.name, "valueOf(" + string2 + ")");
            super.visit(numericFor.block);
            this.oute("}");
        }

        private Name tmpJavaVar(String string) {
            Name name = new Name(string);
            name.variable = this.javascope.define(string);
            return name;
        }

        public void visit(Stat.GenericFor genericFor) {
            Name name = this.tmpJavaVar("f");
            Name name2 = this.tmpJavaVar("s");
            Name name3 = this.tmpJavaVar("var");
            Name name4 = this.tmpJavaVar("v");
            String string = this.javascope.getJavaName(name.variable);
            String string2 = this.javascope.getJavaName(name2.variable);
            String string3 = this.javascope.getJavaName(name3.variable);
            String string4 = this.javascope.getJavaName(name4.variable);
            this.outl("LuaValue " + string + "," + string2 + "," + string3 + ";");
            this.outl("Varargs " + string4 + ";");
            ArrayList<Name> arrayList = new ArrayList<Name>();
            arrayList.add(name);
            arrayList.add(name2);
            arrayList.add(name3);
            this.multiAssign(arrayList, genericFor.exps);
            this.outb("while (true) {");
            this.outl(string4 + " = " + string + ".invoke(varargsOf(" + string2 + "," + string3 + "));");
            this.outl("if ((" + string3 + "=" + string4 + ".arg1()).isnil()) break;");
            this.singleLocalDeclareAssign((Name)genericFor.names.get(0), string3);
            int n = genericFor.names.size();
            for (int i = 1; i < n; ++i) {
                this.singleLocalDeclareAssign((Name)genericFor.names.get(i), string4 + ".arg(" + (i + 1) + ")");
            }
            super.visit(genericFor.block);
            this.oute("}");
        }

        public void visit(ParList parList) {
            super.visit(parList);
        }

        public void visit(Stat.IfThenElse ifThenElse) {
            this.outb("if ( " + this.evalBoolean(ifThenElse.ifexp) + " ) {");
            super.visit(ifThenElse.ifblock);
            if (ifThenElse.elseifblocks != null) {
                int n = ifThenElse.elseifblocks.size();
                for (int i = 0; i < n; ++i) {
                    this.subindent();
                    this.outl("} else if ( " + this.evalBoolean((Exp)ifThenElse.elseifexps.get(i)) + " ) {");
                    this.addindent();
                    super.visit((Block)ifThenElse.elseifblocks.get(i));
                }
            }
            if (ifThenElse.elseblock != null) {
                this.subindent();
                this.outl("} else {");
                this.addindent();
                super.visit(ifThenElse.elseblock);
            }
            this.oute("}");
        }

        public void visit(Stat.RepeatUntil repeatUntil) {
            this.outb("do {");
            super.visit(repeatUntil.block);
            this.oute("} while (!" + this.evalBoolean(repeatUntil.exp) + ");");
        }

        public void visit(TableConstructor tableConstructor) {
            int n;
            int n2;
            int n3 = tableConstructor.fields != null ? tableConstructor.fields.size() : 0;
            ArrayList<TableField> arrayList = new ArrayList<TableField>();
            ArrayList arrayList2 = new ArrayList();
            for (n2 = 0; n2 < n3; ++n2) {
                TableField tableField = (TableField)tableConstructor.fields.get(n2);
                (tableField.name != null || tableField.index != null ? arrayList : arrayList2).add(tableField);
            }
            n2 = arrayList.size();
            int n4 = arrayList2.size();
            this.out(n2 == 0 && n4 != 0 ? "LuaValue.listOf(" : "LuaValue.tableOf(");
            if (n2 != 0) {
                this.out("new LuaValue[]{");
                n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    TableField tableField = (TableField)arrayList.get(i);
                    if (tableField.name != null) {
                        this.out(this.evalStringConstant(tableField.name) + ",");
                    } else {
                        this.out(this.evalLuaValue(tableField.index) + ",");
                    }
                    this.out(this.evalLuaValue(tableField.rhs) + ",");
                }
                this.out("}");
            }
            if (n4 != 0) {
                int n5;
                this.out((n2 != 0 ? "," : "") + "new LuaValue[]{");
                Exp exp = ((TableField)arrayList2.get((int)(n4 - 1))).rhs;
                n = exp.isvarargexp() ? 1 : 0;
                int n6 = n5 = n != 0 ? n4 - 1 : n4;
                for (int i = 0; i < n5; ++i) {
                    this.out(this.evalLuaValue(((TableField)arrayList2.get((int)i)).rhs) + ",");
                }
                this.out(n != 0 ? "}, " + this.evalVarargs(exp) : "}");
            }
            this.out(")");
        }

        public void visit(Stat.WhileDo whileDo) {
            this.outb("while (" + this.evalBoolean(whileDo.exp) + ") {");
            super.visit(whileDo.block);
            this.oute("}");
        }

        public void visitExps(List list) {
            super.visitExps(list);
        }

        public void visitNames(List list) {
            super.visitNames(list);
        }

        public void visitVars(List list) {
            super.visitVars(list);
        }
    }
}

