/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.luajc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.LuaC;
import org.luaj.vm2.luajc.JavaGen;
import org.luaj.vm2.luajc.JavaLoader;

public class LuaJC
implements LoadState.LuaCompiler {
    private static final String NON_IDENTIFIER = "[^a-zA-Z0-9_$/.\\-]";
    private static LuaJC instance;

    public static LuaJC getInstance() {
        if (instance == null) {
            instance = new LuaJC();
        }
        return instance;
    }

    public static final void install() {
        LoadState.compiler = LuaJC.getInstance();
    }

    public Hashtable compileAll(InputStream inputStream, String string, String string2) throws IOException {
        String string3 = LuaJC.toStandardJavaClassName(string);
        String string4 = LuaJC.toStandardLuaFileName(string2);
        Hashtable hashtable = new Hashtable();
        Prototype prototype = LuaC.compile(inputStream, string3);
        JavaGen javaGen = new JavaGen(prototype, string3, string4);
        this.insert(hashtable, javaGen);
        return hashtable;
    }

    private void insert(Hashtable hashtable, JavaGen javaGen) {
        int n;
        hashtable.put(javaGen.classname, javaGen.bytecode);
        int n2 = n = javaGen.inners != null ? javaGen.inners.length : 0;
        for (int i = 0; i < n; ++i) {
            this.insert(hashtable, javaGen.inners[i]);
        }
    }

    public LuaFunction load(InputStream inputStream, String string, LuaValue luaValue) throws IOException {
        Prototype prototype = LuaC.compile(inputStream, string);
        String string2 = LuaJC.toStandardJavaClassName(string);
        String string3 = LuaJC.toStandardLuaFileName(string);
        JavaLoader javaLoader = new JavaLoader(luaValue);
        return javaLoader.load(prototype, string2, string3);
    }

    private static String toStandardJavaClassName(String string) {
        String string2 = LuaJC.toStub(string);
        String string3 = string2.replace('/', '.').replaceAll(NON_IDENTIFIER, "_");
        char c = string3.charAt(0);
        if (c != '_' && !Character.isJavaIdentifierStart((int)c)) {
            string3 = "_" + string3;
        }
        return string3;
    }

    private static String toStandardLuaFileName(String string) {
        String string2 = LuaJC.toStub(string);
        String string3 = string2.replace('.', '/') + ".lua";
        return string3;
    }

    private static String toStub(String string) {
        String string2 = string.endsWith(".lua") ? string.substring(0, string.length() - 4) : string;
        return string2;
    }
}

