/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.util.Palette;
import java.util.Arrays;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class FixedWidthFontRenderer {
    public static ResourceLocation font = new ResourceLocation("computercraft", "textures/gui/term_font.png");
    public static ResourceLocation background = new ResourceLocation("computercraft", "textures/gui/term_background.png");
    public static int FONT_HEIGHT = 9;
    public static int FONT_WIDTH = 6;
    private TextureManager m_textureManager;

    public FixedWidthFontRenderer(TextureManager textureManager) {
        this.m_textureManager = textureManager;
    }

    private static void greyscaleify(double[] rgb) {
        Arrays.fill(rgb, (rgb[0] + rgb[1] + rgb[2]) / 3.0);
    }

    private void drawChar(BufferBuilder renderer, double x, double y, int index, int color, Palette p, boolean greyscale) {
        int column = index % 16;
        int row = index / 16;
        double[] colour = p.getColour(15 - color);
        if (greyscale) {
            FixedWidthFontRenderer.greyscaleify(colour);
        }
        float r = (float)colour[0];
        float g = (float)colour[1];
        float b = (float)colour[2];
        renderer.func_181662_b(x, y, 0.0).func_187315_a((double)(column * FONT_WIDTH) / 256.0, (double)(row * FONT_HEIGHT) / 256.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x, y + (double)FONT_HEIGHT, 0.0).func_187315_a((double)(column * FONT_WIDTH) / 256.0, (double)((row + 1) * FONT_HEIGHT) / 256.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x + (double)FONT_WIDTH, y, 0.0).func_187315_a((double)((column + 1) * FONT_WIDTH) / 256.0, (double)(row * FONT_HEIGHT) / 256.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x + (double)FONT_WIDTH, y, 0.0).func_187315_a((double)((column + 1) * FONT_WIDTH) / 256.0, (double)(row * FONT_HEIGHT) / 256.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x, y + (double)FONT_HEIGHT, 0.0).func_187315_a((double)(column * FONT_WIDTH) / 256.0, (double)((row + 1) * FONT_HEIGHT) / 256.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x + (double)FONT_WIDTH, y + (double)FONT_HEIGHT, 0.0).func_187315_a((double)((column + 1) * FONT_WIDTH) / 256.0, (double)((row + 1) * FONT_HEIGHT) / 256.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
    }

    private void drawQuad(BufferBuilder renderer, double x, double y, int color, double width, Palette p, boolean greyscale) {
        double[] colour = p.getColour(15 - color);
        if (greyscale) {
            FixedWidthFontRenderer.greyscaleify(colour);
        }
        float r = (float)colour[0];
        float g = (float)colour[1];
        float b = (float)colour[2];
        renderer.func_181662_b(x, y, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x, y + (double)FONT_HEIGHT, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x + width, y, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x + width, y, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x, y + (double)FONT_HEIGHT, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
        renderer.func_181662_b(x + width, y + (double)FONT_HEIGHT, 0.0).func_181666_a(r, g, b, 1.0f).func_181675_d();
    }

    private boolean isGreyScale(int colour) {
        return colour == 0 || colour == 15 || colour == 7 || colour == 8;
    }

    public void drawStringBackgroundPart(int x, int y, TextBuffer backgroundColour, double leftMarginSize, double rightMarginSize, boolean greyScale, Palette p) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(4, DefaultVertexFormats.field_181706_f);
        if (leftMarginSize > 0.0) {
            int colour1 = "0123456789abcdef".indexOf(backgroundColour.charAt(0));
            if (colour1 < 0 || greyScale && !this.isGreyScale(colour1)) {
                colour1 = 15;
            }
            this.drawQuad(renderer, (double)x - leftMarginSize, y, colour1, leftMarginSize, p, greyScale);
        }
        if (rightMarginSize > 0.0) {
            int colour2 = "0123456789abcdef".indexOf(backgroundColour.charAt(backgroundColour.length() - 1));
            if (colour2 < 0 || greyScale && !this.isGreyScale(colour2)) {
                colour2 = 15;
            }
            this.drawQuad(renderer, x + backgroundColour.length() * FONT_WIDTH, y, colour2, rightMarginSize, p, greyScale);
        }
        for (int i = 0; i < backgroundColour.length(); ++i) {
            int colour = "0123456789abcdef".indexOf(backgroundColour.charAt(i));
            if (colour < 0 || greyScale && !this.isGreyScale(colour)) {
                colour = 15;
            }
            this.drawQuad(renderer, x + i * FONT_WIDTH, y, colour, FONT_WIDTH, p, greyScale);
        }
        GlStateManager.func_179090_x();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public void drawStringTextPart(int x, int y, TextBuffer s, TextBuffer textColour, boolean greyScale, Palette p) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder renderer = tessellator.func_178180_c();
        renderer.func_181668_a(4, DefaultVertexFormats.field_181709_i);
        for (int i = 0; i < s.length(); ++i) {
            int index;
            int colour = "0123456789abcdef".indexOf(textColour.charAt(i));
            if (colour < 0 || greyScale && !this.isGreyScale(colour)) {
                colour = 0;
            }
            if ((index = s.charAt(i)) < 0 || index > 255) {
                index = 63;
            }
            this.drawChar(renderer, x + i * FONT_WIDTH, y, index, colour, p, greyScale);
        }
        tessellator.func_78381_a();
    }

    public void drawString(TextBuffer s, int x, int y, TextBuffer textColour, TextBuffer backgroundColour, double leftMarginSize, double rightMarginSize, boolean greyScale, Palette p) {
        if (backgroundColour != null) {
            this.m_textureManager.func_110577_a(background);
            this.drawStringBackgroundPart(x, y, backgroundColour, leftMarginSize, rightMarginSize, greyScale, p);
        }
        if (s != null && textColour != null) {
            this.m_textureManager.func_110577_a(font);
            this.drawStringTextPart(x, y, s, textColour, greyScale, p);
        }
    }

    public int getStringWidth(String s) {
        if (s == null) {
            return 0;
        }
        return s.length() * FONT_WIDTH;
    }
}

