/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis;

import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.core.apis.IAPIEnvironment;
import dan200.computercraft.core.apis.ILuaAPI;
import dan200.computercraft.core.computer.Computer;
import dan200.computercraft.core.computer.ComputerThread;
import dan200.computercraft.core.computer.ITask;
import dan200.computercraft.core.filesystem.FileSystem;
import dan200.computercraft.core.filesystem.FileSystemException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class PeripheralAPI
implements ILuaAPI,
IAPIEnvironment.IPeripheralChangeListener {
    private final IAPIEnvironment m_environment;
    private FileSystem m_fileSystem;
    private final PeripheralWrapper[] m_peripherals;
    private boolean m_running;

    public PeripheralAPI(IAPIEnvironment _environment) {
        this.m_environment = _environment;
        this.m_environment.setPeripheralChangeListener(this);
        this.m_peripherals = new PeripheralWrapper[6];
        for (int i = 0; i < 6; ++i) {
            this.m_peripherals[i] = null;
        }
        this.m_running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPeripheralChanged(int side, IPeripheral newPeripheral) {
        PeripheralWrapper[] peripheralWrapperArray = this.m_peripherals;
        synchronized (this.m_peripherals) {
            PeripheralWrapper wrapper;
            if (this.m_peripherals[side] != null) {
                wrapper = this.m_peripherals[side];
                ComputerThread.queueTask(new ITask(){

                    @Override
                    public Computer getOwner() {
                        return PeripheralAPI.this.m_environment.getComputer();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute() {
                        PeripheralWrapper[] peripheralWrapperArray = PeripheralAPI.this.m_peripherals;
                        synchronized (peripheralWrapperArray) {
                            if (wrapper.isAttached()) {
                                wrapper.detach();
                            }
                        }
                    }
                }, null);
                this.m_environment.queueEvent("peripheral_detach", new Object[]{Computer.s_sideNames[side]});
            }
            this.m_peripherals[side] = newPeripheral != null ? new PeripheralWrapper(newPeripheral, Computer.s_sideNames[side]) : null;
            if (this.m_peripherals[side] != null) {
                wrapper = this.m_peripherals[side];
                ComputerThread.queueTask(new ITask(){

                    @Override
                    public Computer getOwner() {
                        return PeripheralAPI.this.m_environment.getComputer();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void execute() {
                        PeripheralWrapper[] peripheralWrapperArray = PeripheralAPI.this.m_peripherals;
                        synchronized (peripheralWrapperArray) {
                            if (PeripheralAPI.this.m_running && !wrapper.isAttached()) {
                                wrapper.attach();
                            }
                        }
                    }
                }, null);
                this.m_environment.queueEvent("peripheral", new Object[]{Computer.s_sideNames[side]});
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public String[] getNames() {
        return new String[]{"peripheral"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        PeripheralWrapper[] peripheralWrapperArray = this.m_peripherals;
        synchronized (this.m_peripherals) {
            this.m_fileSystem = this.m_environment.getFileSystem();
            this.m_running = true;
            for (int i = 0; i < 6; ++i) {
                PeripheralWrapper wrapper = this.m_peripherals[i];
                if (wrapper == null || wrapper.isAttached()) continue;
                wrapper.attach();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void advance(double _dt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        PeripheralWrapper[] peripheralWrapperArray = this.m_peripherals;
        synchronized (this.m_peripherals) {
            this.m_running = false;
            for (int i = 0; i < 6; ++i) {
                PeripheralWrapper wrapper = this.m_peripherals[i];
                if (wrapper == null || !wrapper.isAttached()) continue;
                wrapper.detach();
            }
            this.m_fileSystem = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"isPresent", "getType", "getMethods", "call"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                boolean present = false;
                int side = this.parseSide(args);
                if (side < 0) return new Object[]{present};
                PeripheralWrapper[] peripheralWrapperArray = this.m_peripherals;
                // MONITORENTER : this.m_peripherals
                PeripheralWrapper p = this.m_peripherals[side];
                if (p != null) {
                    present = true;
                }
                // MONITOREXIT : peripheralWrapperArray
                return new Object[]{present};
            }
            case 1: {
                String type = null;
                int side = this.parseSide(args);
                if (side < 0) return null;
                PeripheralWrapper[] peripheralWrapperArray = this.m_peripherals;
                // MONITORENTER : this.m_peripherals
                PeripheralWrapper p = this.m_peripherals[side];
                if (p != null) {
                    type = p.getType();
                }
                // MONITOREXIT : peripheralWrapperArray
                if (type == null) return null;
                return new Object[]{type};
            }
            case 2: {
                String[] methods = null;
                int side = this.parseSide(args);
                if (side >= 0) {
                    PeripheralWrapper[] peripheralWrapperArray = this.m_peripherals;
                    // MONITORENTER : this.m_peripherals
                    PeripheralWrapper p = this.m_peripherals[side];
                    if (p != null) {
                        methods = p.getMethods();
                    }
                    // MONITOREXIT : peripheralWrapperArray
                }
                if (methods == null) return null;
                HashMap<Integer, String> table = new HashMap<Integer, String>();
                int i = 0;
                while (true) {
                    if (i >= methods.length) {
                        return new Object[]{table};
                    }
                    table.put(i + 1, methods[i]);
                    ++i;
                }
            }
            case 3: {
                int side = this.parseSide(args);
                String methodName = ArgumentHelper.getString(args, 1);
                Object[] methodArgs = this.trimArray(args, 2);
                if (side < 0) throw new LuaException("No peripheral attached");
                PeripheralWrapper[] peripheralWrapperArray = this.m_peripherals;
                // MONITORENTER : this.m_peripherals
                PeripheralWrapper p = this.m_peripherals[side];
                // MONITOREXIT : peripheralWrapperArray
                if (p == null) throw new LuaException("No peripheral attached");
                return p.call(context, methodName, methodArgs);
            }
        }
        return null;
    }

    private Object[] trimArray(Object[] array, int skip) {
        return Arrays.copyOfRange(array, skip, array.length);
    }

    private int parseSide(Object[] args) throws LuaException {
        String side = ArgumentHelper.getString(args, 0);
        for (int n = 0; n < Computer.s_sideNames.length; ++n) {
            if (!side.equals(Computer.s_sideNames[n])) continue;
            return n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findFreeLocation(String desiredLoc) {
        try {
            FileSystem fileSystem = this.m_fileSystem;
            synchronized (fileSystem) {
                if (!this.m_fileSystem.exists(desiredLoc)) {
                    return desiredLoc;
                }
                return null;
            }
        }
        catch (FileSystemException e) {
            return null;
        }
    }

    private class PeripheralWrapper
    implements IComputerAccess {
        private final String m_side;
        private final IPeripheral m_peripheral;
        private String m_type;
        private String[] m_methods;
        private Map<String, Integer> m_methodMap;
        private boolean m_attached;
        private Set<String> m_mounts;

        public PeripheralWrapper(IPeripheral peripheral, String side) {
            this.m_side = side;
            this.m_peripheral = peripheral;
            this.m_attached = false;
            this.m_type = peripheral.getType();
            this.m_methods = peripheral.getMethodNames();
            assert (this.m_type != null);
            assert (this.m_methods != null);
            this.m_methodMap = new HashMap<String, Integer>();
            for (int i = 0; i < this.m_methods.length; ++i) {
                if (this.m_methods[i] == null) continue;
                this.m_methodMap.put(this.m_methods[i], i);
            }
            this.m_mounts = new HashSet<String>();
        }

        public IPeripheral getPeripheral() {
            return this.m_peripheral;
        }

        public String getType() {
            return this.m_type;
        }

        public String[] getMethods() {
            return this.m_methods;
        }

        public synchronized boolean isAttached() {
            return this.m_attached;
        }

        public synchronized void attach() {
            this.m_attached = true;
            this.m_peripheral.attach(this);
        }

        public synchronized void detach() {
            this.m_peripheral.detach(this);
            this.m_attached = false;
            for (String m_mount : this.m_mounts) {
                PeripheralAPI.this.m_fileSystem.unmount(m_mount);
            }
            this.m_mounts.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] call(ILuaContext context, String methodName, Object[] arguments) throws LuaException, InterruptedException {
            int method = -1;
            PeripheralWrapper peripheralWrapper = this;
            synchronized (peripheralWrapper) {
                if (this.m_methodMap.containsKey(methodName)) {
                    method = this.m_methodMap.get(methodName);
                }
            }
            if (method >= 0) {
                return this.m_peripheral.callMethod(this, context, method, arguments);
            }
            throw new LuaException("No such method " + methodName);
        }

        @Override
        public String mount(@Nonnull String desiredLoc, @Nonnull IMount mount) {
            return this.mount(desiredLoc, mount, this.m_side);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized String mount(@Nonnull String desiredLoc, @Nonnull IMount mount, @Nonnull String driveName) {
            String location;
            if (!this.m_attached) {
                throw new RuntimeException("You are not attached to this Computer");
            }
            FileSystem fileSystem = PeripheralAPI.this.m_fileSystem;
            synchronized (fileSystem) {
                location = PeripheralAPI.this.findFreeLocation(desiredLoc);
                if (location != null) {
                    try {
                        PeripheralAPI.this.m_fileSystem.mount(driveName, location, mount);
                    }
                    catch (FileSystemException fileSystemException) {
                        // empty catch block
                    }
                }
            }
            if (location != null) {
                this.m_mounts.add(location);
            }
            return location;
        }

        @Override
        public String mountWritable(@Nonnull String desiredLoc, @Nonnull IWritableMount mount) {
            return this.mountWritable(desiredLoc, mount, this.m_side);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized String mountWritable(@Nonnull String desiredLoc, @Nonnull IWritableMount mount, @Nonnull String driveName) {
            String location;
            if (!this.m_attached) {
                throw new RuntimeException("You are not attached to this Computer");
            }
            FileSystem fileSystem = PeripheralAPI.this.m_fileSystem;
            synchronized (fileSystem) {
                location = PeripheralAPI.this.findFreeLocation(desiredLoc);
                if (location != null) {
                    try {
                        PeripheralAPI.this.m_fileSystem.mountWritable(driveName, location, mount);
                    }
                    catch (FileSystemException fileSystemException) {
                        // empty catch block
                    }
                }
            }
            if (location != null) {
                this.m_mounts.add(location);
            }
            return location;
        }

        @Override
        public synchronized void unmount(String location) {
            if (!this.m_attached) {
                throw new RuntimeException("You are not attached to this Computer");
            }
            if (location != null) {
                if (!this.m_mounts.contains(location)) {
                    throw new RuntimeException("You didn't mount this location");
                }
                PeripheralAPI.this.m_fileSystem.unmount(location);
                this.m_mounts.remove(location);
            }
        }

        @Override
        public synchronized int getID() {
            if (!this.m_attached) {
                throw new RuntimeException("You are not attached to this Computer");
            }
            return PeripheralAPI.this.m_environment.getComputerID();
        }

        @Override
        public synchronized void queueEvent(@Nonnull String event, Object[] arguments) {
            if (!this.m_attached) {
                throw new RuntimeException("You are not attached to this Computer");
            }
            PeripheralAPI.this.m_environment.queueEvent(event, arguments);
        }

        @Override
        @Nonnull
        public synchronized String getAttachmentName() {
            if (!this.m_attached) {
                throw new RuntimeException("You are not attached to this Computer");
            }
            return this.m_side;
        }
    }
}

