/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.handles;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.core.apis.handles.HandleGeneric;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;

public class EncodedInputHandle
extends HandleGeneric {
    private final BufferedReader m_reader;

    public EncodedInputHandle(BufferedReader reader) {
        super(reader);
        this.m_reader = reader;
    }

    public EncodedInputHandle(InputStream stream) {
        this(stream, "UTF-8");
    }

    public EncodedInputHandle(InputStream stream, String encoding) {
        this(EncodedInputHandle.makeReader(stream, encoding));
    }

    private static BufferedReader makeReader(InputStream stream, String encoding) {
        InputStreamReader streamReader;
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            streamReader = new InputStreamReader(stream, encoding);
        }
        catch (UnsupportedEncodingException e) {
            streamReader = new InputStreamReader(stream);
        }
        return new BufferedReader(streamReader);
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"readLine", "readAll", "close"};
    }

    @Override
    public Object[] callMethod(@Nonnull ILuaContext context, int method, @Nonnull Object[] args) throws LuaException {
        switch (method) {
            case 0: {
                this.checkOpen();
                try {
                    String line = this.m_reader.readLine();
                    if (line != null) {
                        return new Object[]{line};
                    }
                    return null;
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 1: {
                this.checkOpen();
                try {
                    StringBuilder result = new StringBuilder("");
                    String line = this.m_reader.readLine();
                    while (line != null) {
                        result.append(line);
                        line = this.m_reader.readLine();
                        if (line == null) continue;
                        result.append("\n");
                    }
                    return new Object[]{result.toString()};
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 2: {
                this.close();
                return null;
            }
        }
        return null;
    }
}

