/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.apis.http;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import dan200.computercraft.core.apis.IAPIEnvironment;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HTTPTask {
    private static final ExecutorService httpThreads = new ThreadPoolExecutor(4, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setPriority(3).setNameFormat("ComputerCraft-HTTP-%d").build());
    private final Future<?> future;
    private final IHTTPTask task;

    private HTTPTask(Future<?> future, IHTTPTask task) {
        this.future = future;
        this.task = task;
    }

    public static HTTPTask submit(IHTTPTask task) {
        Future<?> future = httpThreads.submit(task);
        return new HTTPTask(future, task);
    }

    public void cancel() {
        this.future.cancel(false);
    }

    public boolean isFinished() {
        return this.future.isDone();
    }

    public void whenFinished(IAPIEnvironment environment) {
        this.task.whenFinished(environment);
    }

    public static interface IHTTPTask
    extends Runnable {
        public void whenFinished(IAPIEnvironment var1);
    }
}

