/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.filesystem;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.core.filesystem.FileSystemException;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.regex.Pattern;

public class FileSystem {
    private final Map<String, MountWrapper> m_mounts = new HashMap<String, MountWrapper>();
    private final Set<Closeable> m_openFiles = Collections.newSetFromMap(new WeakHashMap());

    public FileSystem(String rootLabel, IMount rootMount) throws FileSystemException {
        this.mount(rootLabel, "", rootMount);
    }

    public FileSystem(String rootLabel, IWritableMount rootMount) throws FileSystemException {
        this.mountWritable(rootLabel, "", rootMount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unload() {
        Set<Closeable> set = this.m_openFiles;
        synchronized (set) {
            for (Closeable file : this.m_openFiles) {
                try {
                    file.close();
                }
                catch (IOException iOException) {}
            }
            this.m_openFiles.clear();
        }
    }

    public synchronized void mount(String label, String location, IMount mount) throws FileSystemException {
        if (mount == null) {
            throw new NullPointerException();
        }
        if ((location = FileSystem.sanitizePath(location)).contains("..")) {
            throw new FileSystemException("Cannot mount below the root");
        }
        this.mount(new MountWrapper(label, location, mount));
    }

    public synchronized void mountWritable(String label, String location, IWritableMount mount) throws FileSystemException {
        if (mount == null) {
            throw new NullPointerException();
        }
        if ((location = FileSystem.sanitizePath(location)).contains("..")) {
            throw new FileSystemException("Cannot mount below the root");
        }
        this.mount(new MountWrapper(label, location, mount));
    }

    private synchronized void mount(MountWrapper wrapper) throws FileSystemException {
        String location = wrapper.getLocation();
        if (this.m_mounts.containsKey(location)) {
            this.m_mounts.remove(location);
        }
        this.m_mounts.put(location, wrapper);
    }

    public synchronized void unmount(String path) {
        if (this.m_mounts.containsKey(path = FileSystem.sanitizePath(path))) {
            this.m_mounts.remove(path);
        }
    }

    public synchronized String combine(String path, String childPath) {
        path = FileSystem.sanitizePath(path, true);
        childPath = FileSystem.sanitizePath(childPath, true);
        if (path.isEmpty()) {
            return childPath;
        }
        if (childPath.isEmpty()) {
            return path;
        }
        return FileSystem.sanitizePath(path + '/' + childPath, true);
    }

    public static String getDirectory(String path) {
        if ((path = FileSystem.sanitizePath(path, true)).isEmpty()) {
            return "..";
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0) {
            return path.substring(0, lastSlash);
        }
        return "";
    }

    public static String getName(String path) {
        if ((path = FileSystem.sanitizePath(path, true)).isEmpty()) {
            return "root";
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash >= 0) {
            return path.substring(lastSlash + 1);
        }
        return path;
    }

    public synchronized long getSize(String path) throws FileSystemException {
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        return mount.getSize(path);
    }

    public synchronized String[] list(String path) throws FileSystemException {
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        ArrayList<String> list = new ArrayList<String>();
        mount.list(path, list);
        for (MountWrapper otherMount : this.m_mounts.values()) {
            if (!FileSystem.getDirectory(otherMount.getLocation()).equals(path)) continue;
            list.add(FileSystem.getName(otherMount.getLocation()));
        }
        Object[] array = new String[list.size()];
        list.toArray(array);
        Arrays.sort(array);
        return array;
    }

    private void findIn(String dir, List<String> matches, Pattern wildPattern) throws FileSystemException {
        String[] list;
        for (String entry : list = this.list(dir)) {
            String entryPath;
            String string = entryPath = dir.isEmpty() ? entry : dir + "/" + entry;
            if (wildPattern.matcher(entryPath).matches()) {
                matches.add(entryPath);
            }
            if (!this.isDir(entryPath)) continue;
            this.findIn(entryPath, matches, wildPattern);
        }
    }

    public synchronized String[] find(String wildPath) throws FileSystemException {
        String startDir;
        int starIndex = (wildPath = FileSystem.sanitizePath(wildPath, true)).indexOf(42);
        if (starIndex == -1) {
            String[] stringArray;
            if (this.exists(wildPath)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = wildPath;
            } else {
                stringArray = new String[]{};
            }
            return stringArray;
        }
        int prevDir = wildPath.substring(0, starIndex).lastIndexOf(47);
        String string = startDir = prevDir == -1 ? "" : wildPath.substring(0, prevDir);
        if (!this.isDir(startDir)) {
            return new String[0];
        }
        Pattern wildPattern = Pattern.compile("^\\Q" + wildPath.replaceAll("\\*", "\\\\E[^\\\\/]*\\\\Q") + "\\E$");
        ArrayList<String> matches = new ArrayList<String>();
        this.findIn(startDir, matches, wildPattern);
        String[] array = new String[matches.size()];
        matches.toArray(array);
        return array;
    }

    public synchronized boolean exists(String path) throws FileSystemException {
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        return mount.exists(path);
    }

    public synchronized boolean isDir(String path) throws FileSystemException {
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        return mount.isDirectory(path);
    }

    public synchronized boolean isReadOnly(String path) throws FileSystemException {
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        return mount.isReadOnly(path);
    }

    public synchronized String getMountLabel(String path) throws FileSystemException {
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        return mount.getLabel();
    }

    public synchronized void makeDir(String path) throws FileSystemException {
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        mount.makeDirectory(path);
    }

    public synchronized void delete(String path) throws FileSystemException {
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        mount.delete(path);
    }

    public synchronized void move(String sourcePath, String destPath) throws FileSystemException {
        sourcePath = FileSystem.sanitizePath(sourcePath);
        destPath = FileSystem.sanitizePath(destPath);
        if (this.isReadOnly(sourcePath) || this.isReadOnly(destPath)) {
            throw new FileSystemException("Access denied");
        }
        if (!this.exists(sourcePath)) {
            throw new FileSystemException("No such file");
        }
        if (this.exists(destPath)) {
            throw new FileSystemException("File exists");
        }
        if (FileSystem.contains(sourcePath, destPath)) {
            throw new FileSystemException("Can't move a directory inside itself");
        }
        this.copy(sourcePath, destPath);
        this.delete(sourcePath);
    }

    public synchronized void copy(String sourcePath, String destPath) throws FileSystemException {
        sourcePath = FileSystem.sanitizePath(sourcePath);
        if (this.isReadOnly(destPath = FileSystem.sanitizePath(destPath))) {
            throw new FileSystemException("Access denied");
        }
        if (!this.exists(sourcePath)) {
            throw new FileSystemException("No such file");
        }
        if (this.exists(destPath)) {
            throw new FileSystemException("File exists");
        }
        if (FileSystem.contains(sourcePath, destPath)) {
            throw new FileSystemException("Can't copy a directory inside itself");
        }
        this.copyRecursive(sourcePath, this.getMount(sourcePath), destPath, this.getMount(destPath));
    }

    private synchronized void copyRecursive(String sourcePath, MountWrapper sourceMount, String destinationPath, MountWrapper destinationMount) throws FileSystemException {
        if (!sourceMount.exists(sourcePath)) {
            return;
        }
        if (sourceMount.isDirectory(sourcePath)) {
            destinationMount.makeDirectory(destinationPath);
            ArrayList<String> sourceChildren = new ArrayList<String>();
            sourceMount.list(sourcePath, sourceChildren);
            for (String child : sourceChildren) {
                this.copyRecursive(this.combine(sourcePath, child), sourceMount, this.combine(destinationPath, child), destinationMount);
            }
        } else {
            InputStream source = null;
            OutputStream destination = null;
            try {
                int bytesRead;
                source = sourceMount.openForRead(sourcePath);
                destination = destinationMount.openForWrite(destinationPath);
                byte[] buffer = new byte[1024];
                while ((bytesRead = source.read(buffer)) >= 0) {
                    destination.write(buffer, 0, bytesRead);
                }
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
            finally {
                if (source != null) {
                    try {
                        source.close();
                    }
                    catch (IOException iOException) {}
                }
                if (destination != null) {
                    try {
                        destination.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized <T> T openFile(T file, Closeable handle) throws FileSystemException {
        Set<Closeable> set = this.m_openFiles;
        synchronized (set) {
            if (ComputerCraft.maximumFilesOpen > 0 && this.m_openFiles.size() >= ComputerCraft.maximumFilesOpen) {
                if (handle != null) {
                    try {
                        handle.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new FileSystemException("Too many files already open");
            }
            this.m_openFiles.add(handle);
            return file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeFile(Closeable handle) throws IOException {
        Set<Closeable> set = this.m_openFiles;
        synchronized (set) {
            this.m_openFiles.remove(handle);
            handle.close();
        }
    }

    public synchronized InputStream openForRead(String path) throws FileSystemException {
        MountWrapper mount = this.getMount(path = FileSystem.sanitizePath(path));
        InputStream stream = mount.openForRead(path);
        if (stream != null) {
            return this.openFile(new ClosingInputStream(stream), stream);
        }
        return null;
    }

    public synchronized OutputStream openForWrite(String path, boolean append) throws FileSystemException {
        OutputStream stream;
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        OutputStream outputStream = stream = append ? mount.openForAppend(path) : mount.openForWrite(path);
        if (stream != null) {
            return this.openFile(new ClosingOutputStream(stream), stream);
        }
        return null;
    }

    public long getFreeSpace(String path) throws FileSystemException {
        path = FileSystem.sanitizePath(path);
        MountWrapper mount = this.getMount(path);
        return mount.getFreeSpace();
    }

    private MountWrapper getMount(String path) throws FileSystemException {
        Iterator<MountWrapper> it = this.m_mounts.values().iterator();
        MountWrapper match = null;
        int matchLength = 999;
        while (it.hasNext()) {
            MountWrapper mount = it.next();
            if (!FileSystem.contains(mount.getLocation(), path)) continue;
            int len = FileSystem.toLocal(path, mount.getLocation()).length();
            if (match != null && len >= matchLength) continue;
            match = mount;
            matchLength = len;
        }
        if (match == null) {
            throw new FileSystemException("Invalid Path");
        }
        return match;
    }

    private static String sanitizePath(String path) {
        return FileSystem.sanitizePath(path, false);
    }

    private static String sanitizePath(String path, boolean allowWildcards) {
        path = path.replace('\\', '/');
        char[] specialChars = new char[]{'\"', ':', '<', '>', '?', '|'};
        StringBuilder cleanName = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c < ' ' || Arrays.binarySearch(specialChars, c) >= 0 || !allowWildcards && c == '*') continue;
            cleanName.append(c);
        }
        path = cleanName.toString();
        String[] parts = path.split("/");
        Stack<String> outputParts = new Stack<String>();
        for (String part : parts) {
            if (part.length() == 0 || part.equals(".")) continue;
            if (part.equals("..") || part.equals("...")) {
                if (!outputParts.empty()) {
                    String top = (String)outputParts.peek();
                    if (!top.equals("..")) {
                        outputParts.pop();
                        continue;
                    }
                    outputParts.push("..");
                    continue;
                }
                outputParts.push("..");
                continue;
            }
            if (part.length() >= 255) {
                outputParts.push(part.substring(0, 255));
                continue;
            }
            outputParts.push(part);
        }
        StringBuilder result = new StringBuilder("");
        Iterator it = outputParts.iterator();
        while (it.hasNext()) {
            String part = (String)it.next();
            result.append(part);
            if (!it.hasNext()) continue;
            result.append('/');
        }
        return result.toString();
    }

    public static boolean contains(String pathA, String pathB) {
        pathA = FileSystem.sanitizePath(pathA);
        if ((pathB = FileSystem.sanitizePath(pathB)).equals("..")) {
            return false;
        }
        if (pathB.startsWith("../")) {
            return false;
        }
        if (pathB.equals(pathA)) {
            return true;
        }
        if (pathA.isEmpty()) {
            return true;
        }
        return pathB.startsWith(pathA + "/");
    }

    public static String toLocal(String path, String location) {
        path = FileSystem.sanitizePath(path);
        location = FileSystem.sanitizePath(location);
        assert (FileSystem.contains(location, path));
        String local = path.substring(location.length());
        if (local.startsWith("/")) {
            return local.substring(1);
        }
        return local;
    }

    private class ClosingOutputStream
    extends FilterOutputStream {
        protected ClosingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FileSystem.this.closeFile(this.out);
        }
    }

    private class ClosingInputStream
    extends FilterInputStream {
        protected ClosingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FileSystem.this.closeFile(this.in);
        }
    }

    private class MountWrapper {
        private String m_label;
        private String m_location;
        private IMount m_mount;
        private IWritableMount m_writableMount;

        public MountWrapper(String label, String location, IMount mount) {
            this.m_label = label;
            this.m_location = location;
            this.m_mount = mount;
            this.m_writableMount = null;
        }

        public MountWrapper(String label, String location, IWritableMount mount) {
            this(label, location, (IMount)mount);
            this.m_writableMount = mount;
        }

        public String getLabel() {
            return this.m_label;
        }

        public String getLocation() {
            return this.m_location;
        }

        public long getFreeSpace() {
            if (this.m_writableMount == null) {
                return 0L;
            }
            try {
                return this.m_writableMount.getRemainingSpace();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        public boolean isReadOnly(String path) throws FileSystemException {
            return this.m_writableMount == null;
        }

        public boolean exists(String path) throws FileSystemException {
            path = this.toLocal(path);
            try {
                return this.m_mount.exists(path);
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
        }

        public boolean isDirectory(String path) throws FileSystemException {
            path = this.toLocal(path);
            try {
                return this.m_mount.exists(path) && this.m_mount.isDirectory(path);
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
        }

        public void list(String path, List<String> contents) throws FileSystemException {
            path = this.toLocal(path);
            try {
                if (!this.m_mount.exists(path) || !this.m_mount.isDirectory(path)) {
                    throw new FileSystemException("Not a directory");
                }
                this.m_mount.list(path, contents);
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
        }

        public long getSize(String path) throws FileSystemException {
            path = this.toLocal(path);
            try {
                if (this.m_mount.exists(path)) {
                    if (this.m_mount.isDirectory(path)) {
                        return 0L;
                    }
                    return this.m_mount.getSize(path);
                }
                throw new FileSystemException("No such file");
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
        }

        public InputStream openForRead(String path) throws FileSystemException {
            path = this.toLocal(path);
            try {
                if (this.m_mount.exists(path) && !this.m_mount.isDirectory(path)) {
                    return this.m_mount.openForRead(path);
                }
                throw new FileSystemException("No such file");
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
        }

        public void makeDirectory(String path) throws FileSystemException {
            if (this.m_writableMount == null) {
                throw new FileSystemException("Access denied");
            }
            try {
                path = this.toLocal(path);
                if (this.m_mount.exists(path)) {
                    if (!this.m_mount.isDirectory(path)) {
                        throw new FileSystemException("File exists");
                    }
                } else {
                    this.m_writableMount.makeDirectory(path);
                }
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
        }

        public void delete(String path) throws FileSystemException {
            if (this.m_writableMount == null) {
                throw new FileSystemException("Access denied");
            }
            try {
                path = this.toLocal(path);
                if (this.m_mount.exists(path)) {
                    this.m_writableMount.delete(path);
                }
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
        }

        public OutputStream openForWrite(String path) throws FileSystemException {
            if (this.m_writableMount == null) {
                throw new FileSystemException("Access denied");
            }
            try {
                String dir;
                path = this.toLocal(path);
                if (this.m_mount.exists(path) && this.m_mount.isDirectory(path)) {
                    throw new FileSystemException("Cannot write to directory");
                }
                if (!(path.isEmpty() || (dir = FileSystem.getDirectory(path)).isEmpty() || this.m_mount.exists(path))) {
                    this.m_writableMount.makeDirectory(dir);
                }
                return this.m_writableMount.openForWrite(path);
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
        }

        public OutputStream openForAppend(String path) throws FileSystemException {
            if (this.m_writableMount == null) {
                throw new FileSystemException("Access denied");
            }
            try {
                path = this.toLocal(path);
                if (!this.m_mount.exists(path)) {
                    String dir;
                    if (!(path.isEmpty() || (dir = FileSystem.getDirectory(path)).isEmpty() || this.m_mount.exists(path))) {
                        this.m_writableMount.makeDirectory(dir);
                    }
                    return this.m_writableMount.openForWrite(path);
                }
                if (this.m_mount.isDirectory(path)) {
                    throw new FileSystemException("Cannot write to directory");
                }
                return this.m_writableMount.openForAppend(path);
            }
            catch (IOException e) {
                throw new FileSystemException(e.getMessage());
            }
        }

        private String toLocal(String path) {
            return FileSystem.toLocal(path, this.m_location);
        }
    }
}

