/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.blocks.IComputerTile;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.items.ItemCommandComputer;
import dan200.computercraft.shared.computer.items.ItemComputer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ComputerItemFactory {
    @Nonnull
    public static ItemStack create(IComputerTile computerTile) {
        IComputer computer = computerTile.getComputer();
        if (computer != null) {
            String label = computer.getLabel();
            int id = label != null ? computer.getID() : -1;
            return ComputerItemFactory.create(id, label, computerTile.getFamily());
        }
        return ComputerItemFactory.create(-1, null, computerTile.getFamily());
    }

    @Nonnull
    public static ItemStack create(int id, String label, ComputerFamily family) {
        ItemComputer computer = (ItemComputer)Item.func_150898_a((Block)ComputerCraft.Blocks.computer);
        ItemCommandComputer commandComputer = (ItemCommandComputer)Item.func_150898_a((Block)ComputerCraft.Blocks.commandComputer);
        switch (family) {
            case Normal: 
            case Advanced: {
                return computer.create(id, label, family);
            }
            case Command: {
                return commandComputer.create(id, label, family);
            }
        }
        return ItemStack.field_190927_a;
    }
}

