/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.IPacketReceiver;
import dan200.computercraft.api.network.IPacketSender;
import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.ArgumentHelper;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import javax.annotation.Nonnull;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public abstract class ModemPeripheral
implements IPeripheral,
IPacketSender,
IPacketReceiver {
    private IPacketNetwork m_network = null;
    private IComputerAccess m_computer = null;
    private final TIntSet m_channels = new TIntHashSet();
    private boolean m_open = false;
    private boolean m_changed = true;

    private synchronized void setNetwork(IPacketNetwork network) {
        if (this.m_network != network) {
            if (this.m_network != null) {
                this.m_network.removeReceiver(this);
            }
            this.m_network = network;
            if (this.m_network != null) {
                this.m_network.addReceiver(this);
            }
        }
    }

    protected void switchNetwork() {
        this.setNetwork(this.getNetwork());
    }

    public synchronized void destroy() {
        this.setNetwork(null);
        this.m_channels.clear();
        this.m_open = false;
    }

    public synchronized boolean pollChanged() {
        if (this.m_changed) {
            this.m_changed = false;
            return true;
        }
        return false;
    }

    public synchronized boolean isActive() {
        return this.m_computer != null && this.m_open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveSameDimension(@Nonnull Packet packet, double distance) {
        if (packet.getSender() == this) {
            return;
        }
        TIntSet tIntSet = this.m_channels;
        synchronized (tIntSet) {
            if (this.m_computer != null && this.m_channels.contains(packet.getChannel())) {
                this.m_computer.queueEvent("modem_message", new Object[]{this.m_computer.getAttachmentName(), packet.getChannel(), packet.getReplyChannel(), packet.getPayload(), distance});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveDifferentDimension(@Nonnull Packet packet) {
        if (packet.getSender() == this) {
            return;
        }
        TIntSet tIntSet = this.m_channels;
        synchronized (tIntSet) {
            if (this.m_computer != null && this.m_channels.contains(packet.getChannel())) {
                this.m_computer.queueEvent("modem_message", new Object[]{this.m_computer.getAttachmentName(), packet.getChannel(), packet.getReplyChannel(), packet.getPayload()});
            }
        }
    }

    protected abstract IPacketNetwork getNetwork();

    @Override
    @Nonnull
    public String getType() {
        return "modem";
    }

    @Override
    @Nonnull
    public String[] getMethodNames() {
        return new String[]{"open", "isOpen", "close", "closeAll", "transmit", "isWireless"};
    }

    private static int parseChannel(Object[] arguments, int index) throws LuaException {
        int channel = ArgumentHelper.getInt(arguments, index);
        if (channel < 0 || channel > 65535) {
            throw new LuaException("Expected number in range 0-65535");
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                int channel = ModemPeripheral.parseChannel(arguments, 0);
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    if (!this.m_channels.contains(channel)) {
                        if (this.m_channels.size() >= 128) {
                            throw new LuaException("Too many open channels");
                        }
                        this.m_channels.add(channel);
                        if (!this.m_open) {
                            this.m_open = true;
                            this.m_changed = true;
                        }
                    }
                }
                return null;
            }
            case 1: {
                int channel = ModemPeripheral.parseChannel(arguments, 0);
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    boolean open = this.m_channels.contains(channel);
                    return new Object[]{open};
                }
            }
            case 2: {
                int channel = ModemPeripheral.parseChannel(arguments, 0);
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    if (this.m_channels.remove(channel) && this.m_channels.size() == 0) {
                        this.m_open = false;
                        this.m_changed = true;
                    }
                }
                return null;
            }
            case 3: {
                ModemPeripheral channel = this;
                synchronized (channel) {
                    if (this.m_channels.size() > 0) {
                        this.m_channels.clear();
                        if (this.m_open) {
                            this.m_open = false;
                            this.m_changed = true;
                        }
                    }
                }
                return null;
            }
            case 4: {
                int channel = ModemPeripheral.parseChannel(arguments, 0);
                int replyChannel = ModemPeripheral.parseChannel(arguments, 1);
                Object payload = arguments.length >= 3 ? arguments[2] : null;
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    World world = this.getWorld();
                    Vec3d position = this.getPosition();
                    if (world != null && position != null && this.m_network != null) {
                        Packet packet = new Packet(channel, replyChannel, payload, this);
                        if (this.isInterdimensional()) {
                            this.m_network.transmitInterdimensional(packet);
                        } else {
                            this.m_network.transmitSameDimension(packet, this.getRange());
                        }
                    }
                }
                return null;
            }
            case 5: {
                ModemPeripheral modemPeripheral = this;
                synchronized (modemPeripheral) {
                    if (this.m_network != null) {
                        return new Object[]{this.m_network.isWireless()};
                    }
                }
                return new Object[]{false};
            }
        }
        return null;
    }

    @Override
    public synchronized void attach(@Nonnull IComputerAccess computer) {
        this.m_computer = computer;
        this.setNetwork(this.getNetwork());
        this.m_open = !this.m_channels.isEmpty();
    }

    @Override
    public synchronized void detach(@Nonnull IComputerAccess computer) {
        if (this.m_network != null) {
            this.m_network.removeReceiver(this);
            this.m_channels.clear();
            this.m_network = null;
        }
        this.m_computer = null;
        if (this.m_open) {
            this.m_open = false;
            this.m_changed = true;
        }
    }

    public IComputerAccess getComputer() {
        return this.m_computer;
    }

    @Override
    @Nonnull
    public String getSenderID() {
        if (this.m_computer == null) {
            return "unknown";
        }
        return this.m_computer.getID() + "_" + this.m_computer.getAttachmentName();
    }
}

