/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem;

import com.google.common.base.Objects;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.filesystem.IWritableMount;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.network.IPacketNetwork;
import dan200.computercraft.api.network.IPacketReceiver;
import dan200.computercraft.api.network.Packet;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.apis.ArgumentHelper;
import dan200.computercraft.shared.common.BlockGeneric;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.BlockCable;
import dan200.computercraft.shared.peripheral.common.BlockCableModemVariant;
import dan200.computercraft.shared.peripheral.common.PeripheralItemFactory;
import dan200.computercraft.shared.peripheral.modem.ModemPeripheral;
import dan200.computercraft.shared.peripheral.modem.TileModemBase;
import dan200.computercraft.shared.util.IDAssigner;
import dan200.computercraft.shared.util.PeripheralUtil;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileCable
extends TileModemBase
implements IPacketNetwork {
    private static final double MIN = 0.375;
    private static final double MAX = 0.625;
    private static final AxisAlignedBB BOX_CENTRE = new AxisAlignedBB(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new AxisAlignedBB(0.375, 0.625, 0.375, 0.625, 1.0, 0.625), new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.375), new AxisAlignedBB(0.375, 0.375, 0.625, 0.625, 0.625, 1.0), new AxisAlignedBB(0.0, 0.375, 0.375, 0.375, 0.625, 0.625), new AxisAlignedBB(0.625, 0.375, 0.375, 1.0, 0.625, 0.625)};
    private static int s_nextUniqueSearchID = 1;
    private final Set<IPacketReceiver> m_receivers = new HashSet<IPacketReceiver>();
    private final Queue<PacketWrapper> m_transmitQueue = new LinkedList<PacketWrapper>();
    private boolean m_peripheralAccessAllowed = false;
    private int m_attachedPeripheralID = -1;
    private final Map<String, IPeripheral> m_peripheralsByName = new HashMap<String, IPeripheral>();
    private Map<String, RemotePeripheralWrapper> m_peripheralWrappersByName = new HashMap<String, RemotePeripheralWrapper>();
    private boolean m_peripheralsKnown = false;
    private boolean m_destroyed = false;
    private int m_lastSearchID = 0;

    @Override
    public void destroy() {
        if (!this.m_destroyed) {
            this.m_destroyed = true;
            this.networkChanged();
        }
        super.destroy();
    }

    @Override
    public EnumFacing getDirection() {
        IBlockState state = this.getBlockState();
        BlockCableModemVariant modem = (BlockCableModemVariant)((Object)state.func_177229_b(BlockCable.Properties.MODEM));
        if (modem != BlockCableModemVariant.None) {
            return modem.getFacing();
        }
        return EnumFacing.NORTH;
    }

    @Override
    public void setDirection(EnumFacing dir) {
        IBlockState state = this.getBlockState();
        BlockCableModemVariant modem = (BlockCableModemVariant)((Object)state.func_177229_b(BlockCable.Properties.MODEM));
        if (modem != BlockCableModemVariant.None) {
            this.setBlockState(state.func_177226_a(BlockCable.Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.fromFacing(dir))));
        }
    }

    @Override
    public void getDroppedItems(@Nonnull NonNullList<ItemStack> drops, boolean creative) {
        if (!creative) {
            PeripheralType type = this.getPeripheralType();
            switch (type) {
                case Cable: 
                case WiredModem: {
                    drops.add((Object)PeripheralItemFactory.create(type, this.getLabel(), 1));
                    break;
                }
                case WiredModemWithCable: {
                    drops.add((Object)PeripheralItemFactory.create(PeripheralType.WiredModem, this.getLabel(), 1));
                    drops.add((Object)PeripheralItemFactory.create(PeripheralType.Cable, null, 1));
                }
            }
        }
    }

    @Override
    public ItemStack getPickedItem() {
        if (this.getPeripheralType() == PeripheralType.WiredModemWithCable) {
            return PeripheralItemFactory.create(PeripheralType.WiredModem, this.getLabel(), 1);
        }
        return super.getPickedItem();
    }

    @Override
    public void onNeighbourChange() {
        EnumFacing dir = this.getDirection();
        if (!this.func_145831_w().isSideSolid(this.func_174877_v().func_177972_a(dir), dir.func_176734_d())) {
            switch (this.getPeripheralType()) {
                case WiredModem: {
                    ((BlockGeneric)this.func_145838_q()).dropAllItems(this.func_145831_w(), this.func_174877_v(), false);
                    this.func_145831_w().func_175698_g(this.func_174877_v());
                    break;
                }
                case WiredModemWithCable: {
                    ((BlockGeneric)this.func_145838_q()).dropItem(this.func_145831_w(), this.func_174877_v(), PeripheralItemFactory.create(PeripheralType.WiredModem, this.getLabel(), 1));
                    this.setLabel(null);
                    this.setBlockState(this.getBlockState().func_177226_a(BlockCable.Properties.MODEM, (Comparable)((Object)BlockCableModemVariant.None)));
                }
            }
        }
    }

    public AxisAlignedBB getModemBounds() {
        return super.getBounds();
    }

    public AxisAlignedBB getCableBounds() {
        double xMin = 0.375;
        double yMin = 0.375;
        double zMin = 0.375;
        double xMax = 0.625;
        double yMax = 0.625;
        double zMax = 0.625;
        BlockPos pos = this.func_174877_v();
        World world = this.func_145831_w();
        if (BlockCable.isCable((IBlockAccess)world, pos.func_177976_e())) {
            xMin = 0.0;
        }
        if (BlockCable.isCable((IBlockAccess)world, pos.func_177974_f())) {
            xMax = 1.0;
        }
        if (BlockCable.isCable((IBlockAccess)world, pos.func_177977_b())) {
            yMin = 0.0;
        }
        if (BlockCable.isCable((IBlockAccess)world, pos.func_177984_a())) {
            yMax = 1.0;
        }
        if (BlockCable.isCable((IBlockAccess)world, pos.func_177978_c())) {
            zMin = 0.0;
        }
        if (BlockCable.isCable((IBlockAccess)world, pos.func_177968_d())) {
            zMax = 1.0;
        }
        return new AxisAlignedBB(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBounds() {
        PeripheralType type = this.getPeripheralType();
        switch (type) {
            default: {
                return this.getModemBounds();
            }
            case Cable: {
                return this.getCableBounds();
            }
            case WiredModemWithCable: 
        }
        AxisAlignedBB modem = this.getModemBounds();
        AxisAlignedBB cable = this.getCableBounds();
        return modem.func_111270_a(cable);
    }

    @Override
    public void getCollisionBounds(@Nonnull List<AxisAlignedBB> bounds) {
        PeripheralType type = this.getPeripheralType();
        if (type == PeripheralType.WiredModem || type == PeripheralType.WiredModemWithCable) {
            bounds.add(this.getModemBounds());
        }
        if (type == PeripheralType.Cable || type == PeripheralType.WiredModemWithCable) {
            bounds.add(BOX_CENTRE);
            BlockPos pos = this.func_174877_v();
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                if (!BlockCable.isCable((IBlockAccess)this.func_145831_w(), pos.func_177972_a(facing))) continue;
                bounds.add(BOXES[facing.ordinal()]);
            }
        }
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.getPeripheralType() == PeripheralType.WiredModemWithCable && !player.func_70093_af()) {
            if (!this.func_145831_w().field_72995_K) {
                String oldPeriphName = this.getConnectedPeripheralName();
                this.togglePeripheralAccess();
                String periphName = this.getConnectedPeripheralName();
                if (!Objects.equal((Object)periphName, (Object)oldPeriphName)) {
                    if (oldPeriphName != null) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.computercraft:wired_modem.peripheral_disconnected", new Object[]{oldPeriphName}));
                    }
                    if (periphName != null) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("gui.computercraft:wired_modem.peripheral_connected", new Object[]{periphName}));
                    }
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.m_peripheralAccessAllowed = nbttagcompound.func_74767_n("peripheralAccess");
        this.m_attachedPeripheralID = nbttagcompound.func_74762_e("peripheralID");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74757_a("peripheralAccess", this.m_peripheralAccessAllowed);
        nbttagcompound.func_74768_a("peripheralID", this.m_attachedPeripheralID);
        return nbttagcompound;
    }

    @Override
    protected ModemPeripheral createPeripheral() {
        return new Peripheral(this);
    }

    @Override
    protected void updateAnim() {
        int anim = 0;
        if (this.m_modem.isActive()) {
            ++anim;
        }
        if (this.m_peripheralAccessAllowed) {
            anim += 2;
        }
        this.setAnim(anim);
    }

    @Override
    public IPeripheral getPeripheral(EnumFacing side) {
        if (this.getPeripheralType() != PeripheralType.Cable) {
            return super.getPeripheral(side);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K) {
            Object object = this.m_peripheralsByName;
            synchronized (object) {
                if (!this.m_peripheralsKnown) {
                    this.findPeripherals();
                    this.m_peripheralsKnown = true;
                }
            }
            object = this.m_transmitQueue;
            synchronized (object) {
                while (this.m_transmitQueue.peek() != null) {
                    PacketWrapper p = this.m_transmitQueue.remove();
                    if (p == null) continue;
                    this.dispatchPacket(p);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReceiver(@Nonnull IPacketReceiver receiver) {
        Set<IPacketReceiver> set = this.m_receivers;
        synchronized (set) {
            this.m_receivers.add(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReceiver(@Nonnull IPacketReceiver receiver) {
        Set<IPacketReceiver> set = this.m_receivers;
        synchronized (set) {
            this.m_receivers.remove(receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmitSameDimension(@Nonnull Packet packet, double range) {
        Queue<PacketWrapper> queue = this.m_transmitQueue;
        synchronized (queue) {
            this.m_transmitQueue.offer(new PacketWrapper(packet, range));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transmitInterdimensional(@Nonnull Packet packet) {
        Queue<PacketWrapper> queue = this.m_transmitQueue;
        synchronized (queue) {
            this.m_transmitQueue.offer(new PacketWrapper(packet, Double.MAX_VALUE));
        }
    }

    @Override
    public boolean isWireless() {
        return false;
    }

    private void attachPeripheral(String periphName, IPeripheral peripheral) {
        if (!this.m_peripheralWrappersByName.containsKey(periphName)) {
            RemotePeripheralWrapper wrapper = new RemotePeripheralWrapper(peripheral, this.m_modem.getComputer(), periphName);
            this.m_peripheralWrappersByName.put(periphName, wrapper);
            wrapper.attach();
        }
    }

    private void detachPeripheral(String periphName) {
        if (this.m_peripheralWrappersByName.containsKey(periphName)) {
            RemotePeripheralWrapper wrapper = this.m_peripheralWrappersByName.get(periphName);
            this.m_peripheralWrappersByName.remove(periphName);
            wrapper.detach();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTypeRemote(String remoteName) {
        Map<String, IPeripheral> map = this.m_peripheralsByName;
        synchronized (map) {
            RemotePeripheralWrapper wrapper = this.m_peripheralWrappersByName.get(remoteName);
            if (wrapper != null) {
                return wrapper.getType();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getMethodNamesRemote(String remoteName) {
        Map<String, IPeripheral> map = this.m_peripheralsByName;
        synchronized (map) {
            RemotePeripheralWrapper wrapper = this.m_peripheralWrappersByName.get(remoteName);
            if (wrapper != null) {
                return wrapper.getMethodNames();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] callMethodRemote(String remoteName, ILuaContext context, String method, Object[] arguments) throws LuaException, InterruptedException {
        RemotePeripheralWrapper wrapper;
        Map<String, IPeripheral> map = this.m_peripheralsByName;
        synchronized (map) {
            wrapper = this.m_peripheralWrappersByName.get(remoteName);
        }
        if (wrapper != null) {
            return wrapper.callMethod(context, method, arguments);
        }
        throw new LuaException("No peripheral: " + remoteName);
    }

    public void networkChanged() {
        if (!this.func_145831_w().field_72995_K) {
            if (!this.m_destroyed) {
                this.searchNetwork((modem, distance) -> {
                    Map<String, IPeripheral> map = modem.m_peripheralsByName;
                    synchronized (map) {
                        modem.m_peripheralsKnown = false;
                    }
                });
            } else {
                for (EnumFacing dir : EnumFacing.values()) {
                    TileEntity tile;
                    BlockPos offset = this.func_174877_v().func_177972_a(dir);
                    if (offset.func_177956_o() < 0 || offset.func_177956_o() >= this.func_145831_w().func_72800_K() || !BlockCable.isCable((IBlockAccess)this.func_145831_w(), offset) || (tile = this.func_145831_w().func_175625_s(offset)) == null || !(tile instanceof TileCable)) continue;
                    TileCable modem2 = (TileCable)tile;
                    modem2.networkChanged();
                }
            }
        }
    }

    private void dispatchPacket(PacketWrapper packet) {
        this.searchNetwork((modem, distance) -> {
            if ((double)distance <= packet.m_range) {
                modem.receivePacket(packet.m_packet, distance);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivePacket(Packet packet, int distanceTravelled) {
        Set<IPacketReceiver> set = this.m_receivers;
        synchronized (set) {
            for (IPacketReceiver device : this.m_receivers) {
                device.receiveSameDimension(packet, distanceTravelled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findPeripherals() {
        TileCable origin = this;
        Map<String, IPeripheral> map = this.m_peripheralsByName;
        synchronized (map) {
            HashMap newPeripheralsByName = new HashMap();
            if (this.getPeripheralType() == PeripheralType.WiredModemWithCable) {
                this.searchNetwork((modem, distance) -> {
                    if (modem != origin) {
                        IPeripheral peripheral = modem.getConnectedPeripheral();
                        String periphName = modem.getConnectedPeripheralName();
                        if (peripheral != null && periphName != null) {
                            newPeripheralsByName.put(periphName, peripheral);
                        }
                    }
                });
            }
            Iterator<String> it = this.m_peripheralsByName.keySet().iterator();
            while (it.hasNext()) {
                String periphName = it.next();
                if (newPeripheralsByName.containsKey(periphName)) continue;
                this.detachPeripheral(periphName);
                it.remove();
            }
            for (String periphName : newPeripheralsByName.keySet()) {
                IPeripheral peripheral;
                if (this.m_peripheralsByName.containsKey(periphName) || (peripheral = (IPeripheral)newPeripheralsByName.get(periphName)) == null) continue;
                this.m_peripheralsByName.put(periphName, peripheral);
                if (!this.isAttached()) continue;
                this.attachPeripheral(periphName, peripheral);
            }
        }
    }

    public void togglePeripheralAccess() {
        if (!this.m_peripheralAccessAllowed) {
            this.m_peripheralAccessAllowed = true;
            if (this.getConnectedPeripheral() == null) {
                this.m_peripheralAccessAllowed = false;
                return;
            }
        } else {
            this.m_peripheralAccessAllowed = false;
        }
        this.updateAnim();
        this.networkChanged();
    }

    public String getConnectedPeripheralName() {
        IPeripheral periph = this.getConnectedPeripheral();
        if (periph != null) {
            String type = periph.getType();
            if (this.m_attachedPeripheralID < 0) {
                this.m_attachedPeripheralID = IDAssigner.getNextIDFromFile(new File(ComputerCraft.getWorldDir(this.func_145831_w()), "computer/lastid_" + type + ".txt"));
            }
            return type + "_" + this.m_attachedPeripheralID;
        }
        return null;
    }

    private IPeripheral getConnectedPeripheral() {
        if (this.m_peripheralAccessAllowed && this.getPeripheralType() == PeripheralType.WiredModemWithCable) {
            EnumFacing facing = this.getDirection();
            BlockPos neighbour = this.func_174877_v().func_177972_a(facing);
            return PeripheralUtil.getPeripheral(this.func_145831_w(), neighbour, facing.func_176734_d());
        }
        return null;
    }

    private static void enqueue(Queue<SearchLoc> queue, World world, BlockPos pos, int distanceTravelled) {
        int y = pos.func_177956_o();
        if (y >= 0 && y < world.func_72800_K() && BlockCable.isCable((IBlockAccess)world, pos)) {
            SearchLoc loc = new SearchLoc();
            loc.world = world;
            loc.pos = pos;
            loc.distanceTravelled = distanceTravelled;
            queue.offer(loc);
        }
    }

    private static void visitBlock(Queue<SearchLoc> queue, SearchLoc location, int searchID, ICableVisitor visitor) {
        if (location.distanceTravelled >= 256) {
            return;
        }
        TileEntity tile = location.world.func_175625_s(location.pos);
        if (tile != null && tile instanceof TileCable) {
            TileCable modem = (TileCable)tile;
            if (!modem.m_destroyed && modem.m_lastSearchID != searchID) {
                modem.m_lastSearchID = searchID;
                visitor.visit(modem, location.distanceTravelled + 1);
                TileCable.enqueue(queue, location.world, location.pos.func_177984_a(), location.distanceTravelled + 1);
                TileCable.enqueue(queue, location.world, location.pos.func_177977_b(), location.distanceTravelled + 1);
                TileCable.enqueue(queue, location.world, location.pos.func_177968_d(), location.distanceTravelled + 1);
                TileCable.enqueue(queue, location.world, location.pos.func_177978_c(), location.distanceTravelled + 1);
                TileCable.enqueue(queue, location.world, location.pos.func_177974_f(), location.distanceTravelled + 1);
                TileCable.enqueue(queue, location.world, location.pos.func_177976_e(), location.distanceTravelled + 1);
            }
        }
    }

    private void searchNetwork(ICableVisitor visitor) {
        int searchID = ++s_nextUniqueSearchID;
        LinkedList<SearchLoc> queue = new LinkedList<SearchLoc>();
        TileCable.enqueue(queue, this.func_145831_w(), this.func_174877_v(), 1);
        int visited = 0;
        while (queue.peek() != null) {
            SearchLoc loc = (SearchLoc)queue.remove();
            TileCable.visitBlock(queue, loc, searchID, visitor);
            ++visited;
        }
    }

    private static class SearchLoc {
        public World world;
        public BlockPos pos;
        public int distanceTravelled;

        private SearchLoc() {
        }
    }

    private static interface ICableVisitor {
        public void visit(TileCable var1, int var2);
    }

    private static class RemotePeripheralWrapper
    implements IComputerAccess {
        private IPeripheral m_peripheral;
        private IComputerAccess m_computer;
        private String m_name;
        private String m_type;
        private String[] m_methods;
        private Map<String, Integer> m_methodMap;

        public RemotePeripheralWrapper(IPeripheral peripheral, IComputerAccess computer, String name) {
            this.m_peripheral = peripheral;
            this.m_computer = computer;
            this.m_name = name;
            this.m_type = peripheral.getType();
            this.m_methods = peripheral.getMethodNames();
            assert (this.m_type != null);
            assert (this.m_methods != null);
            this.m_methodMap = new HashMap<String, Integer>();
            for (int i = 0; i < this.m_methods.length; ++i) {
                if (this.m_methods[i] == null) continue;
                this.m_methodMap.put(this.m_methods[i], i);
            }
        }

        public void attach() {
            this.m_peripheral.attach(this);
            this.m_computer.queueEvent("peripheral", new Object[]{this.getAttachmentName()});
        }

        public void detach() {
            this.m_peripheral.detach(this);
            this.m_computer.queueEvent("peripheral_detach", new Object[]{this.getAttachmentName()});
        }

        public String getType() {
            return this.m_type;
        }

        public String[] getMethodNames() {
            return this.m_methods;
        }

        public Object[] callMethod(ILuaContext context, String methodName, Object[] arguments) throws LuaException, InterruptedException {
            if (this.m_methodMap.containsKey(methodName)) {
                int method = this.m_methodMap.get(methodName);
                return this.m_peripheral.callMethod(this, context, method, arguments);
            }
            throw new LuaException("No such method " + methodName);
        }

        @Override
        public String mount(@Nonnull String desiredLocation, @Nonnull IMount mount) {
            return this.m_computer.mount(desiredLocation, mount, this.m_name);
        }

        @Override
        public String mount(@Nonnull String desiredLocation, @Nonnull IMount mount, @Nonnull String driveName) {
            return this.m_computer.mount(desiredLocation, mount, driveName);
        }

        @Override
        public String mountWritable(@Nonnull String desiredLocation, @Nonnull IWritableMount mount) {
            return this.m_computer.mountWritable(desiredLocation, mount, this.m_name);
        }

        @Override
        public String mountWritable(@Nonnull String desiredLocation, @Nonnull IWritableMount mount, @Nonnull String driveName) {
            return this.m_computer.mountWritable(desiredLocation, mount, driveName);
        }

        @Override
        public void unmount(String location) {
            this.m_computer.unmount(location);
        }

        @Override
        public int getID() {
            return this.m_computer.getID();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object[] arguments) {
            this.m_computer.queueEvent(event, arguments);
        }

        @Override
        @Nonnull
        public String getAttachmentName() {
            return this.m_name;
        }
    }

    private static class PacketWrapper {
        final Packet m_packet;
        final double m_range;

        private PacketWrapper(Packet m_packet, double m_range) {
            this.m_packet = m_packet;
            this.m_range = m_range;
        }
    }

    private static class Peripheral
    extends ModemPeripheral {
        private TileCable m_entity;

        public Peripheral(TileCable entity) {
            this.m_entity = entity;
        }

        @Override
        public boolean isInterdimensional() {
            return false;
        }

        @Override
        public double getRange() {
            return 256.0;
        }

        @Override
        protected IPacketNetwork getNetwork() {
            return this.m_entity;
        }

        @Override
        @Nonnull
        public World getWorld() {
            return this.m_entity.func_145831_w();
        }

        @Override
        @Nonnull
        public Vec3d getPosition() {
            EnumFacing direction = this.m_entity.getDirection();
            BlockPos pos = this.m_entity.func_174877_v().func_177972_a(direction);
            return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        }

        @Override
        @Nonnull
        public String[] getMethodNames() {
            String[] methods = super.getMethodNames();
            String[] newMethods = new String[methods.length + 5];
            System.arraycopy(methods, 0, newMethods, 0, methods.length);
            newMethods[methods.length] = "getNamesRemote";
            newMethods[methods.length + 1] = "isPresentRemote";
            newMethods[methods.length + 2] = "getTypeRemote";
            newMethods[methods.length + 3] = "getMethodsRemote";
            newMethods[methods.length + 4] = "callRemote";
            return newMethods;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] callMethod(@Nonnull IComputerAccess computer, @Nonnull ILuaContext context, int method, @Nonnull Object[] arguments) throws LuaException, InterruptedException {
            String[] methods = super.getMethodNames();
            switch (method - methods.length) {
                case 0: {
                    Map map = this.m_entity.m_peripheralsByName;
                    synchronized (map) {
                        int idx = 1;
                        HashMap<Integer, String> table = new HashMap<Integer, String>();
                        for (String name : this.m_entity.m_peripheralWrappersByName.keySet()) {
                            table.put(idx++, name);
                        }
                        return new Object[]{table};
                    }
                }
                case 1: {
                    String type = this.m_entity.getTypeRemote(ArgumentHelper.getString(arguments, 0));
                    return new Object[]{type != null};
                }
                case 2: {
                    String type = this.m_entity.getTypeRemote(ArgumentHelper.getString(arguments, 0));
                    if (type != null) {
                        return new Object[]{type};
                    }
                    return null;
                }
                case 3: {
                    String[] methodNames = this.m_entity.getMethodNamesRemote(ArgumentHelper.getString(arguments, 0));
                    if (methodNames != null) {
                        HashMap<Integer, String> table = new HashMap<Integer, String>();
                        for (int i = 0; i < methodNames.length; ++i) {
                            table.put(i + 1, methodNames[i]);
                        }
                        return new Object[]{table};
                    }
                    return null;
                }
                case 4: {
                    String remoteName = ArgumentHelper.getString(arguments, 0);
                    String methodName = ArgumentHelper.getString(arguments, 1);
                    Object[] methodArgs = new Object[arguments.length - 2];
                    System.arraycopy(arguments, 2, methodArgs, 0, arguments.length - 2);
                    return this.m_entity.callMethodRemote(remoteName, context, methodName, methodArgs);
                }
            }
            return super.callMethod(computer, context, method, arguments);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attach(@Nonnull IComputerAccess computer) {
            super.attach(computer);
            Map map = this.m_entity.m_peripheralsByName;
            synchronized (map) {
                for (String periphName : this.m_entity.m_peripheralsByName.keySet()) {
                    IPeripheral peripheral = (IPeripheral)this.m_entity.m_peripheralsByName.get(periphName);
                    if (peripheral == null) continue;
                    this.m_entity.attachPeripheral(periphName, peripheral);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void detach(@Nonnull IComputerAccess computer) {
            Map map = this.m_entity.m_peripheralsByName;
            synchronized (map) {
                for (String periphName : this.m_entity.m_peripheralsByName.keySet()) {
                    this.m_entity.detachPeripheral(periphName);
                }
            }
            super.detach(computer);
        }

        @Override
        public boolean equals(IPeripheral other) {
            if (other instanceof Peripheral) {
                Peripheral otherModem = (Peripheral)other;
                return otherModem.m_entity == this.m_entity;
            }
            return false;
        }
    }
}

