/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ServerComputer;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class PocketServerComputer
extends ServerComputer
implements IPocketAccess {
    private IPocketUpgrade m_upgrade;
    private Entity m_entity;
    private ItemStack m_stack;

    public PocketServerComputer(World world, int computerID, String label, int instanceID, ComputerFamily family) {
        super(world, computerID, label, instanceID, family, 26, 20);
    }

    @Override
    @Nullable
    public Entity getEntity() {
        return this.m_entity;
    }

    @Override
    public int getColour() {
        return ComputerCraft.Items.pocketComputer.getColour(this.m_stack);
    }

    @Override
    public void setColour(int colour) {
        ComputerCraft.Items.pocketComputer.setColourDirect(this.m_stack, colour);
        this.updateUpgradeNBTData();
    }

    @Override
    public int getLight() {
        NBTTagCompound tag = this.getUserData();
        if (tag.func_150297_b("modemLight", 99)) {
            return tag.func_74762_e("modemLight");
        }
        return -1;
    }

    @Override
    public void setLight(int colour) {
        NBTTagCompound tag = this.getUserData();
        if (colour >= 0 && colour <= 0xFFFFFF) {
            if (!tag.func_150297_b("modemLight", 99) || tag.func_74762_e("modemLight") != colour) {
                tag.func_74768_a("modemLight", colour);
                this.updateUserData();
            }
        } else if (tag.func_150297_b("modemLight", 99)) {
            tag.func_82580_o("modemLight");
            this.updateUserData();
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound getUpgradeNBTData() {
        return ComputerCraft.Items.pocketComputer.getUpgradeInfo(this.m_stack);
    }

    @Override
    public void updateUpgradeNBTData() {
        InventoryPlayer inventory;
        InventoryPlayer inventoryPlayer = inventory = this.m_entity instanceof EntityPlayer ? ((EntityPlayer)this.m_entity).field_71071_by : null;
        if (inventory != null) {
            inventory.func_70296_d();
        }
    }

    @Override
    public void invalidatePeripheral() {
        IPeripheral peripheral = this.m_upgrade == null ? null : this.m_upgrade.createPeripheral(this);
        this.setPeripheral(2, peripheral);
    }

    @Override
    @Nonnull
    public Map<ResourceLocation, IPeripheral> getUpgrades() {
        if (this.m_upgrade == null) {
            return Collections.emptyMap();
        }
        return Collections.singletonMap(this.m_upgrade.getUpgradeID(), this.getPeripheral(2));
    }

    public IPocketUpgrade getUpgrade() {
        return this.m_upgrade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpgrade(IPocketUpgrade upgrade) {
        if (this.m_upgrade == upgrade) {
            return;
        }
        PocketServerComputer pocketServerComputer = this;
        synchronized (pocketServerComputer) {
            ComputerCraft.Items.pocketComputer.setUpgrade(this.m_stack, upgrade);
            if (this.m_entity instanceof EntityPlayer) {
                ((EntityPlayer)this.m_entity).field_71071_by.func_70296_d();
            }
            this.m_upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }

    public synchronized void updateValues(Entity entity, @Nonnull ItemStack stack, IPocketUpgrade upgrade) {
        if (entity != null) {
            this.setWorld(entity.func_130014_f_());
            this.setPosition(entity.func_180425_c());
        }
        this.m_entity = entity;
        this.m_stack = stack;
        if (this.m_upgrade != upgrade) {
            this.m_upgrade = upgrade;
            this.invalidatePeripheral();
        }
    }
}

