/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.common.IColouredItem;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.items.ItemTurtleBase;
import dan200.computercraft.shared.util.ColourUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class ItemTurtleNormal
extends ItemTurtleBase
implements IColouredItem {
    public ItemTurtleNormal(Block block) {
        super(block);
        this.func_77655_b("computercraft:turtle");
        this.func_77637_a(ComputerCraft.mainCreativeTab);
    }

    @Override
    public ItemStack create(int id, String label, int colour, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, int fuelLevel, ResourceLocation overlay) {
        ItemStack stack = new ItemStack((Item)this, 1, 0);
        NBTTagCompound nbt = new NBTTagCompound();
        if (leftUpgrade != null) {
            int leftUpgradeLegacyID = leftUpgrade.getLegacyUpgradeID();
            if (leftUpgradeLegacyID >= 0) {
                nbt.func_74777_a("leftUpgrade", (short)leftUpgradeLegacyID);
            } else {
                nbt.func_74778_a("leftUpgrade", leftUpgrade.getUpgradeID().toString());
            }
        }
        if (rightUpgrade != null) {
            int rightUpgradeLegacyID = rightUpgrade.getLegacyUpgradeID();
            if (rightUpgradeLegacyID >= 0) {
                nbt.func_74777_a("rightUpgrade", (short)rightUpgradeLegacyID);
            } else {
                nbt.func_74778_a("rightUpgrade", rightUpgrade.getUpgradeID().toString());
            }
        }
        if (id >= 0) {
            nbt.func_74768_a("computerID", id);
        }
        if (fuelLevel > 0) {
            nbt.func_74768_a("fuelLevel", fuelLevel);
        }
        if (colour != -1) {
            nbt.func_74768_a("colour", colour);
        }
        if (overlay != null) {
            nbt.func_74778_a("overlay_mod", overlay.func_110624_b());
            nbt.func_74778_a("overlay_path", overlay.func_110623_a());
        }
        stack.func_77982_d(nbt);
        if (label != null) {
            stack.func_151001_c(label);
        }
        return stack;
    }

    @Override
    public int getComputerID(@Nonnull ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("computerID")) {
            return nbt.func_74762_e("computerID");
        }
        return -1;
    }

    @Override
    public ComputerFamily getFamily(int damage) {
        return ComputerFamily.Normal;
    }

    @Override
    public ITurtleUpgrade getUpgrade(@Nonnull ItemStack stack, TurtleSide side) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            switch (side) {
                case Left: {
                    if (!nbt.func_74764_b("leftUpgrade")) break;
                    if (nbt.func_150299_b("leftUpgrade") == 8) {
                        return ComputerCraft.getTurtleUpgrade(nbt.func_74779_i("leftUpgrade"));
                    }
                    return ComputerCraft.getTurtleUpgrade(nbt.func_74765_d("leftUpgrade"));
                }
                case Right: {
                    if (!nbt.func_74764_b("rightUpgrade")) break;
                    if (nbt.func_150299_b("rightUpgrade") == 8) {
                        return ComputerCraft.getTurtleUpgrade(nbt.func_74779_i("rightUpgrade"));
                    }
                    return ComputerCraft.getTurtleUpgrade(nbt.func_74765_d("rightUpgrade"));
                }
            }
        }
        return null;
    }

    @Override
    public int getColour(@Nonnull ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag == null ? -1 : ColourUtils.getHexColour(tag);
    }

    @Override
    public ResourceLocation getOverlay(@Nonnull ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("overlay_mod") && nbt.func_74764_b("overlay_path")) {
            String overlay_mod = nbt.func_74779_i("overlay_mod");
            String overlay_path = nbt.func_74779_i("overlay_path");
            return new ResourceLocation(overlay_mod, overlay_path);
        }
        return null;
    }

    @Override
    public int getFuelLevel(@Nonnull ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("fuelLevel")) {
            return nbt.func_74762_e("fuelLevel");
        }
        return 0;
    }
}

