/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

public enum Colour {
    Black(0x111111),
    Red(0xCC4C4C),
    Green(5744206),
    Brown(8349260),
    Blue(0x3366CC),
    Purple(11691749),
    Cyan(5020082),
    LightGrey(0x999999),
    Grey(0x4C4C4C),
    Pink(15905484),
    Lime(8375321),
    Yellow(14605932),
    LightBlue(10072818),
    Magenta(15040472),
    Orange(15905331),
    White(0xF0F0F0);

    public static final Colour[] VALUES;
    private int m_hex;
    private float[] m_rgb;

    public static Colour fromInt(int colour) {
        if (colour >= 0 && colour < 16) {
            return VALUES[colour];
        }
        return null;
    }

    public static Colour fromHex(int colour) {
        for (Colour entry : VALUES) {
            if (entry.getHex() != colour) continue;
            return entry;
        }
        return null;
    }

    private Colour(int hex) {
        this.m_hex = hex;
        this.m_rgb = new float[]{(float)(hex >> 16 & 0xFF) / 255.0f, (float)(hex >> 8 & 0xFF) / 255.0f, (float)(hex & 0xFF) / 255.0f};
    }

    public Colour getNext() {
        return VALUES[(this.ordinal() + 1) % 16];
    }

    public Colour getPrevious() {
        return VALUES[(this.ordinal() + 15) % 16];
    }

    public int getHex() {
        return this.m_hex;
    }

    public float[] getRGB() {
        return this.m_rgb;
    }

    public float getR() {
        return this.m_rgb[0];
    }

    public float getG() {
        return this.m_rgb[1];
    }

    public float getB() {
        return this.m_rgb[2];
    }

    static {
        VALUES = Colour.values();
    }
}

