/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.Colour;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public final class ColourUtils {
    private static final String[] DYES = new String[]{"dyeBlack", "dyeRed", "dyeGreen", "dyeBrown", "dyeBlue", "dyePurple", "dyeCyan", "dyeLightGray", "dyeGray", "dyePink", "dyeLime", "dyeYellow", "dyeLightBlue", "dyeMagenta", "dyeOrange", "dyeWhite"};
    private static int[] ids;

    public static int getStackColour(ItemStack stack) {
        if (ids == null) {
            ids = new int[DYES.length];
            int[] ids = ColourUtils.ids;
            for (int i = 0; i < DYES.length; ++i) {
                ids[i] = OreDictionary.getOreID((String)DYES[i]);
            }
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            int index = ArrayUtils.indexOf((int[])ids, (int)id);
            if (index < 0) continue;
            return index;
        }
        return -1;
    }

    public static int getHexColour(@Nonnull NBTTagCompound tag) {
        if (tag.func_150297_b("colourIndex", 99)) {
            return Colour.VALUES[tag.func_74762_e("colourIndex") & 0xF].getHex();
        }
        if (tag.func_150297_b("colour", 99)) {
            return tag.func_74762_e("colour");
        }
        if (tag.func_150297_b("color", 99)) {
            return tag.func_74762_e("color");
        }
        return -1;
    }

    public static Colour getColour(@Nonnull NBTTagCompound tag) {
        if (tag.func_150297_b("colourIndex", 99)) {
            return Colour.fromInt(tag.func_74762_e("colourIndex") & 0xF);
        }
        return null;
    }
}

