/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2;

import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.lib.MathLib;

public class LuaDouble
extends LuaNumber {
    public static final LuaDouble NAN = new LuaDouble(Double.NaN);
    public static final LuaDouble POSINF = new LuaDouble(Double.POSITIVE_INFINITY);
    public static final LuaDouble NEGINF = new LuaDouble(Double.NEGATIVE_INFINITY);
    public static final String JSTR_NAN = "nan";
    public static final String JSTR_POSINF = "inf";
    public static final String JSTR_NEGINF = "-inf";
    final double v;

    public static LuaNumber valueOf(double d) {
        int n = (int)d;
        return d == (double)n ? LuaInteger.valueOf(n) : new LuaDouble(d);
    }

    private LuaDouble(double d) {
        this.v = d;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.v);
        return (int)(l >> 32) | (int)l;
    }

    public boolean islong() {
        return this.v == (double)((long)this.v);
    }

    public byte tobyte() {
        return (byte)this.v;
    }

    public char tochar() {
        return (char)this.v;
    }

    public double todouble() {
        return this.v;
    }

    public float tofloat() {
        return (float)this.v;
    }

    public int toint() {
        return (int)this.v;
    }

    public long tolong() {
        return (long)this.v;
    }

    public short toshort() {
        return (short)this.v;
    }

    public double optdouble(double d) {
        return this.v;
    }

    public int optint(int n) {
        return (int)this.v;
    }

    public LuaInteger optinteger(LuaInteger luaInteger) {
        return LuaInteger.valueOf((int)this.v);
    }

    public long optlong(long l) {
        return (long)this.v;
    }

    public LuaInteger checkinteger() {
        return LuaInteger.valueOf((int)this.v);
    }

    public LuaValue neg() {
        return LuaDouble.valueOf(-this.v);
    }

    public boolean equals(Object object) {
        return object instanceof LuaDouble ? ((LuaDouble)object).v == this.v : false;
    }

    public LuaValue eq(LuaValue luaValue) {
        return luaValue.raweq(this.v) ? TRUE : FALSE;
    }

    public boolean eq_b(LuaValue luaValue) {
        return luaValue.raweq(this.v);
    }

    public boolean raweq(LuaValue luaValue) {
        return luaValue.raweq(this.v);
    }

    public boolean raweq(double d) {
        return this.v == d;
    }

    public boolean raweq(int n) {
        return this.v == (double)n;
    }

    public LuaValue add(LuaValue luaValue) {
        return luaValue.add(this.v);
    }

    public LuaValue add(double d) {
        return LuaDouble.valueOf(d + this.v);
    }

    public LuaValue sub(LuaValue luaValue) {
        return luaValue.subFrom(this.v);
    }

    public LuaValue sub(double d) {
        return LuaDouble.valueOf(this.v - d);
    }

    public LuaValue sub(int n) {
        return LuaDouble.valueOf(this.v - (double)n);
    }

    public LuaValue subFrom(double d) {
        return LuaDouble.valueOf(d - this.v);
    }

    public LuaValue mul(LuaValue luaValue) {
        return luaValue.mul(this.v);
    }

    public LuaValue mul(double d) {
        return LuaDouble.valueOf(d * this.v);
    }

    public LuaValue mul(int n) {
        return LuaDouble.valueOf((double)n * this.v);
    }

    public LuaValue pow(LuaValue luaValue) {
        return luaValue.powWith(this.v);
    }

    public LuaValue pow(double d) {
        return MathLib.dpow(this.v, d);
    }

    public LuaValue pow(int n) {
        return MathLib.dpow(this.v, n);
    }

    public LuaValue powWith(double d) {
        return MathLib.dpow(d, this.v);
    }

    public LuaValue powWith(int n) {
        return MathLib.dpow(n, this.v);
    }

    public LuaValue div(LuaValue luaValue) {
        return luaValue.divInto(this.v);
    }

    public LuaValue div(double d) {
        return LuaDouble.ddiv(this.v, d);
    }

    public LuaValue div(int n) {
        return LuaDouble.ddiv(this.v, n);
    }

    public LuaValue divInto(double d) {
        return LuaDouble.ddiv(d, this.v);
    }

    public LuaValue mod(LuaValue luaValue) {
        return luaValue.modFrom(this.v);
    }

    public LuaValue mod(double d) {
        return LuaDouble.dmod(this.v, d);
    }

    public LuaValue mod(int n) {
        return LuaDouble.dmod(this.v, n);
    }

    public LuaValue modFrom(double d) {
        return LuaDouble.dmod(d, this.v);
    }

    public static LuaValue ddiv(double d, double d2) {
        return d2 != 0.0 ? LuaDouble.valueOf(d / d2) : (d > 0.0 ? POSINF : (d == 0.0 ? NAN : NEGINF));
    }

    public static double ddiv_d(double d, double d2) {
        return d2 != 0.0 ? d / d2 : (d > 0.0 ? Double.POSITIVE_INFINITY : (d == 0.0 ? Double.NaN : Double.NEGATIVE_INFINITY));
    }

    public static LuaValue dmod(double d, double d2) {
        return d2 != 0.0 ? LuaDouble.valueOf(d - d2 * Math.floor(d / d2)) : NAN;
    }

    public static double dmod_d(double d, double d2) {
        return d2 != 0.0 ? d - d2 * Math.floor(d / d2) : Double.NaN;
    }

    public LuaValue lt(LuaValue luaValue) {
        return luaValue.gt_b(this.v) ? LuaValue.TRUE : FALSE;
    }

    public LuaValue lt(double d) {
        return this.v < d ? TRUE : FALSE;
    }

    public LuaValue lt(int n) {
        return this.v < (double)n ? TRUE : FALSE;
    }

    public boolean lt_b(LuaValue luaValue) {
        return luaValue.gt_b(this.v);
    }

    public boolean lt_b(int n) {
        return this.v < (double)n;
    }

    public boolean lt_b(double d) {
        return this.v < d;
    }

    public LuaValue lteq(LuaValue luaValue) {
        return luaValue.gteq_b(this.v) ? LuaValue.TRUE : FALSE;
    }

    public LuaValue lteq(double d) {
        return this.v <= d ? TRUE : FALSE;
    }

    public LuaValue lteq(int n) {
        return this.v <= (double)n ? TRUE : FALSE;
    }

    public boolean lteq_b(LuaValue luaValue) {
        return luaValue.gteq_b(this.v);
    }

    public boolean lteq_b(int n) {
        return this.v <= (double)n;
    }

    public boolean lteq_b(double d) {
        return this.v <= d;
    }

    public LuaValue gt(LuaValue luaValue) {
        return luaValue.lt_b(this.v) ? LuaValue.TRUE : FALSE;
    }

    public LuaValue gt(double d) {
        return this.v > d ? TRUE : FALSE;
    }

    public LuaValue gt(int n) {
        return this.v > (double)n ? TRUE : FALSE;
    }

    public boolean gt_b(LuaValue luaValue) {
        return luaValue.lt_b(this.v);
    }

    public boolean gt_b(int n) {
        return this.v > (double)n;
    }

    public boolean gt_b(double d) {
        return this.v > d;
    }

    public LuaValue gteq(LuaValue luaValue) {
        return luaValue.lteq_b(this.v) ? LuaValue.TRUE : FALSE;
    }

    public LuaValue gteq(double d) {
        return this.v >= d ? TRUE : FALSE;
    }

    public LuaValue gteq(int n) {
        return this.v >= (double)n ? TRUE : FALSE;
    }

    public boolean gteq_b(LuaValue luaValue) {
        return luaValue.lteq_b(this.v);
    }

    public boolean gteq_b(int n) {
        return this.v >= (double)n;
    }

    public boolean gteq_b(double d) {
        return this.v >= d;
    }

    public int strcmp(LuaString luaString) {
        this.typerror("attempt to compare number with string");
        return 0;
    }

    public String tojstring() {
        long l = (long)this.v;
        if ((double)l == this.v) {
            return Long.toString(l);
        }
        if (Double.isNaN(this.v)) {
            return JSTR_NAN;
        }
        if (Double.isInfinite(this.v)) {
            return this.v < 0.0 ? JSTR_NEGINF : JSTR_POSINF;
        }
        return Float.toString((float)this.v);
    }

    public LuaString strvalue() {
        return LuaString.valueOf(this.tojstring());
    }

    public LuaString optstring(LuaString luaString) {
        return LuaString.valueOf(this.tojstring());
    }

    public LuaValue tostring() {
        return LuaString.valueOf(this.tojstring());
    }

    public String optjstring(String string) {
        return this.tojstring();
    }

    public LuaNumber optnumber(LuaNumber luaNumber) {
        return this;
    }

    public boolean isnumber() {
        return true;
    }

    public boolean isstring() {
        return true;
    }

    public LuaValue tonumber() {
        return this;
    }

    public int checkint() {
        return (int)this.v;
    }

    public long checklong() {
        return (long)this.v;
    }

    public LuaNumber checknumber() {
        return this;
    }

    public double checkdouble() {
        return this.v;
    }

    public String checkjstring() {
        return this.tojstring();
    }

    public LuaString checkstring() {
        return LuaString.valueOf(this.tojstring());
    }

    public LuaValue checkvalidkey() {
        if (Double.isNaN(this.v)) {
            throw new LuaError("table index expected, got nan");
        }
        return this;
    }
}

