/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.luaj.vm2.LoadState;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.FuncState;
import org.luaj.vm2.compiler.InstructionPtr;
import org.luaj.vm2.compiler.LexState;

public class LuaC
extends Lua
implements LoadState.LuaCompiler {
    public static final LuaC instance = new LuaC();
    public static final int MAXSTACK = 250;
    static final int LUAI_MAXUPVALUES = 60;
    static final int LUAI_MAXVARS = 200;
    static final int NO_REG = 255;
    static final int iABC = 0;
    static final int iABx = 1;
    static final int iAsBx = 2;
    static final int OpArgN = 0;
    static final int OpArgU = 1;
    static final int OpArgR = 2;
    static final int OpArgK = 3;
    public int nCcalls;
    Hashtable strings;

    public static void install() {
        LoadState.compiler = instance;
    }

    protected static void _assert(boolean bl) {
        if (!bl) {
            throw new LuaError("compiler assert failed");
        }
    }

    static void SET_OPCODE(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFFFFFFC0 | n << 0 & 0x3F);
    }

    static void SETARG_A(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFFFFC03F | n << 6 & 0x3FC0);
    }

    static void SETARG_B(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0x7FFFFF | n << 23 & 0xFF800000);
    }

    static void SETARG_C(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0xFF803FFF | n << 14 & 0x7FC000);
    }

    static void SETARG_Bx(InstructionPtr instructionPtr, int n) {
        instructionPtr.set(instructionPtr.get() & 0x3FFF | n << 14 & 0xFFFFC000);
    }

    static void SETARG_sBx(InstructionPtr instructionPtr, int n) {
        LuaC.SETARG_Bx(instructionPtr, n + 131071);
    }

    static int CREATE_ABC(int n, int n2, int n3, int n4) {
        return n << 0 & 0x3F | n2 << 6 & 0x3FC0 | n3 << 23 & 0xFF800000 | n4 << 14 & 0x7FC000;
    }

    static int CREATE_ABx(int n, int n2, int n3) {
        return n << 0 & 0x3F | n2 << 6 & 0x3FC0 | n3 << 14 & 0xFFFFC000;
    }

    static LuaValue[] realloc(LuaValue[] luaValueArray, int n) {
        LuaValue[] luaValueArray2 = new LuaValue[n];
        if (luaValueArray != null) {
            System.arraycopy(luaValueArray, 0, luaValueArray2, 0, Math.min(luaValueArray.length, n));
        }
        return luaValueArray2;
    }

    static Prototype[] realloc(Prototype[] prototypeArray, int n) {
        Prototype[] prototypeArray2 = new Prototype[n];
        if (prototypeArray != null) {
            System.arraycopy(prototypeArray, 0, prototypeArray2, 0, Math.min(prototypeArray.length, n));
        }
        return prototypeArray2;
    }

    static LuaString[] realloc(LuaString[] luaStringArray, int n) {
        LuaString[] luaStringArray2 = new LuaString[n];
        if (luaStringArray != null) {
            System.arraycopy(luaStringArray, 0, luaStringArray2, 0, Math.min(luaStringArray.length, n));
        }
        return luaStringArray2;
    }

    static LocVars[] realloc(LocVars[] locVarsArray, int n) {
        LocVars[] locVarsArray2 = new LocVars[n];
        if (locVarsArray != null) {
            System.arraycopy(locVarsArray, 0, locVarsArray2, 0, Math.min(locVarsArray.length, n));
        }
        return locVarsArray2;
    }

    static int[] realloc(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        if (nArray != null) {
            System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        }
        return nArray2;
    }

    static byte[] realloc(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray != null) {
            System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        }
        return byArray2;
    }

    protected LuaC() {
    }

    private LuaC(Hashtable hashtable) {
        this.strings = hashtable;
    }

    public LuaFunction load(InputStream inputStream, String string, LuaValue luaValue) throws IOException {
        Prototype prototype = LuaC.compile(inputStream, string);
        return new LuaClosure(prototype, luaValue);
    }

    public static Prototype compile(InputStream inputStream, String string) throws IOException {
        int n = inputStream.read();
        return n == 27 ? LoadState.loadBinaryChunk(n, inputStream, string) : new LuaC(new Hashtable()).luaY_parser(n, inputStream, string);
    }

    private Prototype luaY_parser(int n, InputStream inputStream, String string) {
        LexState lexState = new LexState(this, inputStream);
        FuncState funcState = new FuncState();
        lexState.setinput(this, n, inputStream, LuaValue.valueOf(string));
        lexState.open_func(funcState);
        funcState.f.is_vararg = 2;
        funcState.f.source = LuaValue.valueOf(string);
        lexState.next();
        lexState.chunk();
        lexState.check(287);
        lexState.close_func();
        LuaC._assert(funcState.prev == null);
        LuaC._assert(funcState.f.nups == 0);
        LuaC._assert(lexState.fs == null);
        return funcState.f;
    }

    public LuaString newTString(byte[] byArray, int n, int n2) {
        LuaString luaString = LuaString.valueOf(byArray, n, n2);
        LuaString luaString2 = (LuaString)this.strings.get(luaString);
        if (luaString2 == null) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            luaString2 = LuaString.valueOf(byArray2);
            this.strings.put(luaString2, luaString2);
        }
        return luaString2;
    }

    public String pushfstring(String string) {
        return string;
    }

    public LuaFunction load(Prototype prototype, String string, LuaValue luaValue) {
        return new LuaClosure(prototype, luaValue);
    }
}

