/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.util.Random;
import org.luaj.vm2.LuaDouble;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.OneArgFunction;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.TwoArgFunction;
import org.luaj.vm2.lib.VarArgFunction;

public class MathLib
extends OneArgFunction {
    public static MathLib MATHLIB = null;
    private Random random;
    static /* synthetic */ Class class$org$luaj$vm2$lib$MathLib$MathLib1;
    static /* synthetic */ Class class$org$luaj$vm2$lib$MathLib$MathLib2;
    static /* synthetic */ Class class$org$luaj$vm2$lib$MathLib$MathLibV;

    public MathLib() {
        MATHLIB = this;
    }

    public LuaValue call(LuaValue luaValue) {
        LuaTable luaTable = new LuaTable(0, 30);
        luaTable.set("pi", Math.PI);
        luaTable.set("huge", (LuaValue)LuaDouble.POSINF);
        this.bind(luaTable, class$org$luaj$vm2$lib$MathLib$MathLib1 == null ? (class$org$luaj$vm2$lib$MathLib$MathLib1 = MathLib.class$("org.luaj.vm2.lib.MathLib$MathLib1")) : class$org$luaj$vm2$lib$MathLib$MathLib1, new String[]{"abs", "ceil", "cos", "deg", "exp", "floor", "rad", "sin", "sqrt", "tan"});
        this.bind(luaTable, class$org$luaj$vm2$lib$MathLib$MathLib2 == null ? (class$org$luaj$vm2$lib$MathLib$MathLib2 = MathLib.class$("org.luaj.vm2.lib.MathLib$MathLib2")) : class$org$luaj$vm2$lib$MathLib$MathLib2, new String[]{"fmod", "ldexp", "pow"});
        this.bind(luaTable, class$org$luaj$vm2$lib$MathLib$MathLibV == null ? (class$org$luaj$vm2$lib$MathLib$MathLibV = MathLib.class$("org.luaj.vm2.lib.MathLib$MathLibV")) : class$org$luaj$vm2$lib$MathLib$MathLibV, new String[]{"frexp", "max", "min", "modf", "randomseed", "random"});
        ((MathLibV)luaTable.get((String)"randomseed")).mathlib = this;
        ((MathLibV)luaTable.get((String)"random")).mathlib = this;
        this.env.set("math", (LuaValue)luaTable);
        PackageLib.instance.LOADED.set("math", (LuaValue)luaTable);
        return luaTable;
    }

    public static LuaValue dpow(double d, double d2) {
        return LuaDouble.valueOf(MATHLIB != null ? MATHLIB.dpow_lib(d, d2) : MathLib.dpow_default(d, d2));
    }

    public static double dpow_d(double d, double d2) {
        return MATHLIB != null ? MATHLIB.dpow_lib(d, d2) : MathLib.dpow_default(d, d2);
    }

    public double dpow_lib(double d, double d2) {
        return MathLib.dpow_default(d, d2);
    }

    protected static double dpow_default(double d, double d2) {
        double d3;
        if (d2 < 0.0) {
            return 1.0 / MathLib.dpow_default(d, -d2);
        }
        double d4 = 1.0;
        int n = (int)d2;
        double d5 = d;
        while (n > 0) {
            if ((n & 1) != 0) {
                d4 *= d5;
            }
            n >>= 1;
            d5 *= d5;
        }
        d2 -= (double)n;
        if (d3 > 0.0) {
            int n2 = (int)(65536.0 * d2);
            while ((n2 & 0xFFFF) != 0) {
                d = Math.sqrt(d);
                if ((n2 & 0x8000) != 0) {
                    d4 *= d;
                }
                n2 <<= 1;
            }
        }
        return d4;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class MathLibV
    extends VarArgFunction {
        protected MathLib mathlib;

        MathLibV() {
        }

        public Varargs invoke(Varargs varargs) {
            switch (this.opcode) {
                case 0: {
                    double d = varargs.checkdouble(1);
                    if (d == 0.0) {
                        return MathLibV.varargsOf(ZERO, (Varargs)ZERO);
                    }
                    long l = Double.doubleToLongBits(d);
                    double d2 = (double)((l & 0xFFFFFFFFFFFFFL) + 0x10000000000000L) * (l >= 0L ? (double)1.110223E-16f : (double)-1.110223E-16f);
                    double d3 = ((int)(l >> 52) & 0x7FF) - 1022;
                    return MathLibV.varargsOf(MathLibV.valueOf(d2), (Varargs)MathLibV.valueOf(d3));
                }
                case 1: {
                    double d = varargs.checkdouble(1);
                    int n = varargs.narg();
                    for (int i = 2; i <= n; ++i) {
                        d = Math.max(d, varargs.checkdouble(i));
                    }
                    return MathLibV.valueOf(d);
                }
                case 2: {
                    double d = varargs.checkdouble(1);
                    int n = varargs.narg();
                    for (int i = 2; i <= n; ++i) {
                        d = Math.min(d, varargs.checkdouble(i));
                    }
                    return MathLibV.valueOf(d);
                }
                case 3: {
                    double d = varargs.checkdouble(1);
                    double d4 = d > 0.0 ? Math.floor(d) : Math.ceil(d);
                    double d5 = d - d4;
                    return MathLibV.varargsOf(MathLibV.valueOf(d4), (Varargs)MathLibV.valueOf(d5));
                }
                case 4: {
                    long l = varargs.checklong(1);
                    this.mathlib.random = new Random(l);
                    return NONE;
                }
                case 5: {
                    if (this.mathlib.random == null) {
                        this.mathlib.random = new Random();
                    }
                    switch (varargs.narg()) {
                        case 0: {
                            return MathLibV.valueOf(this.mathlib.random.nextDouble());
                        }
                        case 1: {
                            int n = varargs.checkint(1);
                            if (n < 1) {
                                MathLibV.argerror(1, "interval is empty");
                            }
                            return MathLibV.valueOf(1 + this.mathlib.random.nextInt(n));
                        }
                    }
                    int n = varargs.checkint(1);
                    int n2 = varargs.checkint(2);
                    if (n2 < n) {
                        MathLibV.argerror(2, "interval is empty");
                    }
                    return MathLibV.valueOf(n + this.mathlib.random.nextInt(n2 + 1 - n));
                }
            }
            return NONE;
        }
    }

    static final class MathLib2
    extends TwoArgFunction {
        protected MathLib mathlib;

        MathLib2() {
        }

        public LuaValue call(LuaValue luaValue, LuaValue luaValue2) {
            switch (this.opcode) {
                case 0: {
                    double d = luaValue.checkdouble();
                    double d2 = luaValue2.checkdouble();
                    double d3 = d / d2;
                    double d4 = d - d2 * (d3 >= 0.0 ? Math.floor(d3) : Math.ceil(d3));
                    return MathLib2.valueOf(d4);
                }
                case 1: {
                    double d = luaValue.checkdouble();
                    double d5 = luaValue2.checkdouble() + 1023.5;
                    long l = (long)(0 != (1 & (int)d5) ? Math.floor(d5) : Math.ceil(d5 - 1.0));
                    return MathLib2.valueOf(d * Double.longBitsToDouble(l << 52));
                }
                case 2: {
                    return MathLib.dpow(luaValue.checkdouble(), luaValue2.checkdouble());
                }
            }
            return NIL;
        }
    }

    static final class MathLib1
    extends OneArgFunction {
        MathLib1() {
        }

        public LuaValue call(LuaValue luaValue) {
            switch (this.opcode) {
                case 0: {
                    return MathLib1.valueOf(Math.abs(luaValue.checkdouble()));
                }
                case 1: {
                    return MathLib1.valueOf(Math.ceil(luaValue.checkdouble()));
                }
                case 2: {
                    return MathLib1.valueOf(Math.cos(luaValue.checkdouble()));
                }
                case 3: {
                    return MathLib1.valueOf(Math.toDegrees(luaValue.checkdouble()));
                }
                case 4: {
                    return MathLib.dpow(Math.E, luaValue.checkdouble());
                }
                case 5: {
                    return MathLib1.valueOf(Math.floor(luaValue.checkdouble()));
                }
                case 6: {
                    return MathLib1.valueOf(Math.toRadians(luaValue.checkdouble()));
                }
                case 7: {
                    return MathLib1.valueOf(Math.sin(luaValue.checkdouble()));
                }
                case 8: {
                    return MathLib1.valueOf(Math.sqrt(luaValue.checkdouble()));
                }
                case 9: {
                    return MathLib1.valueOf(Math.tan(luaValue.checkdouble()));
                }
            }
            return NIL;
        }
    }
}

