/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib.jse;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JseProcess {
    final Process process;
    final Thread input;
    final Thread output;
    final Thread error;

    public JseProcess(String[] stringArray, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        this(Runtime.getRuntime().exec(stringArray), inputStream, outputStream, outputStream2);
    }

    public JseProcess(String string, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        this(Runtime.getRuntime().exec(string), inputStream, outputStream, outputStream2);
    }

    private JseProcess(Process process, InputStream inputStream, OutputStream outputStream, OutputStream outputStream2) {
        this.process = process;
        this.input = inputStream == null ? null : this.copyBytes(inputStream, process.getOutputStream(), null, process.getOutputStream());
        this.output = outputStream == null ? null : this.copyBytes(process.getInputStream(), outputStream, process.getInputStream(), null);
        this.error = outputStream2 == null ? null : this.copyBytes(process.getErrorStream(), outputStream2, process.getErrorStream(), null);
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public int waitFor() throws InterruptedException {
        int n = this.process.waitFor();
        if (this.input != null) {
            this.input.join();
        }
        if (this.output != null) {
            this.output.join();
        }
        if (this.error != null) {
            this.error.join();
        }
        this.process.destroy();
        return n;
    }

    private Thread copyBytes(final InputStream inputStream, final OutputStream outputStream, final InputStream inputStream2, final OutputStream outputStream2) {
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    byte[] byArray = new byte[1024];
                    try {
                        int n;
                        while ((n = inputStream.read(byArray)) >= 0) {
                            outputStream.write(byArray, 0, n);
                        }
                    }
                    finally {
                        if (inputStream2 != null) {
                            inputStream2.close();
                        }
                        if (outputStream2 != null) {
                            outputStream2.close();
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        };
        thread.start();
        return thread;
    }
}

