/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.biomes.TFBiomeDecorator;
import twilightforest.block.BlockTFDeadrock;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.DeadrockVariant;
import twilightforest.world.TFGenThorns;
import twilightforest.world.TFWorld;

public class TFBiomeThornlands
extends TFBiomeBase {
    private TFGenThorns tfGenThorns;

    public TFBiomeThornlands(Biome.BiomeProperties props) {
        super(props);
        this.field_76752_A = TFBlocks.deadrock.func_176223_P().func_177226_a(BlockTFDeadrock.VARIANT, (Comparable)((Object)DeadrockVariant.SURFACE));
        this.field_76753_B = TFBlocks.deadrock.func_176223_P().func_177226_a(BlockTFDeadrock.VARIANT, (Comparable)((Object)DeadrockVariant.CRACKED));
        ((TFBiomeDecorator)this.field_76760_I).hasCanopy = false;
        this.getTFBiomeDecorator().setTreesPerChunk(-999);
        this.field_76760_I.field_76804_C = 2;
        this.field_76760_I.field_76800_F = -9999;
        this.field_76762_K.clear();
        this.tfGenThorns = new TFGenThorns();
        this.field_76760_I.field_76808_K = false;
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        super.func_180624_a(world, rand, pos);
        for (int i = 0; i < 128; ++i) {
            int rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            int rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            int ry = this.getGroundLevel(world, new BlockPos(rx, 0, rz));
            this.tfGenThorns.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
    }

    private int getGroundLevel(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        int lastDirt = TFWorld.SEALEVEL;
        for (int y = TFWorld.SEALEVEL; y < TFWorld.CHUNKHEIGHT - 1; ++y) {
            Block blockID = chunk.func_177435_g(new BlockPos(pos.func_177958_n(), y, pos.func_177952_p())).func_177230_c();
            if (blockID == Blocks.field_150349_c) {
                return y + 1;
            }
            if (blockID != Blocks.field_150346_d && blockID != Blocks.field_150348_b && blockID != Blocks.field_150351_n && blockID != Blocks.field_150322_A && blockID != Blocks.field_150354_m && blockID != Blocks.field_150435_aG && blockID != TFBlocks.deadrock) continue;
            lastDirt = y + 1;
        }
        return lastDirt;
    }

    @Override
    public IBlockState getStoneReplacementState() {
        return TFBlocks.deadrock.func_176223_P().func_177226_a(BlockTFDeadrock.VARIANT, (Comparable)((Object)DeadrockVariant.SOLID));
    }

    @Override
    protected ResourceLocation getRequiredAchievement() {
        return new ResourceLocation("twilightforest", "progress_glacier");
    }
}

