/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import twilightforest.TFFeature;
import twilightforest.TFSounds;
import twilightforest.TFTreasure;
import twilightforest.entity.NoClipMoveHelper;
import twilightforest.entity.ai.EntityAIPhantomAttackStart;
import twilightforest.entity.ai.EntityAIPhantomThrowWeapon;
import twilightforest.entity.ai.EntityAITFFindEntityNearestPlayer;
import twilightforest.entity.ai.EntityAITFPhantomUpdateFormationAndMove;
import twilightforest.entity.ai.EntityAITFPhantomWatchAndAttack;
import twilightforest.item.TFItems;
import twilightforest.world.ChunkGeneratorTwilightForest;
import twilightforest.world.TFWorld;

public class EntityTFKnightPhantom
extends EntityFlying
implements IMob {
    private static final DataParameter<Boolean> FLAG_CHARGING = EntityDataManager.func_187226_a(EntityTFKnightPhantom.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final AttributeModifier CHARGING_MODIFIER = new AttributeModifier("Charging attack boost", 7.0, 0).func_111168_a(false);
    private int number;
    private int ticksProgress;
    private Formation currentFormation;
    private BlockPos chargePos = BlockPos.field_177992_a;
    private BlockPos homePosition = BlockPos.field_177992_a;
    private float maximumHomeDistance = -1.0f;

    public EntityTFKnightPhantom(World par1World) {
        super(par1World);
        this.func_70105_a(1.5f, 3.0f);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.currentFormation = Formation.HOVER;
        this.field_70728_aV = 93;
        this.field_70765_h = new NoClipMoveHelper((EntityLiving)this);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData data = super.func_180482_a(difficulty, livingdata);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(TFItems.knightlySword));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(TFItems.phantomPlate));
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(TFItems.phantomHelm));
        return data;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLAG_CHARGING, (Object)false);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAITFPhantomWatchAndAttack(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITFPhantomUpdateFormationAndMove(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPhantomAttackStart(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPhantomThrowWeapon(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITFFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(35.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public Formation getCurrentFormation() {
        return this.currentFormation;
    }

    public BlockPos getChargePos() {
        return this.chargePos;
    }

    public void setChargePos(BlockPos pos) {
        this.chargePos = pos;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float par2) {
        return source != DamageSource.field_76368_d && super.func_70097_a(source, par2);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isChargingAtPlayer()) {
            for (int i = 0; i < 4; ++i) {
                Item particleID = this.field_70146_Z.nextBoolean() ? TFItems.phantomHelm : TFItems.knightlySword;
                this.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70163_u + (double)this.field_70146_Z.nextFloat() * ((double)this.field_70131_O - 0.75) + 0.5, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 0.0, -0.1, 0.0, new int[]{Item.func_150891_b((Item)particleID)});
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.field_70163_u + (double)this.field_70146_Z.nextFloat() * ((double)this.field_70131_O - 0.75) + 0.5, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 0.0, 0.1, 0.0, new int[0]);
            }
        }
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        for (int i = 0; i < 20; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    public void func_70645_a(DamageSource par1DamageSource) {
        List<EntityTFKnightPhantom> nearbyKnights;
        super.func_70645_a(par1DamageSource);
        if (!this.field_70170_p.field_72995_K && TFWorld.getChunkGenerator(this.field_70170_p) instanceof ChunkGeneratorTwilightForest) {
            int dx = this.getHomePosition().func_177958_n();
            int dy = this.getHomePosition().func_177956_o();
            int dz = this.getHomePosition().func_177952_p();
            ChunkGeneratorTwilightForest generator = (ChunkGeneratorTwilightForest)TFWorld.getChunkGenerator(this.field_70170_p);
            TFFeature nearbyFeature = TFFeature.getFeatureAt(dx, dz, this.field_70170_p);
            if (nearbyFeature == TFFeature.tfStronghold) {
                generator.setStructureConquered(dx, dy, dz, true);
            }
        }
        if (!this.field_70170_p.field_72995_K && (nearbyKnights = this.getNearbyKnights()).size() <= 1) {
            this.makeATreasure();
        }
    }

    private void makeATreasure() {
        if (this.hasHome()) {
            TFTreasure.stronghold_boss.generateChest(this.field_70170_p, this.getHomePosition().func_177977_b(), false);
        } else {
            TFTreasure.stronghold_boss.generateChest(this.field_70170_p, new BlockPos((Entity)this), false);
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0 && entityIn instanceof EntityLivingBase) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, (float)i * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            if (entityIn instanceof EntityPlayer) {
                ItemStack itemstack1;
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                ItemStack itemstack = this.func_184614_ca();
                ItemStack itemStack = itemstack1 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemstack.func_190926_b() && !itemstack1.func_190926_b() && itemstack.func_77973_b() instanceof ItemAxe && itemstack1.func_77973_b() == Items.field_185159_cQ) {
                    float f1 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < f1) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        this.field_70170_p.func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70653_a(Entity par1Entity, float damage, double par3, double par5) {
        this.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(par3 * par3 + par5 * par5));
        float distance = 0.2f;
        this.field_70159_w /= 2.0;
        this.field_70181_x /= 2.0;
        this.field_70179_y /= 2.0;
        this.field_70159_w -= par3 / (double)f * (double)distance;
        this.field_70181_x += (double)distance;
        this.field_70179_y -= par5 / (double)f * (double)distance;
        if (this.field_70181_x > (double)0.4f) {
            this.field_70181_x = 0.4f;
        }
    }

    public List<EntityTFKnightPhantom> getNearbyKnights() {
        return this.field_70170_p.func_72872_a(EntityTFKnightPhantom.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_72314_b(32.0, 8.0, 32.0));
    }

    private void updateMyNumber() {
        ArrayList nums = Lists.newArrayList();
        List<EntityTFKnightPhantom> knights = this.getNearbyKnights();
        for (EntityTFKnightPhantom knight : knights) {
            if (knight == this) continue;
            nums.add(knight.getNumber());
            if (knight.getNumber() != 0) continue;
            this.setHomePosAndDistance(knight.getHomePosition(), 20);
        }
        if (nums.isEmpty()) {
            return;
        }
        int[] n = Ints.toArray((Collection)nums);
        Arrays.sort(n);
        int smallest = n[0];
        int largest = knights.size() + 1;
        int smallestUnused = largest + 1;
        if (smallest > 0) {
            smallestUnused = 0;
        } else {
            for (int i = 1; i < largest; ++i) {
                if (Arrays.binarySearch(n, i) >= 0) continue;
                smallestUnused = i;
                break;
            }
        }
        if (this.number > smallestUnused || nums.contains(this.number)) {
            this.setNumber(smallestUnused);
        }
    }

    public boolean isChargingAtPlayer() {
        return (Boolean)this.field_70180_af.func_187225_a(FLAG_CHARGING);
    }

    private void setChargingAtPlayer(boolean flag) {
        this.field_70180_af.func_187227_b(FLAG_CHARGING, (Object)flag);
        if (!this.field_70170_p.field_72995_K) {
            if (flag) {
                if (!this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(CHARGING_MODIFIER)) {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(CHARGING_MODIFIER);
                }
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(CHARGING_MODIFIER);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return TFSounds.WRAITH;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return TFSounds.WRAITH;
    }

    protected SoundEvent func_184615_bR() {
        return TFSounds.WRAITH;
    }

    private void switchToFormationByNumber(int formationNumber) {
        this.currentFormation = Formation.values()[formationNumber];
        this.ticksProgress = 0;
    }

    public void switchToFormation(Formation formation) {
        this.currentFormation = formation;
        this.ticksProgress = 0;
        this.updateMyNumber();
        this.setChargingAtPlayer(this.currentFormation == Formation.ATTACK_PLAYER_START || this.currentFormation == Formation.ATTACK_PLAYER_ATTACK);
    }

    private int getFormationAsNumber() {
        return this.currentFormation.ordinal();
    }

    public int getTicksProgress() {
        return this.ticksProgress;
    }

    public void setTicksProgress(int ticksProgress) {
        this.ticksProgress = ticksProgress;
    }

    public int getMaxTicksForFormation() {
        switch (this.currentFormation) {
            default: {
                return 90;
            }
            case LARGE_CLOCKWISE: {
                return 180;
            }
            case SMALL_CLOCKWISE: {
                return 90;
            }
            case LARGE_ANTICLOCKWISE: {
                return 180;
            }
            case SMALL_ANTICLOCKWISE: {
                return 90;
            }
            case CHARGE_PLUSX: {
                return 180;
            }
            case CHARGE_MINUSX: {
                return 180;
            }
            case CHARGE_PLUSZ: {
                return 180;
            }
            case CHARGE_MINUSZ: {
                return 180;
            }
            case ATTACK_PLAYER_START: {
                return 50;
            }
            case ATTACK_PLAYER_ATTACK: {
                return 50;
            }
            case WAITING_FOR_LEADER: 
        }
        return 10;
    }

    public boolean isSwordKnight() {
        return this.func_184614_ca().func_77973_b() == TFItems.knightlySword;
    }

    public boolean isAxeKnight() {
        return this.func_184614_ca().func_77973_b() == TFItems.knightlyAxe;
    }

    public boolean isPickKnight() {
        return this.func_184614_ca().func_77973_b() == TFItems.knightlyPick;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        switch (number % 3) {
            case 0: {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(TFItems.knightlySword));
                break;
            }
            case 1: {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(TFItems.knightlyAxe));
                break;
            }
            case 2: {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(TFItems.knightlyPick));
            }
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        if (this.hasHome()) {
            BlockPos home = this.getHomePosition();
            nbttagcompound.func_74782_a("Home", (NBTBase)this.func_70087_a(new double[]{home.func_177958_n(), home.func_177956_o(), home.func_177952_p()}));
        }
        nbttagcompound.func_74768_a("MyNumber", this.getNumber());
        nbttagcompound.func_74768_a("Formation", this.getFormationAsNumber());
        nbttagcompound.func_74768_a("TicksProgress", this.getTicksProgress());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        if (nbttagcompound.func_150297_b("Home", 9)) {
            NBTTagList nbttaglist = nbttagcompound.func_150295_c("Home", 6);
            int hx = (int)nbttaglist.func_150309_d(0);
            int hy = (int)nbttaglist.func_150309_d(1);
            int hz = (int)nbttaglist.func_150309_d(2);
            this.setHomePosAndDistance(new BlockPos(hx, hy, hz), 20);
        } else {
            this.detachHome();
        }
        this.setNumber(nbttagcompound.func_74762_e("MyNumber"));
        this.switchToFormationByNumber(nbttagcompound.func_74762_e("Formation"));
        this.setTicksProgress(nbttagcompound.func_74762_e("TicksProgress"));
    }

    public boolean isWithinHomeDistanceCurrentPosition() {
        return this.isWithinHomeDistanceFromPosition(new BlockPos((Entity)this));
    }

    public boolean isWithinHomeDistanceFromPosition(BlockPos pos) {
        return this.maximumHomeDistance == -1.0f ? true : this.homePosition.func_177951_i((Vec3i)pos) < (double)(this.maximumHomeDistance * this.maximumHomeDistance);
    }

    public void setHomePosAndDistance(BlockPos pos, int distance) {
        this.homePosition = this.chargePos = pos;
        this.maximumHomeDistance = distance;
    }

    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    public float getMaximumHomeDistance() {
        return this.maximumHomeDistance;
    }

    public void detachHome() {
        this.maximumHomeDistance = -1.0f;
    }

    public boolean hasHome() {
        return this.maximumHomeDistance != -1.0f;
    }

    public static enum Formation {
        HOVER,
        LARGE_CLOCKWISE,
        SMALL_CLOCKWISE,
        LARGE_ANTICLOCKWISE,
        SMALL_ANTICLOCKWISE,
        CHARGE_PLUSX,
        CHARGE_MINUSX,
        CHARGE_PLUSZ,
        CHARGE_MINUSZ,
        WAITING_FOR_LEADER,
        ATTACK_PLAYER_START,
        ATTACK_PLAYER_ATTACK;

    }
}

