/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import twilightforest.TFFeature;
import twilightforest.world.TFBiomeProvider;

public class TFMagicMapData
extends MapData {
    public final List<MapDecoration> featuresVisibleOnMap = new ArrayList<MapDecoration>();

    public TFMagicMapData(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound cmp) {
        super.func_76184_a(cmp);
        byte[] featureStorage = cmp.func_74770_j("features");
        if (featureStorage.length > 0) {
            this.deserializeFeatures(featureStorage);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound cmp) {
        cmp = super.func_189551_b(cmp);
        if (this.featuresVisibleOnMap.size() > 0) {
            cmp.func_74773_a("features", this.serializeFeatures());
        }
        return cmp;
    }

    public void addFeatureToMap(TFFeature feature, int x, int z) {
        byte relativeX = (byte)(x - this.field_76201_a >> this.field_76197_d);
        byte relativeZ = (byte)(z - this.field_76199_b >> this.field_76197_d);
        byte rangeX = 64;
        byte rangeY = 64;
        if (relativeX >= -rangeX && relativeZ >= -rangeY && relativeX <= rangeX && relativeZ <= rangeY) {
            byte markerIcon = (byte)feature.featureID;
            byte mapX = (byte)(relativeX << 1);
            byte mapZ = (byte)(relativeZ << 1);
            byte mapRotation = 8;
            for (MapDecoration existingCoord : this.featuresVisibleOnMap) {
                if (existingCoord.func_176112_b() != mapX || existingCoord.func_176113_c() != mapZ) continue;
                return;
            }
            this.featuresVisibleOnMap.add(new MapDecoration(MapDecoration.Type.RED_MARKER, mapX, mapZ, mapRotation));
        }
    }

    public void checkExistingFeatures(World world) {
        ArrayList<MapDecoration> toRemove = new ArrayList<MapDecoration>();
        ArrayList<MapDecoration> toAdd = new ArrayList<MapDecoration>();
        for (MapDecoration coord : this.featuresVisibleOnMap) {
            int worldX = (coord.func_176112_b() << this.field_76197_d - 1) + this.field_76201_a;
            int worldZ = (coord.func_176113_c() << this.field_76197_d - 1) + this.field_76199_b;
            if (world == null || !(world.func_72959_q() instanceof TFBiomeProvider)) continue;
            TFBiomeProvider provider = (TFBiomeProvider)world.func_72959_q();
            byte trueId = (byte)TFFeature.getFeatureID(worldX, worldZ, world);
            if (coord.func_191179_b() == MapDecoration.Type.RED_MARKER) continue;
            toRemove.add(coord);
            toAdd.add(new MapDecoration(MapDecoration.Type.RED_MARKER, coord.func_176112_b(), coord.func_176113_c(), coord.func_176111_d()));
        }
        this.featuresVisibleOnMap.removeAll(toRemove);
        this.featuresVisibleOnMap.addAll(toAdd);
    }

    public void deserializeFeatures(byte[] arr) {
        this.featuresVisibleOnMap.clear();
        for (int i = 0; i < arr.length / 3; ++i) {
            byte markerIcon = arr[i * 3];
            byte mapX = arr[i * 3 + 1];
            byte mapZ = arr[i * 3 + 2];
            byte mapRotation = 8;
            this.featuresVisibleOnMap.add(new MapDecoration(MapDecoration.Type.RED_MARKER, mapX, mapZ, mapRotation));
        }
    }

    public byte[] serializeFeatures() {
        byte[] storage = new byte[this.featuresVisibleOnMap.size() * 3];
        for (int i = 0; i < this.featuresVisibleOnMap.size(); ++i) {
            MapDecoration featureCoord = this.featuresVisibleOnMap.get(i);
            storage[i * 3] = (byte)featureCoord.func_191179_b().ordinal();
            storage[i * 3 + 1] = featureCoord.func_176112_b();
            storage[i * 3 + 2] = featureCoord.func_176113_c();
        }
        return storage;
    }

    public void func_176054_a(double x, double z, int mapScale) {
        int mapSize = 128 * (1 << mapScale);
        int roundX = (int)Math.round(x / (double)mapSize);
        int roundZ = (int)Math.round(z / (double)mapSize);
        this.field_76201_a = roundX * mapSize;
        this.field_76199_b = roundZ * mapSize;
    }
}

