/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import twilightforest.block.BlockTFHedge;
import twilightforest.block.BlockTFLog;
import twilightforest.block.TFBlockProperties;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.HedgeVariant;
import twilightforest.block.enums.WoodVariant;
import twilightforest.world.IBlockSettable;
import twilightforest.world.TFGenHollowTree;
import twilightforest.world.TFGenerator;

public abstract class TFTreeGenerator
extends WorldGenAbstractTree
implements IBlockSettable {
    protected IBlockState treeState = TFBlocks.log.func_176223_P();
    protected IBlockState branchState = TFBlocks.log.func_176223_P().func_177226_a((IProperty)BlockTFLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE).func_177226_a(BlockTFLog.VARIANT, (Comparable)((Object)WoodVariant.DARK));
    protected IBlockState leafState = TFBlocks.hedge.func_176223_P().func_177226_a(BlockTFHedge.VARIANT, (Comparable)((Object)HedgeVariant.DARKWOOD_LEAVES));
    protected IBlockState rootState = TFBlocks.root.func_176223_P();

    public TFTreeGenerator() {
        this(false);
    }

    public TFTreeGenerator(boolean par1) {
        super(par1);
    }

    @Override
    public final void setBlockAndNotify(World world, BlockPos pos, IBlockState state) {
        this.func_175903_a(world, pos, state);
    }

    protected boolean func_150523_a(Block blockType) {
        return TFGenHollowTree.canGrowInto(blockType);
    }

    protected void buildRoot(World world, BlockPos pos, double offset, int b) {
        BlockPos[] lineArray;
        BlockPos dest = TFGenerator.translate(pos.func_177979_c(b + 2), 5.0, 0.3 * (double)b + offset, 0.8);
        for (BlockPos coord : lineArray = TFGenerator.getBresehnamArrays(pos.func_177977_b(), dest)) {
            this.placeRootBlock(world, coord, this.rootState);
        }
    }

    protected void placeRootBlock(World world, BlockPos pos, IBlockState state) {
        if (TFTreeGenerator.canRootGrowIn(world, pos)) {
            this.func_175903_a(world, pos, state);
        }
    }

    public static boolean canRootGrowIn(World world, BlockPos pos) {
        Block blockID = world.func_180495_p(pos).func_177230_c();
        if (blockID == Blocks.field_150350_a) {
            return TFGenerator.isNearSolid(world, pos);
        }
        return blockID != Blocks.field_150357_h && blockID != Blocks.field_150343_Z && blockID != TFBlocks.shield;
    }

    protected void addFirefly(World world, BlockPos pos, int height, double angle) {
        int iAngle = (int)(angle * 4.0);
        if (iAngle == 0) {
            this.setIfEmpty(world, pos.func_177982_a(1, height, 0), TFBlocks.firefly.func_176223_P().func_177226_a((IProperty)TFBlockProperties.FACING, (Comparable)EnumFacing.EAST));
        } else if (iAngle == 1) {
            this.setIfEmpty(world, pos.func_177982_a(-1, height, 0), TFBlocks.firefly.func_176223_P().func_177226_a((IProperty)TFBlockProperties.FACING, (Comparable)EnumFacing.WEST));
        } else if (iAngle == 2) {
            this.setIfEmpty(world, pos.func_177982_a(0, height, 1), TFBlocks.firefly.func_176223_P().func_177226_a((IProperty)TFBlockProperties.FACING, (Comparable)EnumFacing.SOUTH));
        } else if (iAngle == 3) {
            this.setIfEmpty(world, pos.func_177982_a(0, height, -1), TFBlocks.firefly.func_176223_P().func_177226_a((IProperty)TFBlockProperties.FACING, (Comparable)EnumFacing.NORTH));
        }
    }

    private void setIfEmpty(World world, BlockPos pos, IBlockState state) {
        if (world.func_175623_d(pos)) {
            this.func_175903_a(world, pos, state);
        }
    }
}

