/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.TFBlocks;

public class TFTeleporter
extends Teleporter {
    public static TFTeleporter getTeleporterForDim(MinecraftServer server, int dim) {
        WorldServer ws = server.func_71218_a(dim);
        for (Teleporter t : ws.customTeleporters) {
            if (!(t instanceof TFTeleporter)) continue;
            return (TFTeleporter)t;
        }
        TFTeleporter tp = new TFTeleporter(ws);
        ws.customTeleporters.add(tp);
        return tp;
    }

    private TFTeleporter(WorldServer dest) {
        super(dest);
    }

    public void func_180266_a(Entity par1Entity, float facing) {
        if (!this.func_180620_b(par1Entity, facing)) {
            BlockPos pos;
            if (par1Entity.field_70170_p.func_82736_K().func_82766_b("tfEnforcedProgression") && !this.isSafeBiomeAt(pos = new BlockPos(par1Entity), par1Entity)) {
                TwilightForestMod.LOGGER.debug("Portal destination looks unsafe, rerouting!");
                BlockPos safeCoords = this.findSafeCoords(200, pos, par1Entity);
                if (safeCoords != null) {
                    par1Entity.func_70012_b((double)safeCoords.func_177958_n(), par1Entity.field_70163_u, (double)safeCoords.func_177952_p(), 90.0f, 0.0f);
                    TwilightForestMod.LOGGER.debug("Safely rerouted!");
                } else {
                    TwilightForestMod.LOGGER.debug("Did not find a safe spot at first try, trying again with longer range.");
                    safeCoords = this.findSafeCoords(400, pos, par1Entity);
                    if (safeCoords != null) {
                        par1Entity.func_70012_b((double)safeCoords.func_177958_n(), par1Entity.field_70163_u, (double)safeCoords.func_177952_p(), 90.0f, 0.0f);
                        TwilightForestMod.LOGGER.debug("Safely rerouted to long range portal.  Return trip not guaranteed.");
                    } else {
                        TwilightForestMod.LOGGER.debug("Did not find a safe spot.");
                    }
                }
            }
            this.func_85188_a(par1Entity);
            this.func_180620_b(par1Entity, facing);
        }
    }

    private BlockPos findSafeCoords(int range, BlockPos pos, Entity par1Entity) {
        for (int i = 0; i < 25; ++i) {
            BlockPos dPos = new BlockPos(pos.func_177958_n() + this.field_77187_a.nextInt(range) - this.field_77187_a.nextInt(range), 100, pos.func_177952_p() + this.field_77187_a.nextInt(range) - this.field_77187_a.nextInt(range));
            if (!this.isSafeBiomeAt(dPos, par1Entity)) continue;
            return dPos;
        }
        return null;
    }

    private boolean isSafeBiomeAt(BlockPos pos, Entity par1Entity) {
        Biome biomeAt = this.field_85192_a.func_180494_b(pos);
        if (biomeAt instanceof TFBiomeBase && par1Entity instanceof EntityPlayerMP) {
            TFBiomeBase tfBiome = (TFBiomeBase)biomeAt;
            EntityPlayerMP player = (EntityPlayerMP)par1Entity;
            return tfBiome.doesPlayerHaveRequiredAchievement((EntityPlayer)player);
        }
        return true;
    }

    public boolean func_180620_b(Entity entityIn, float rotationYaw) {
        int i = 200;
        double d0 = -1.0;
        int j = MathHelper.func_76128_c((double)entityIn.field_70165_t);
        int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
        boolean flag = true;
        BlockPos blockpos = BlockPos.field_177992_a;
        long l = ChunkPos.func_77272_a((int)j, (int)k);
        if (this.field_85191_c.containsKey(l)) {
            Teleporter.PortalPosition teleporter$portalposition = (Teleporter.PortalPosition)this.field_85191_c.get(l);
            d0 = 0.0;
            blockpos = teleporter$portalposition;
            teleporter$portalposition.field_85087_d = this.field_85192_a.func_82737_E();
            flag = false;
        } else {
            BlockPos blockpos3 = new BlockPos(entityIn);
            for (int i1 = -i; i1 <= i; ++i1) {
                for (int j1 = -i; j1 <= i; ++j1) {
                    BlockPos blockpos1 = blockpos3.func_177982_a(i1, this.field_85192_a.func_72940_L() - 1 - blockpos3.func_177956_o(), j1);
                    while (blockpos1.func_177956_o() >= 0) {
                        BlockPos blockpos2 = blockpos1.func_177977_b();
                        if (this.field_85192_a.func_180495_p(blockpos1).func_177230_c() == TFBlocks.portal) {
                            blockpos2 = blockpos1.func_177977_b();
                            while (this.field_85192_a.func_180495_p(blockpos2).func_177230_c() == TFBlocks.portal) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.func_177977_b();
                            }
                            double d1 = blockpos1.func_177951_i((Vec3i)blockpos3);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                blockpos = blockpos1;
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (d0 >= 0.0) {
            if (flag) {
                this.field_85191_c.put(l, (Object)new Teleporter.PortalPosition((Teleporter)this, blockpos, this.field_85192_a.func_82737_E()));
            }
            double portalX = (double)blockpos.func_177958_n() + 0.5;
            double portalY = (double)blockpos.func_177956_o() + 0.5;
            double portalZ = (double)blockpos.func_177952_p() + 0.5;
            if (this.isBlockPortal((World)this.field_85192_a, blockpos.func_177976_e())) {
                portalX -= 0.5;
            }
            if (this.isBlockPortal((World)this.field_85192_a, blockpos.func_177974_f())) {
                portalX += 0.5;
            }
            if (this.isBlockPortal((World)this.field_85192_a, blockpos.func_177978_c())) {
                portalZ -= 0.5;
            }
            if (this.isBlockPortal((World)this.field_85192_a, blockpos.func_177968_d())) {
                portalZ += 0.5;
            }
            int xOffset = 0;
            int zOffset = 0;
            while (xOffset == zOffset && xOffset == 0) {
                xOffset = this.field_77187_a.nextInt(3) - this.field_77187_a.nextInt(3);
                zOffset = this.field_77187_a.nextInt(3) - this.field_77187_a.nextInt(3);
            }
            entityIn.field_70179_y = 0.0;
            entityIn.field_70181_x = 0.0;
            entityIn.field_70159_w = 0.0;
            if (entityIn instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entityIn).field_71135_a.func_147364_a(portalX + (double)xOffset, portalY + 1.0, portalZ + (double)zOffset, entityIn.field_70177_z, entityIn.field_70125_A);
            } else {
                entityIn.func_70012_b(portalX + (double)xOffset, portalY + 1.0, portalZ + (double)zOffset, entityIn.field_70177_z, entityIn.field_70125_A);
            }
            return true;
        }
        return false;
    }

    private boolean isBlockPortal(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == TFBlocks.portal;
    }

    public boolean func_85188_a(Entity entity) {
        BlockPos spot = this.findPortalCoords(entity, true);
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found ideal portal spot");
            this.makePortalAt((World)this.field_85192_a, spot);
            return true;
        }
        TwilightForestMod.LOGGER.debug("Did not find ideal portal spot, shooting for okay one");
        spot = this.findPortalCoords(entity, false);
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found okay portal spot");
            this.makePortalAt((World)this.field_85192_a, spot);
            return true;
        }
        TwilightForestMod.LOGGER.debug("Did not even find an okay portal spot, just making a random one");
        double yFactor = this.field_85192_a.field_73011_w.getDimension() == 0 ? 2.0 : 0.5;
        this.makePortalAt((World)this.field_85192_a, new BlockPos(entity.field_70165_t, entity.field_70163_u * yFactor, entity.field_70161_v));
        return false;
    }

    private BlockPos findPortalCoords(Entity entity, boolean ideal) {
        double yFactor = this.field_85192_a.field_73011_w.getDimension() == 0 ? 2.0 : 0.5;
        int entityX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int entityZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        double spotWeight = -1.0;
        BlockPos spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - entity.field_70165_t;
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - entity.field_70161_v;
                for (int ry = 127; ry >= 0; --ry) {
                    BlockPos pos = new BlockPos(rx, ry, rz);
                    if (!this.field_85192_a.func_175623_d(pos)) continue;
                    while (pos.func_177956_o() > 0 && this.field_85192_a.func_175623_d(pos.func_177977_b())) {
                        pos = pos.func_177977_b();
                    }
                    if (!(ideal ? this.isIdealPortal(pos) : this.isOkayPortal(pos))) continue;
                    double yWeight = (double)pos.func_177956_o() + 0.5 - entity.field_70163_u * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight)) continue;
                    spotWeight = rPosWeight;
                    spot = pos;
                }
            }
        }
        return spot;
    }

    private boolean isIdealPortal(BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = -1; potentialY < 3; ++potentialY) {
                    BlockPos tPos = pos.func_177982_a(potentialX - 1, potentialY, potentialZ - 1);
                    if ((potentialY != -1 || this.field_85192_a.func_180495_p(tPos).func_185904_a() == Material.field_151577_b) && (potentialY < 0 || this.field_85192_a.func_180495_p(tPos).func_185904_a().func_76222_j())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isOkayPortal(BlockPos pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = -1; potentialY < 3; ++potentialY) {
                    BlockPos tPos = pos.func_177982_a(potentialX - 1, potentialY, potentialZ - 1);
                    if ((potentialY != -1 || this.field_85192_a.func_180495_p(tPos).func_185904_a().func_76220_a()) && (potentialY < 0 || this.field_85192_a.func_180495_p(tPos).func_185904_a().func_76222_j())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void makePortalAt(World world, BlockPos pos) {
        if (pos.func_177956_o() < 30) {
            pos = new BlockPos(pos.func_177958_n(), 30, pos.func_177952_p());
        }
        if (pos.func_177956_o() > 118) {
            pos = new BlockPos(pos.func_177958_n(), 118, pos.func_177952_p());
        }
        pos = pos.func_177977_b();
        world.func_175656_a(pos.func_177976_e().func_177978_c(), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177978_c(), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177974_f().func_177978_c(), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177965_g(2).func_177978_c(), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177976_e(), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177965_g(2), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177976_e().func_177968_d(), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177965_g(2).func_177968_d(), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177976_e().func_177970_e(2), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177970_e(2), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177974_f().func_177970_e(2), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177965_g(2).func_177970_e(2), Blocks.field_150349_c.func_176223_P());
        world.func_175656_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P());
        world.func_175656_a(pos.func_177974_f().func_177977_b(), Blocks.field_150346_d.func_176223_P());
        world.func_175656_a(pos.func_177968_d().func_177977_b(), Blocks.field_150346_d.func_176223_P());
        world.func_175656_a(pos.func_177974_f().func_177968_d().func_177977_b(), Blocks.field_150346_d.func_176223_P());
        world.func_180501_a(pos, TFBlocks.portal.func_176223_P(), 2);
        world.func_180501_a(pos.func_177974_f(), TFBlocks.portal.func_176223_P(), 2);
        world.func_180501_a(pos.func_177968_d(), TFBlocks.portal.func_176223_P(), 2);
        world.func_180501_a(pos.func_177974_f().func_177968_d(), TFBlocks.portal.func_176223_P(), 2);
        for (int dx = -1; dx <= 2; ++dx) {
            for (int dz = -1; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 5; ++dy) {
                    world.func_175698_g(pos.func_177982_a(dx, dy, dz));
                }
            }
        }
        world.func_180501_a(pos.func_177976_e().func_177978_c().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177978_c().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177974_f().func_177978_c().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177978_c().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177976_e().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177976_e().func_177968_d().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177968_d().func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177976_e().func_177970_e(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177970_e(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177974_f().func_177970_e(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
        world.func_180501_a(pos.func_177965_g(2).func_177970_e(2).func_177984_a(), this.randNatureBlock(world.field_73012_v), 2);
    }

    private IBlockState randNatureBlock(Random random) {
        Block[] block = new Block[]{Blocks.field_150338_P, Blocks.field_150337_Q, Blocks.field_150329_H, Blocks.field_150328_O, Blocks.field_150327_N};
        return block[random.nextInt(block.length)].func_176223_P();
    }
}

