/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFAuroraBrick;
import twilightforest.block.BlockTFCastleDoor;
import twilightforest.block.BlockTFCastleMagic;
import twilightforest.block.BlockTFFireJet;
import twilightforest.block.BlockTFLeaves;
import twilightforest.block.BlockTFLeaves3;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.BlockTFTowerWood;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.FireJetVariant;
import twilightforest.block.enums.Leaves3Variant;
import twilightforest.block.enums.LeavesVariant;
import twilightforest.block.enums.MagicWoodVariant;
import twilightforest.block.enums.PlantVariant;
import twilightforest.block.enums.TowerWoodVariant;
import twilightforest.item.TFItems;

@SideOnly(value=Side.CLIENT)
public final class ColorHandler {
    public static void init() {
        BlockColors blockColors = Minecraft.func_71410_x().func_184125_al();
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> tintIndex > 15 ? 0xFFFFFF : Color.HSBtoRGB(worldIn == null ? 0.45f : BlockTFAuroraBrick.rippleFractialNoise(3, 256.0f, pos != null ? pos.func_177981_b(128) : new BlockPos(0, 0, 0), 0.37f, 0.67f, 2.0f), 1.0f, 1.0f), new Block[]{TFBlocks.auroraBlock});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            int normalColor = Minecraft.func_71410_x().func_184125_al().func_186724_a(TFBlocks.auroraBlock.func_176223_P(), worldIn, pos, tintIndex);
            int red = normalColor >> 16 & 0xFF;
            int blue = normalColor & 0xFF;
            int green = normalColor >> 8 & 0xFF;
            float[] hsb = Color.RGBtoHSB(red, blue, green, null);
            return Color.HSBtoRGB(hsb[0], hsb[1] * 0.5f, Math.min(hsb[2] + 0.4f, 0.9f));
        }, new Block[]{TFBlocks.auroraPillar, TFBlocks.auroraSlab, TFBlocks.auroraDoubleSlab});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null) {
                return ColorizerFoliage.func_77468_c();
            }
            int red = 0;
            int grn = 0;
            int blu = 0;
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dx = -1; dx <= 1; ++dx) {
                    int i2 = worldIn.func_180494_b(pos.func_177982_a(dx, 0, dz)).func_180625_c(pos.func_177982_a(dx, 0, dz));
                    red += (i2 & 0xFF0000) >> 16;
                    grn += (i2 & 0xFF00) >> 8;
                    blu += i2 & 0xFF;
                }
            }
            return (red / 9 & 0xFF) << 16 | (grn / 9 & 0xFF) << 8 | blu / 9 & 0xFF;
        }, new Block[]{TFBlocks.darkleaves, TFBlocks.giantLeaves});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> tintIndex > 15 ? 0xFFFFFF : (((FireJetVariant)((Object)((Object)state.func_177229_b(BlockTFFireJet.VARIANT)))).hasGrassColor ? Minecraft.func_71410_x().func_184125_al().func_186724_a(Blocks.field_150349_c.func_176223_P(), worldIn, pos, tintIndex) : 0xFFFFFF), new Block[]{TFBlocks.fireJet});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null) {
                switch ((MagicWoodVariant)((Object)((Object)state.func_177229_b(BlockTFMagicLog.VARIANT)))) {
                    case TIME: {
                        return 6986775;
                    }
                    case TRANS: {
                        return 7130346;
                    }
                    case MINE: {
                        return 16576836;
                    }
                    case SORT: {
                        return 3558403;
                    }
                }
                return -1;
            }
            int red = -1;
            int green = -1;
            int blue = -1;
            MagicWoodVariant leafType = (MagicWoodVariant)((Object)((Object)state.func_177229_b(BlockTFMagicLog.VARIANT)));
            if (leafType == MagicWoodVariant.TIME) {
                int fade = pos.func_177958_n() * 16 + pos.func_177956_o() * 16 + pos.func_177952_p() * 16;
                if ((fade & 0x100) != 0) {
                    fade = 255 - (fade & 0xFF);
                }
                float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
                float fall = (float)fade / 255.0f;
                red = (int)(spring * 106.0f + fall * 251.0f);
                green = (int)(spring * 156.0f + fall * 108.0f);
                blue = (int)(spring * 23.0f + fall * 27.0f);
            } else if (leafType == MagicWoodVariant.MINE) {
                int fade = pos.func_177958_n() * 31 + pos.func_177956_o() * 33 + pos.func_177952_p() * 32;
                if ((fade & 0x100) != 0) {
                    fade = 255 - (fade & 0xFF);
                }
                float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
                float fall = (float)fade / 255.0f;
                red = (int)(spring * 252.0f + fall * 237.0f);
                green = (int)(spring * 241.0f + fall * 172.0f);
                blue = (int)(spring * 68.0f + fall * 9.0f);
            } else if (leafType == MagicWoodVariant.TRANS) {
                int fade = pos.func_177958_n() * 27 + pos.func_177956_o() * 63 + pos.func_177952_p() * 39;
                if ((fade & 0x100) != 0) {
                    fade = 255 - (fade & 0xFF);
                }
                float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
                float fall = (float)fade / 255.0f;
                red = (int)(spring * 108.0f + fall * 96.0f);
                green = (int)(spring * 204.0f + fall * 107.0f);
                blue = (int)(spring * 234.0f + fall * 121.0f);
            } else if (leafType == MagicWoodVariant.SORT) {
                int fade = pos.func_177958_n() * 63 + pos.func_177956_o() * 63 + pos.func_177952_p() * 63;
                if ((fade & 0x100) != 0) {
                    fade = 255 - (fade & 0xFF);
                }
                float spring = (float)(255 - (fade &= 0xFF)) / 255.0f;
                float fall = (float)fade / 255.0f;
                red = (int)(spring * 54.0f + fall * 168.0f);
                green = (int)(spring * 76.0f + fall * 199.0f);
                blue = (int)(spring * 3.0f + fall * 43.0f);
            }
            return red << 16 | green << 8 | blue;
        }, new Block[]{TFBlocks.magicLeaves});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (worldIn == null || pos == null || state.func_177229_b(BlockTFTowerWood.VARIANT) == TowerWoodVariant.ENCASED) {
                return -1;
            }
            int value = pos.func_177958_n() * 31 + pos.func_177956_o() * 15 + pos.func_177952_p() * 33;
            if ((value & 0x100) != 0) {
                value = 255 - (value & 0xFF);
            }
            value &= 0xFF;
            value >>= 1;
            return (value |= 0x80) << 16 | value << 8 | value;
        }, new Block[]{TFBlocks.towerWood});
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            if (world == null || pos == null) {
                switch ((LeavesVariant)((Object)((Object)state.func_177229_b(BlockTFLeaves.VARIANT)))) {
                    case CANOPY: {
                        return 6330464;
                    }
                    case MANGROVE: {
                        return 8431445;
                    }
                }
                return 4764952;
            }
            int red = 0;
            int green = 0;
            int blue = 0;
            for (int var9 = -1; var9 <= 1; ++var9) {
                for (int var10 = -1; var10 <= 1; ++var10) {
                    int var11 = world.func_180494_b(pos.func_177982_a(var10, 0, var9)).func_180625_c(pos);
                    red += (var11 & 0xFF0000) >> 16;
                    green += (var11 & 0xFF00) >> 8;
                    blue += var11 & 0xFF;
                }
            }
            int normalColor = (red / 9 & 0xFF) << 16 | (green / 9 & 0xFF) << 8 | blue / 9 & 0xFF;
            if (state.func_177229_b(BlockTFLeaves.VARIANT) == LeavesVariant.CANOPY) {
                return ((normalColor & 0xFEFEFE) + 4627046) / 2;
            }
            if (state.func_177229_b(BlockTFLeaves.VARIANT) == LeavesVariant.MANGROVE) {
                return ((normalColor & 0xFEFEFE) + 12641940) / 2;
            }
            if (state.func_177229_b(BlockTFLeaves.VARIANT) == LeavesVariant.RAINBOAK) {
                red = pos.func_177958_n() * 32 + pos.func_177956_o() * 16;
                if ((red & 0x100) != 0) {
                    red = 255 - (red & 0xFF);
                }
                red &= 0xFF;
                blue = pos.func_177956_o() * 32 + pos.func_177952_p() * 16;
                if ((blue & 0x100) != 0) {
                    blue = 255 - (blue & 0xFF);
                }
                blue ^= 0xFF;
                green = pos.func_177958_n() * 16 + pos.func_177952_p() * 32;
                if ((green & 0x100) != 0) {
                    green = 255 - (green & 0xFF);
                }
                return red << 16 | blue << 8 | (green &= 0xFF);
            }
            return normalColor;
        }, new Block[]{TFBlocks.leaves});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            Leaves3Variant variant = (Leaves3Variant)((Object)((Object)state.func_177229_b(BlockTFLeaves3.VARIANT)));
            return variant == Leaves3Variant.THORN ? ColorizerFoliage.func_77466_a() : (variant == Leaves3Variant.BEANSTALK ? ColorizerFoliage.func_77469_b() : -1);
        }, new Block[]{TFBlocks.leaves3});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> tintIndex != 0 ? 0xFFFFFF : (((PlantVariant)((Object)((Object)state.func_177229_b(BlockTFPlant.VARIANT)))).isGrassColored ? (worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0)) : 0xFFFFFF), new Block[]{TFBlocks.plant});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> ColorizerGrass.func_77480_a((double)0.5, (double)1.0), new Block[]{TFBlocks.portal});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            switch ((EnumDyeColor)state.func_177229_b(BlockTFCastleMagic.COLOR)) {
                case PINK: {
                    return 0xFF00FF;
                }
                case BLUE: {
                    return 65535;
                }
                case YELLOW: {
                    return 0xFFFF00;
                }
                case PURPLE: {
                    return 4915330;
                }
            }
            TwilightForestMod.LOGGER.info("Magic happened. Got " + ((EnumDyeColor)state.func_177229_b(BlockTFCastleMagic.COLOR)).func_176610_l() + " for Castle Rune");
            return ((EnumDyeColor)state.func_177229_b(BlockTFCastleMagic.COLOR)).func_193350_e();
        }, new Block[]{TFBlocks.castleMagic});
        blockColors.func_186722_a((state, worldIn, pos, tintIndex) -> {
            if (tintIndex > 15) {
                return 0xFFFFFF;
            }
            switch ((Integer)state.func_177229_b((IProperty)BlockTFCastleDoor.LOCK_INDEX)) {
                case 0: {
                    return 0xFFFF00;
                }
                case 1: {
                    return 4915330;
                }
                case 2: {
                    return 0xFF00FF;
                }
                case 3: {
                    return 65535;
                }
            }
            return 0;
        }, new Block[]{TFBlocks.castleDoor, TFBlocks.castleDoorVanished});
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        itemColors.func_186731_a((stack, tintIndex) -> blockColors.func_186724_a(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j()), null, null, tintIndex), new Block[]{TFBlocks.auroraBlock, TFBlocks.auroraPillar, TFBlocks.auroraSlab, TFBlocks.darkleaves, TFBlocks.giantLeaves, TFBlocks.fireJet, TFBlocks.magicLeaves, TFBlocks.leaves, TFBlocks.leaves3, TFBlocks.plant, TFBlocks.castleMagic, TFBlocks.castleDoor, TFBlocks.castleDoorVanished});
        itemColors.func_186730_a((stack, tintIndex) -> ColorizerGrass.func_77480_a((double)0.5, (double)1.0), new Item[]{TFItems.portal});
    }

    private ColorHandler() {
    }
}

