/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.finalcastle;

import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFCastleDoor;
import twilightforest.block.BlockTFCastleMagic;
import twilightforest.block.TFBlocks;
import twilightforest.structures.StructureTFComponent;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleBellTower21;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleBridge;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleDamagedTower;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleEntranceTower;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleFoundation13;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleRoof13Conical;
import twilightforest.structures.finalcastle.ComponentTFFinalCastleRoof13Crenellated;
import twilightforest.structures.lichtower.ComponentTFTowerWing;
import twilightforest.util.RotationUtil;

public class ComponentTFFinalCastleMazeTower13
extends ComponentTFTowerWing {
    public static final int LOWEST_DOOR = 144;
    public static final int HIGHEST_DOOR = 222;
    public EnumDyeColor color;

    public ComponentTFFinalCastleMazeTower13() {
    }

    public ComponentTFFinalCastleMazeTower13(Random rand, int i, int x, int y, int z, EnumDyeColor color, EnumFacing direction) {
        super(i);
        this.func_186164_a(direction);
        this.color = color;
        this.size = 13;
        int floors = rand.nextInt(3) + 2;
        this.height = floors * 8 + 1;
        int entranceFloor = rand.nextInt(floors);
        if (y - entranceFloor * 8 < 144) {
            entranceFloor = 0;
        }
        if (y + (floors - entranceFloor) * 8 > 222) {
            entranceFloor = floors - 1;
        }
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -6, 0 - entranceFloor * 8, -6, this.size - 1, this.height, this.size - 1, EnumFacing.SOUTH);
        this.addOpening(0, entranceFloor * 8 + 1, this.size / 2, Rotation.CLOCKWISE_180);
    }

    public ComponentTFFinalCastleMazeTower13(Random rand, int i, int x, int y, int z, int floors, int entranceFloor, EnumDyeColor color, EnumFacing direction) {
        super(i);
        this.func_186164_a(direction);
        this.color = color;
        this.size = 13;
        this.height = floors * 8 + 1;
        this.field_74887_e = StructureTFComponent.getComponentToAddBoundingBox(x, y, z, -6, 0 - entranceFloor * 8, -6, this.size - 1, this.height, this.size - 1, EnumFacing.SOUTH);
        this.addOpening(0, entranceFloor * 8 + 1, this.size / 2, Rotation.CLOCKWISE_180);
    }

    @Override
    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random rand) {
        if (parent != null && parent instanceof StructureTFComponent) {
            this.deco = ((StructureTFComponent)parent).deco;
        }
        ComponentTFFinalCastleFoundation13 foundation = new ComponentTFFinalCastleFoundation13(rand, 4, this);
        list.add(foundation);
        foundation.func_74861_a(this, list, rand);
        StructureTFComponent roof = rand.nextBoolean() ? new ComponentTFFinalCastleRoof13Conical(rand, 4, this) : new ComponentTFFinalCastleRoof13Crenellated(rand, 4, this);
        list.add(roof);
        roof.func_74861_a(this, list, rand);
    }

    public void buildTowards(StructureComponent parent, List list, Random rand, BlockPos dest) {
        this.func_74861_a(parent, list, rand);
        if (this.func_74877_c() < 20) {
            if (this.isWithinRange(dest.func_177958_n(), dest.func_177952_p(), this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78896_c + 6, 30)) {
                TwilightForestMod.LOGGER.info("We are within range of our destination, building final tower");
                int howFar = 20;
                if (!(this.buildEndTowerTowards(list, rand, dest, this.findBestDirectionTowards(dest), howFar) || this.buildEndTowerTowards(list, rand, dest, this.findSecondDirectionTowards(dest), howFar) || this.buildEndTowerTowards(list, rand, dest, this.findThirdDirectionTowards(dest), howFar))) {
                    TwilightForestMod.LOGGER.info("Cound not build final tower");
                }
            } else {
                int howFar = 14 + rand.nextInt(24);
                EnumFacing facing = this.findBestDirectionTowards(dest);
                if (!(facing != this.func_186165_e() && this.buildContinueTowerTowards(list, rand, dest, facing, howFar) || (facing = this.findSecondDirectionTowards(dest)) != this.func_186165_e() && this.buildContinueTowerTowards(list, rand, dest, facing, howFar) || (facing = this.findThirdDirectionTowards(dest)) != this.func_186165_e() && this.buildContinueTowerTowards(list, rand, dest, facing, howFar) || this.buildContinueTowerTowards(list, rand, dest, this.func_186165_e(), howFar))) {
                    TwilightForestMod.LOGGER.info("Could not build tower randomly");
                }
            }
        } else {
            TwilightForestMod.LOGGER.info("Built 15 towers without reaching destination");
        }
        this.buildNonCriticalTowers(parent, list, rand);
    }

    protected void buildNonCriticalTowers(StructureComponent parent, List list, Random rand) {
        EnumFacing dir = RotationUtil.getRandomFacing(rand);
        Rotation relativeRotation = RotationUtil.getRelativeRotation(this.func_186165_e(), dir);
        if (this.openingTowards[relativeRotation.ordinal()] || this.buildDamagedTower(list, rand, dir) || !this.buildDamagedTower(list, rand, dir = RotationUtil.getRandomFacing(rand))) {
            // empty if block
        }
    }

    private EnumFacing findBestDirectionTowards(BlockPos dest) {
        int cx = this.field_74887_e.field_78897_a + 6;
        int cz = this.field_74887_e.field_78896_c + 6;
        int dx = cx - dest.func_177958_n();
        int dz = cz - dest.func_177952_p();
        EnumFacing absoluteDir = Math.abs(dx) > Math.abs(dz) ? (dx >= 0 ? EnumFacing.EAST : EnumFacing.WEST) : (dz >= 0 ? EnumFacing.SOUTH : EnumFacing.NORTH);
        TwilightForestMod.LOGGER.info("Determining best direction!  center is at " + cx + ", " + cz + " and dest is at " + dest + " offset is " + dx + ", " + dz + " so the best absolute direction is " + absoluteDir);
        return absoluteDir;
    }

    private EnumFacing findSecondDirectionTowards(BlockPos dest) {
        int cx = this.field_74887_e.field_78897_a + 6;
        int cz = this.field_74887_e.field_78896_c + 6;
        int dx = cx - dest.func_177958_n();
        int dz = cz - dest.func_177952_p();
        EnumFacing absoluteDir = Math.abs(dx) < Math.abs(dz) ? (dx >= 0 ? EnumFacing.EAST : EnumFacing.WEST) : (dz >= 0 ? EnumFacing.SOUTH : EnumFacing.NORTH);
        TwilightForestMod.LOGGER.info("Determining second direction!  center is at " + cx + ", " + cz + " and dest is at " + dest + " offset is " + dx + ", " + dz + " so the best absolute direction is " + absoluteDir);
        return absoluteDir;
    }

    private EnumFacing findThirdDirectionTowards(BlockPos dest) {
        EnumFacing first = this.findBestDirectionTowards(dest);
        EnumFacing second = this.findSecondDirectionTowards(dest);
        EnumFacing[] cardinals = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.WEST};
        TwilightForestMod.LOGGER.info("Determining third direction!  first is " + first + ", and second is " + second);
        for (EnumFacing f : cardinals) {
            if (f == first || f == second || f == Rotation.CLOCKWISE_180.func_185831_a(this.func_186165_e())) continue;
            return f;
        }
        return this.func_186165_e();
    }

    private boolean buildContinueTowerTowards(List list, Random rand, BlockPos dest, EnumFacing facing, int howFar) {
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        int adjustmentRange = 60;
        if (this.isWithinRange(dest.func_177958_n(), dest.func_177952_p(), this.field_74887_e.field_78897_a + 6, this.field_74887_e.field_78896_c + 6, adjustmentRange)) {
            opening = new BlockPos(opening.func_177958_n(), this.adjustOpening(opening.func_177956_o(), dest), opening.func_177952_p());
        }
        TwilightForestMod.LOGGER.info("original direction is " + facing);
        BlockPos tc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), howFar, facing);
        TwilightForestMod.LOGGER.info("Our coord mode is " + this.func_186165_e() + ", and direction is " + facing + ", so our door is going to be at " + opening + " and the new tower will appear at " + tc);
        StructureComponent start = (StructureComponent)list.get(0);
        int centerX = start.func_74874_b().field_78897_a + 128 >> 8 << 8;
        int centerZ = start.func_74874_b().field_78896_c + 128 >> 8 << 8;
        TwilightForestMod.LOGGER.info("Testing range, uncorrected center is at " + centerX + ", " + centerZ);
        if (this.isWithinRange(centerX, centerZ, tc.func_177958_n(), tc.func_177952_p(), 128)) {
            ComponentTFFinalCastleMazeTower13 sTower = new ComponentTFFinalCastleMazeTower13(rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), this.color, facing);
            StructureBoundingBox largerBB = new StructureBoundingBox(sTower.func_74874_b());
            largerBB.field_78897_a -= 6;
            largerBB.field_78896_c -= 6;
            largerBB.field_78893_d += 6;
            largerBB.field_78892_f += 6;
            largerBB.field_78895_b = 0;
            largerBB.field_78894_e = 255;
            StructureComponent intersect = StructureComponent.func_74883_a((List)list, (StructureBoundingBox)largerBB);
            if (intersect == null) {
                TwilightForestMod.LOGGER.info("tower success!");
                list.add(sTower);
                sTower.buildTowards(this, list, rand, dest);
                BlockPos bc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), 1, facing);
                ComponentTFFinalCastleBridge bridge = new ComponentTFFinalCastleBridge(this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, facing);
                list.add(bridge);
                bridge.func_74861_a(this, list, rand);
                this.addOpening(opening.func_177958_n(), opening.func_177956_o() + 1, opening.func_177952_p(), facing);
                return true;
            }
            TwilightForestMod.LOGGER.info("tower blocked by " + intersect);
            return false;
        }
        TwilightForestMod.LOGGER.info("tower out of range");
        return false;
    }

    protected boolean buildDamagedTower(List list, Random rand, EnumFacing facing) {
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        int howFar = 14 + rand.nextInt(24);
        BlockPos tc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), howFar, facing);
        ComponentTFFinalCastleMazeTower13 eTower = this.makeNewDamagedTower(rand, facing, tc);
        StructureBoundingBox largerBB = new StructureBoundingBox(eTower.func_74874_b());
        largerBB.field_78897_a -= 6;
        largerBB.field_78896_c -= 6;
        largerBB.field_78893_d += 6;
        largerBB.field_78892_f += 6;
        StructureComponent intersect = StructureComponent.func_74883_a((List)list, (StructureBoundingBox)largerBB);
        if (intersect == null) {
            list.add(eTower);
            eTower.func_74861_a(this, list, rand);
            BlockPos bc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), 1, facing);
            ComponentTFFinalCastleBridge bridge = new ComponentTFFinalCastleBridge(this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, facing);
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(opening.func_177958_n(), opening.func_177956_o() + 1, opening.func_177952_p(), facing);
            return true;
        }
        return false;
    }

    protected ComponentTFFinalCastleMazeTower13 makeNewDamagedTower(Random rand, EnumFacing facing, BlockPos tc) {
        return new ComponentTFFinalCastleDamagedTower(rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), facing);
    }

    private int adjustOpening(int posY, BlockPos dest) {
        int openY = posY;
        int realOpeningY = this.func_74862_a(openY);
        if (realOpeningY - dest.func_177956_o() < 12) {
            openY = this.height - 9;
        } else if (dest.func_177956_o() - realOpeningY < 12) {
            openY = 0;
        }
        return openY;
    }

    private boolean buildEndTowerTowards(List list, Random rand, BlockPos dest, EnumFacing facing, int howFar) {
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        opening = new BlockPos(opening.func_177958_n(), this.adjustOpening(opening.func_177956_o(), dest), opening.func_177952_p());
        BlockPos tc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), howFar, facing);
        ComponentTFFinalCastleMazeTower13 eTower = this.color == BlockTFCastleMagic.VALID_COLORS.get(0) ? new ComponentTFFinalCastleEntranceTower(rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), facing) : new ComponentTFFinalCastleBellTower21(rand, this.func_74877_c() + 1, tc.func_177958_n(), tc.func_177956_o(), tc.func_177952_p(), facing);
        StructureBoundingBox largerBB = new StructureBoundingBox(eTower.func_74874_b());
        largerBB.field_78897_a -= 6;
        largerBB.field_78896_c -= 6;
        largerBB.field_78893_d += 6;
        largerBB.field_78892_f += 6;
        StructureComponent intersect = StructureComponent.func_74883_a((List)list, (StructureBoundingBox)largerBB);
        if (intersect == null) {
            list.add(eTower);
            eTower.func_74861_a(this, list, rand);
            BlockPos bc = this.offsetTowerCCoords(opening.func_177958_n(), opening.func_177956_o(), opening.func_177952_p(), 1, facing);
            ComponentTFFinalCastleBridge bridge = new ComponentTFFinalCastleBridge(this.func_74877_c() + 1, bc.func_177958_n(), bc.func_177956_o(), bc.func_177952_p(), howFar - 7, facing);
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(opening.func_177958_n(), opening.func_177956_o() + 1, opening.func_177952_p(), facing);
            return true;
        }
        return false;
    }

    private boolean isWithinRange(int centerX, int centerZ, int posX, int posZ, int range) {
        boolean inRange;
        boolean bl = inRange = Math.abs(centerX - posX) < range && Math.abs(centerZ - posZ) < range;
        if (!inRange) {
            // empty if block
        }
        return inRange;
    }

    public BlockPos getValidOpeningCC(Random rand, EnumFacing facing) {
        Rotation relative = RotationUtil.getRelativeRotation(this.func_186165_e(), facing);
        int floors = this.height / 8;
        if (relative == Rotation.NONE || relative == Rotation.CLOCKWISE_180) {
            int rx = relative == Rotation.NONE ? 12 : 0;
            int rz = 6;
            int ry = rand.nextInt(floors) * 8;
            return new BlockPos(rx, ry, rz);
        }
        if (relative == Rotation.CLOCKWISE_90 || relative == Rotation.COUNTERCLOCKWISE_90) {
            int rx = 6;
            int rz = relative == Rotation.CLOCKWISE_90 ? 12 : 0;
            int ry = rand.nextInt(floors) * 8;
            return new BlockPos(rx, ry, rz);
        }
        return new BlockPos(0, 0, 0);
    }

    @Override
    protected BlockPos offsetTowerCCoords(int x, int y, int z, int howFar, EnumFacing direction) {
        int dx = this.func_74865_a(x, z);
        int dy = this.func_74862_a(y);
        int dz = this.func_74873_b(x, z);
        switch (direction) {
            case SOUTH: {
                dx += howFar;
                break;
            }
            case WEST: {
                dz += howFar;
                break;
            }
            case NORTH: {
                dx -= howFar;
                break;
            }
            case EAST: {
                dz -= howFar;
            }
        }
        return new BlockPos(dx, dy, dz);
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.func_74882_a(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, false, rand, this.deco.randomBlocks);
        for (int x = 0; x < this.size; ++x) {
            for (int z = 0; z < this.size; ++z) {
                this.func_175808_b(world, this.deco.blockState, x, -1, z, sbb);
            }
        }
        int numBranches = 2 + decoRNG.nextInt(4) + decoRNG.nextInt(3);
        for (int i = 0; i < numBranches; ++i) {
            this.makeGlyphBranches(world, decoRNG, this.getGlyphColour(), sbb);
        }
        this.addFloors(world, decoRNG, sbb);
        this.makeOpenings(world, sbb);
        return true;
    }

    public EnumDyeColor getGlyphColour() {
        if (this.color == null) {
            TwilightForestMod.LOGGER.warn("Final Castle tower has null for glyph color, this is a bug.");
            return EnumDyeColor.BLUE;
        }
        return this.color;
    }

    private void addFloors(World world, Random rand, StructureBoundingBox sbb) {
        int floors = this.highestOpening / 8 + 1;
        Rotation rotation = Rotation.CLOCKWISE_90;
        for (int i = 1; i < floors; ++i) {
            this.func_175804_a(world, sbb, 1, i * 8, 1, 11, i * 8, 11, this.deco.blockState, this.deco.blockState, false);
            rotation = rotation.func_185830_a(Rotation.CLOCKWISE_180);
            this.addStairsDown(world, sbb, rotation, i * 8);
        }
        if (this.hasAccessibleRoof()) {
            this.addStairsDown(world, sbb, RotationUtil.ROTATIONS[floors + 2 & 3], this.height - 1);
        }
    }

    protected boolean hasAccessibleRoof() {
        return this.height - this.highestOpening < 9;
    }

    private void addStairsDown(World world, StructureBoundingBox sbb, Rotation rotation, int y) {
        int sz;
        int sy;
        int sx;
        int i;
        for (i = 0; i < 4; ++i) {
            sx = 8 - i;
            sy = y - i;
            sz = 9;
            this.setBlockStateRotated(world, ComponentTFFinalCastleMazeTower13.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), sx, sy, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx, sy - 1, sz, rotation, sbb);
            this.setBlockStateRotated(world, ComponentTFFinalCastleMazeTower13.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), sx, sy, sz - 1, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx, sy - 1, sz - 1, rotation, sbb);
            this.fillAirRotated(world, sbb, sx, sy + 1, sz - 1, sx, sy + 3, sz, rotation);
        }
        this.fillBlocksRotated(world, sbb, 3, y - 4, 8, 4, y - 4, 9, this.deco.blockState, rotation);
        for (i = 0; i < 4; ++i) {
            sx = 4;
            sy = y - i - 4;
            sz = 7 - i;
            this.setBlockStateRotated(world, ComponentTFFinalCastleMazeTower13.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false), sx, sy, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx, sy - 1, sz, rotation, sbb);
            this.setBlockStateRotated(world, ComponentTFFinalCastleMazeTower13.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false), sx - 1, sy, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.blockState, sx - 1, sy - 1, sz, rotation, sbb);
            this.fillAirRotated(world, sbb, sx, sy + 1, sz, sx - 1, sy + 3, sz, rotation);
        }
    }

    @Override
    protected void makeDoorOpening(World world, int dx, int dy, int dz, StructureBoundingBox sbb) {
        IBlockState doorState = TFBlocks.castleDoor.func_176223_P().func_177226_a((IProperty)BlockTFCastleDoor.LOCK_INDEX, (Comparable)Integer.valueOf(this.getGlyphColour().func_176765_a() % 4));
        if (dx == 0 || dx == this.size - 1) {
            this.func_175804_a(world, sbb, dx, dy - 1, dz - 2, dx, dy + 4, dz + 2, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx, dy, dz - 1, dx, dy + 3, dz + 1, doorState, AIR, false);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.func_175804_a(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 4, dz, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx - 1, dy, dz, dx + 1, dy + 3, dz, doorState, AIR, false);
        }
    }
}

