/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import twilightforest.world.TFGenHollowTree;

public class TFGenHollowStump
extends TFGenHollowTree {
    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int radius = rand.nextInt(2) + 2;
        if (!TFGenHollowStump.isAreaSuitable(world, rand, pos.func_177982_a(-radius, 0, -radius), 2 * radius, 6, 2 * radius)) {
            return false;
        }
        this.buildTrunk(world, rand, pos, radius, 6);
        this.buildBranchRing(world, rand, pos, radius, 3, 2, 6, 0, 0.75, 0.0, 3, 5, 3, false);
        this.buildBranchRing(world, rand, pos, radius, 1, 2, 8, 0, 0.9, 0.0, 3, 5, 3, false);
        return true;
    }

    @Override
    protected void buildTrunk(World world, Random random, BlockPos pos, int diameter, int maxHeight) {
        int dz;
        int dx;
        int hollow = diameter / 2;
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                for (int dy = -4; dy < 0; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter) continue;
                    BlockPos dPos = pos.func_177982_a(dx, dy, dz);
                    if (TFGenHollowStump.hasAirAround(world, dPos)) {
                        this.func_175903_a(world, dPos, dist > hollow ? this.treeState : this.branchState);
                        continue;
                    }
                    this.func_175903_a(world, dPos, this.rootState);
                }
            }
        }
        for (dx = -diameter; dx <= diameter; ++dx) {
            for (dz = -diameter; dz <= diameter; ++dz) {
                int height = 2 + random.nextInt(3) + random.nextInt(2);
                for (int dy = 0; dy <= height; ++dy) {
                    int az;
                    int ax = Math.abs(dx);
                    int dist = (int)((double)Math.max(ax, az = Math.abs(dz)) + (double)Math.min(ax, az) * 0.5);
                    if (dist > diameter || dist <= hollow) continue;
                    this.func_175903_a(world, pos.func_177982_a(dx, dy, dz), this.treeState);
                }
            }
        }
    }
}

