/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.ThornVariant;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.item.TFItems;
import twilightforest.util.WorldUtil;

public class BlockTFThorns
extends BlockRotatedPillar
implements ModelRegisterCallback {
    public static final PropertyEnum<ThornVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", ThornVariant.class);
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    private static final float THORN_DAMAGE = 4.0f;
    private static final AxisAlignedBB Y_BB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 1.0, 0.8125);
    private static final AxisAlignedBB X_BB = new AxisAlignedBB(0.0, 0.1875, 0.1875, 1.0, 0.8125, 0.8125);
    private static final AxisAlignedBB Z_BB = new AxisAlignedBB(0.1875, 0.1875, 0.0, 0.8125, 0.8125, 1.0);

    protected BlockTFThorns() {
        super(Material.field_151575_d);
        this.func_149711_c(50.0f);
        this.func_149752_b(2000.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(TFItems.creativeTab);
        if (this.hasVariant()) {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.Y).func_177226_a(VARIANT, (Comparable)((Object)ThornVariant.BROWN)).func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected boolean hasVariant() {
        return true;
    }

    public BlockStateContainer func_180661_e() {
        return this.hasVariant() ? new BlockStateContainer((Block)this, new IProperty[]{field_176298_M, VARIANT, NORTH, SOUTH, WEST, EAST}) : new BlockStateContainer((Block)this, new IProperty[]{field_176298_M, NORTH, SOUTH, WEST, EAST});
    }

    public int func_176201_c(IBlockState state) {
        return this.hasVariant() ? super.func_176201_c(state) | ((ThornVariant)((Object)state.func_177229_b(VARIANT))).ordinal() : super.func_176201_c(state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.hasVariant() ? super.func_176203_a(meta).func_177226_a(VARIANT, (Comparable)((Object)ThornVariant.values()[meta & 3])) : super.func_176203_a(meta);
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M)) {
            case X: {
                return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.DOWN))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.UP))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.SOUTH)));
            }
            case Z: {
                return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.UP))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.DOWN))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.EAST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.WEST)));
            }
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canConnectTo(state, world, pos, EnumFacing.EAST)));
    }

    private boolean canConnectTo(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing connectTo) {
        IBlockState otherState = world.func_180495_p(pos.func_177972_a(connectTo));
        return (otherState.func_177230_c() == TFBlocks.thorns || otherState.func_177230_c() == TFBlocks.burntThorns) && state.func_177229_b((IProperty)field_176298_M) != connectTo.func_176740_k();
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M)) {
            default: {
                return Y_BB;
            }
            case X: {
                return X_BB;
            }
            case Z: 
        }
        return Z_BB;
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return this.func_180646_a(state, (IBlockAccess)world, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        entity.func_70097_a(DamageSource.field_76367_g, 4.0f);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean harvest) {
        if (!player.field_71075_bZ.field_75098_d) {
            if (!world.field_72995_K) {
                world.func_180501_a(pos, state, 2);
                this.doThornBurst(world, pos, state);
            }
        } else {
            world.func_175698_g(pos);
        }
        return true;
    }

    @Deprecated
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    private void doThornBurst(World world, BlockPos pos, IBlockState state) {
        switch ((EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M)) {
            case Y: {
                this.growThorns(world, pos, EnumFacing.UP);
                this.growThorns(world, pos, EnumFacing.DOWN);
                break;
            }
            case X: {
                this.growThorns(world, pos, EnumFacing.EAST);
                this.growThorns(world, pos, EnumFacing.WEST);
                break;
            }
            case Z: {
                this.growThorns(world, pos, EnumFacing.NORTH);
                this.growThorns(world, pos, EnumFacing.SOUTH);
            }
        }
        this.growThorns(world, pos, EnumFacing.func_176741_a((Random)world.field_73012_v));
        this.growThorns(world, pos, EnumFacing.func_176741_a((Random)world.field_73012_v));
        this.growThorns(world, pos, EnumFacing.func_176741_a((Random)world.field_73012_v));
    }

    private void growThorns(World world, BlockPos pos, EnumFacing dir) {
        BlockPos dPos;
        int length = 1 + world.field_73012_v.nextInt(3);
        for (int i = 1; i < length && world.func_175623_d(dPos = pos.func_177967_a(dir, i)); ++i) {
            world.func_180501_a(dPos, this.func_176223_P().func_177226_a((IProperty)field_176298_M, (Comparable)dir.func_176740_k()).func_177226_a(VARIANT, (Comparable)((Object)ThornVariant.GREEN)), 2);
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int range = 4;
        int exRange = range + 1;
        if (world.func_175697_a(pos, exRange)) {
            for (BlockPos pos_ : WorldUtil.getAllAround(pos, range)) {
                IBlockState state_ = world.func_180495_p(pos_);
                if (!state_.func_177230_c().isLeaves(state_, (IBlockAccess)world, pos_)) continue;
                state.func_177230_c().beginLeavesDecay(state_, world, pos_);
            }
        }
    }

    public int func_149745_a(Random p_149745_1_) {
        return 0;
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        for (int i = 0; i < (this.hasVariant() ? ThornVariant.values().length : 1); ++i) {
            par3List.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelUtils.registerToStateSingleVariant((Block)this, VARIANT);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side.func_176740_k() == blockState.func_177229_b((IProperty)field_176298_M) && (blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this || super.func_176225_a(blockState, blockAccess, pos, side));
    }
}

