/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import twilightforest.entity.boss.EntityTFSnowQueen;

public class EntityAITFHoverBeam
extends EntityAIBase {
    private static final float HOVER_HEIGHT = 3.0f;
    private static final float HOVER_RADIUS = 4.0f;
    private Class<? extends EntityLivingBase> classTarget;
    private EntityTFSnowQueen attacker;
    private double hoverPosX;
    private double hoverPosY;
    private double hoverPosZ;
    private int hoverTimer;
    private int beamTimer;
    private int maxHoverTime;
    private int maxBeamTime;
    private int seekTimer;
    private int maxSeekTime;
    private double beamY;
    private boolean isInPosition;

    public EntityAITFHoverBeam(EntityTFSnowQueen entityTFSnowQueen, Class<EntityPlayer> class1, int hoverTime, int dropTime) {
        this.attacker = entityTFSnowQueen;
        this.classTarget = class1;
        this.func_75248_a(3);
        this.maxHoverTime = hoverTime;
        this.maxSeekTime = hoverTime;
        this.maxBeamTime = dropTime;
        this.hoverTimer = 0;
        this.isInPosition = false;
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        if (this.classTarget != null && !this.classTarget.isAssignableFrom(target.getClass())) {
            return false;
        }
        return this.attacker.getCurrentPhase() == EntityTFSnowQueen.Phase.BEAM;
    }

    public boolean func_75253_b() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (this.attacker.getCurrentPhase() != EntityTFSnowQueen.Phase.BEAM) {
            return false;
        }
        if (this.seekTimer >= this.maxSeekTime) {
            return false;
        }
        return this.beamTimer < this.maxBeamTime;
    }

    public void func_75249_e() {
        EntityLivingBase target = this.attacker.func_70638_az();
        if (target != null) {
            this.makeNewHoverSpot(target);
        }
    }

    public void func_75251_c() {
        this.seekTimer = 0;
        this.hoverTimer = 0;
        this.beamTimer = 0;
        this.isInPosition = false;
        this.attacker.setBreathing(false);
    }

    public void func_75246_d() {
        EntityLivingBase target;
        if (this.attacker.func_70092_e(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            this.isInPosition = true;
        }
        if (this.isInPosition) {
            ++this.hoverTimer;
        } else {
            ++this.seekTimer;
        }
        if (this.hoverTimer >= this.maxHoverTime) {
            ++this.beamTimer;
            this.attacker.setBreathing(true);
            Entity target2 = this.getHeadLookTarget();
            if (target2 != null) {
                this.attacker.doBreathAttack(target2);
            }
            this.hoverPosY -= (double)0.05f;
            if (this.hoverPosY < this.beamY) {
                this.hoverPosY = this.beamY;
            }
        }
        double offsetX = this.hoverPosX - this.attacker.field_70165_t;
        double offsetY = this.hoverPosY - this.attacker.field_70163_u;
        double offsetZ = this.hoverPosZ - this.attacker.field_70161_v;
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if ((distanceDesired = (double)MathHelper.func_76133_a((double)distanceDesired)) > 0.5) {
            double velX = offsetX / distanceDesired * 0.05;
            double velY = offsetY / distanceDesired * 0.1;
            double velZ = offsetZ / distanceDesired * 0.05;
            this.attacker.func_70024_g(velX, velY += (double)0.02f, velZ);
        }
        if ((target = this.attacker.func_70638_az()) != null) {
            float tracking = this.isInPosition ? 1.0f : 20.0f;
            this.attacker.func_70625_a((Entity)target, tracking, tracking);
            this.attacker.func_70671_ap().func_75651_a((Entity)target, tracking, tracking);
        }
    }

    private Entity getHeadLookTarget() {
        Entity pointedEntity = null;
        double range = 30.0;
        Vec3d srcVec = new Vec3d(this.attacker.field_70165_t, this.attacker.field_70163_u + 0.25, this.attacker.field_70161_v);
        Vec3d lookVec = this.attacker.func_70676_i(1.0f);
        Vec3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        float var9 = 3.0f;
        List possibleList = this.attacker.field_70170_p.func_72839_b((Entity)this.attacker, this.attacker.func_174813_aQ().func_72317_d(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range).func_72314_b((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.func_70067_L() || possibleEntity == this.attacker) continue;
            float borderSize = possibleEntity.func_70111_Y();
            AxisAlignedBB collisionBB = possibleEntity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            RayTraceResult interceptPos = collisionBB.func_72327_a(srcVec, destVec);
            if (collisionBB.func_72318_a(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.func_72438_d(interceptPos.field_72307_f)) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    private void makeNewHoverSpot(EntityLivingBase target) {
        double hx = 0.0;
        double hy = 0.0;
        double hz = 0.0;
        int tries = 100;
        for (int i = 0; !(i >= tries || !this.isPositionOccupied(hx = target.field_70165_t + (double)((this.attacker.func_70681_au().nextFloat() - this.attacker.func_70681_au().nextFloat()) * 4.0f), hy = target.field_70163_u + 3.0, hz = target.field_70161_v + (double)((this.attacker.func_70681_au().nextFloat() - this.attacker.func_70681_au().nextFloat()) * 4.0f)) && this.canEntitySee((Entity)this.attacker, hx, hy, hz) && this.canEntitySee((Entity)target, hx, hy, hz)); ++i) {
        }
        this.hoverPosX = hx;
        this.hoverPosY = hy;
        this.hoverPosZ = hz;
        this.beamY = target.field_70163_u;
        this.seekTimer = 0;
    }

    private boolean isPositionOccupied(double hx, double hy, double hz) {
        float radius = this.attacker.field_70130_N / 2.0f;
        AxisAlignedBB aabb = new AxisAlignedBB(hx - (double)radius, hy, hz - (double)radius, hx + (double)radius, hy + (double)this.attacker.field_70131_O, hz + (double)radius);
        boolean isOccupied = this.attacker.field_70170_p.func_184144_a((Entity)this.attacker, aabb).isEmpty();
        return isOccupied;
    }

    protected boolean canEntitySee(Entity entity, double dx, double dy, double dz) {
        return entity.field_70170_p.func_72933_a(new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), new Vec3d(dx, dy, dz)) == null;
    }
}

