/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.TwilightForestMod;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.block.enums.MagicWoodVariant;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.ModelUtils;
import twilightforest.client.particle.TFParticleType;
import twilightforest.item.TFItems;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlockTFMagicLeaves
extends BlockLeaves
implements ModelRegisterCallback {
    protected BlockTFMagicLeaves() {
        this.func_149711_c(0.2f);
        this.func_149713_g(2);
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a(BlockTFMagicLog.VARIANT, (Comparable)((Object)MagicWoodVariant.TIME)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockTFMagicLog.VARIANT, field_176236_b, field_176237_a});
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((MagicWoodVariant)((Object)state.func_177229_b(BlockTFMagicLog.VARIANT))).ordinal();
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            meta |= 8;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            meta |= 4;
        }
        return meta;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        int variant = meta & 3;
        boolean checkDecay = (meta & 8) > 0;
        boolean decayable = (meta & 4) > 0;
        return this.func_176223_P().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(checkDecay)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(decayable)).func_177226_a(BlockTFMagicLog.VARIANT, (Comparable)((Object)MagicWoodVariant.values()[variant]));
    }

    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        par3List.add((Object)new ItemStack((Block)this, 1, 0));
        par3List.add((Object)new ItemStack((Block)this, 1, 1));
        par3List.add((Object)new ItemStack((Block)this, 1, 2));
        par3List.add((Object)new ItemStack((Block)this, 1, 3));
    }

    public void func_180655_c(IBlockState state, World par1World, BlockPos pos, Random par5Random) {
        if (state.func_177229_b(BlockTFMagicLog.VARIANT) == MagicWoodVariant.TRANS) {
            for (int i = 0; i < 1; ++i) {
                this.sparkleRunes(par1World, pos, par5Random);
            }
        }
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    private void sparkleRunes(World world, BlockPos pos, Random rand) {
        double offset = 0.0625;
        EnumFacing side = EnumFacing.func_176741_a((Random)rand);
        double rx = (float)pos.func_177958_n() + rand.nextFloat();
        double ry = (float)pos.func_177956_o() + rand.nextFloat();
        double rz = (float)pos.func_177952_p() + rand.nextFloat();
        if (side == EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            ry = (double)(pos.func_177956_o() + 1) + offset;
        }
        if (side == EnumFacing.UP && world.func_175623_d(pos.func_177977_b())) {
            ry = (double)(pos.func_177956_o() + 0) - offset;
        }
        if (side == EnumFacing.NORTH && world.func_175623_d(pos.func_177968_d())) {
            rz = (double)(pos.func_177952_p() + 1) + offset;
        }
        if (side == EnumFacing.SOUTH && world.func_175623_d(pos.func_177978_c())) {
            rz = (double)(pos.func_177952_p() + 0) - offset;
        }
        if (side == EnumFacing.WEST && world.func_175623_d(pos.func_177974_f())) {
            rx = (double)(pos.func_177958_n() + 1) + offset;
        }
        if (side == EnumFacing.EAST && world.func_175623_d(pos.func_177976_e())) {
            rx = (double)(pos.func_177958_n() + 0) - offset;
        }
        if (rx < (double)pos.func_177958_n() || rx > (double)(pos.func_177958_n() + 1) || ry < (double)pos.func_177956_o() || ry > (double)(pos.func_177956_o() + 1) || rz < (double)pos.func_177952_p() || rz > (double)(pos.func_177952_p() + 1)) {
            TwilightForestMod.proxy.spawnParticle(world, TFParticleType.LEAF_RUNE, rx, ry, rz, 0.0, 0.0, 0.0);
        }
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{field_176236_b}).func_178442_a(new IProperty[]{field_176237_a}).func_178441_a());
        ModelUtils.registerToStateSingleVariant((Block)this, BlockTFMagicLog.VARIANT);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, ((MagicWoodVariant)((Object)state.func_177229_b(BlockTFMagicLog.VARIANT))).ordinal());
    }
}

