/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import twilightforest.block.enums.BossVariant;
import twilightforest.client.model.ModelTFHydraHead;
import twilightforest.client.model.ModelTFLich;
import twilightforest.client.model.ModelTFNaga;
import twilightforest.client.model.ModelTFSnowQueen;
import twilightforest.client.model.ModelTFTowerBoss;
import twilightforest.tileentity.TileEntityTFTrophy;

public class TileEntityTFTrophyRenderer
extends TileEntitySpecialRenderer<TileEntityTFTrophy> {
    private ModelTFHydraHead hydraHeadModel = new ModelTFHydraHead();
    private static final ResourceLocation textureLocHydra = new ResourceLocation("twilightforest:textures/model/hydra4.png");
    private ModelTFNaga nagaHeadModel = new ModelTFNaga();
    private static final ResourceLocation textureLocNaga = new ResourceLocation("twilightforest:textures/model/nagahead.png");
    private ModelTFLich lichModel = new ModelTFLich();
    private static final ResourceLocation textureLocLich = new ResourceLocation("twilightforest:textures/model/twilightlich64.png");
    private ModelTFTowerBoss urGhastModel = new ModelTFTowerBoss();
    private static final ResourceLocation textureLocUrGhast = new ResourceLocation("twilightforest:textures/model/towerboss.png");
    private ModelTFSnowQueen snowQueenModel = new ModelTFSnowQueen();
    private static final ResourceLocation textureLocSnowQueen = new ResourceLocation("twilightforest:textures/model/snowqueen.png");

    public void render(TileEntityTFTrophy trophy, double x, double y, double z, float partialTime, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        int meta = trophy.func_145832_p() & 7;
        float rotation = (float)(trophy.func_145906_b() * 360) / 16.0f;
        boolean onGround = true;
        if (meta != 1) {
            switch (meta) {
                case 2: {
                    onGround = false;
                    break;
                }
                case 3: {
                    onGround = false;
                    rotation = 180.0f;
                    break;
                }
                case 4: {
                    onGround = false;
                    rotation = 270.0f;
                    break;
                }
                default: {
                    onGround = false;
                    rotation = 90.0f;
                }
            }
        }
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        switch (BossVariant.values()[trophy.func_145904_a()]) {
            case HYDRA: {
                this.renderHydraHead(rotation, onGround);
                break;
            }
            case NAGA: {
                this.renderNagaHead(rotation, onGround);
                break;
            }
            case LICH: {
                this.renderLichHead(rotation, onGround);
                break;
            }
            case UR_GHAST: {
                this.renderUrGhastHead(trophy, rotation, onGround, partialTime);
                break;
            }
            case SNOW_QUEEN: {
                this.renderSnowQueenHead(rotation, onGround);
            }
        }
        GlStateManager.func_179121_F();
    }

    private void renderHydraHead(float rotation, boolean onGround) {
        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
        this.func_147499_a(textureLocHydra);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.0f : -0.0f), (float)1.5f);
        this.hydraHeadModel.openMouthForTrophy(onGround ? 0.0f : 0.25f);
        this.hydraHeadModel.func_78088_a(null, 0.0f, 0.0f, 0.0f, rotation, 0.0f, 0.0625f);
    }

    private void renderNagaHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)-0.125f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.25f, (float)0.25f, (float)0.25f);
        this.func_147499_a(textureLocNaga);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.0f : -0.0f), (float)(onGround ? 0.0f : 1.0f));
        this.nagaHeadModel.func_78088_a(null, 0.0f, 0.0f, 0.0f, rotation, 0.0f, 0.0625f);
    }

    private void renderLichHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(textureLocLich);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.75f : 1.5f), (float)(onGround ? 0.0f : 0.24f));
        this.lichModel.field_78116_c.func_78785_a(0.0625f);
        this.lichModel.field_178720_f.func_78785_a(0.0625f);
    }

    private void renderUrGhastHead(TileEntityTFTrophy trophy, float rotation, boolean onGround, float partialTime) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        this.func_147499_a(textureLocUrGhast);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.0f : 1.0f), (float)(onGround ? 0.0f : 0.0f));
        this.urGhastModel.func_78088_a(null, 0.0f, 0.0f, (float)trophy.ticksExisted + partialTime, 0.0f, 0.0f, 0.0625f);
    }

    private void renderSnowQueenHead(float rotation, boolean onGround) {
        GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
        this.func_147499_a(textureLocSnowQueen);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)(onGround ? 1.5f : 1.25f), (float)(onGround ? 0.0f : 0.24f));
        this.snowQueenModel.field_78116_c.func_78785_a(0.0625f);
        this.snowQueenModel.field_178720_f.func_78785_a(0.0625f);
    }
}

