/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import twilightforest.TFFeature;
import twilightforest.util.PlayerHelper;

public class EntityTFSwarmSpider
extends EntitySpider {
    protected boolean shouldSpawn = false;

    public EntityTFSwarmSpider(World world) {
        this(world, true);
    }

    public EntityTFSwarmSpider(World world, boolean spawnMore) {
        super(world);
        this.func_70105_a(0.8f, 0.4f);
        this.setSpawnMore(spawnMore);
        this.field_70728_aV = 2;
    }

    public EntityTFSwarmSpider(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.field_75782_a.removeIf(t -> t.field_75733_a instanceof EntityAIAttackMelee);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true){

            protected double func_179512_a(EntityLivingBase attackTarget) {
                return 4.0f + attackTarget.field_70130_N;
            }
        });
        this.field_70715_bh.field_75782_a.removeIf(t -> t.field_75731_b == 2 && t.field_75733_a instanceof EntityAINearestAttackableTarget);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    public float func_70603_bj() {
        return 0.5f;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.shouldSpawnMore()) {
            int more = 1 + this.field_70146_Z.nextInt(2);
            for (int i = 0; i < more; ++i) {
                if (this.spawnAnother()) continue;
                this.spawnAnother();
            }
            this.setSpawnMore(false);
        }
        super.func_70071_h_();
    }

    public boolean func_70652_k(Entity entity) {
        return this.field_70146_Z.nextInt(4) == 0 && super.func_70652_k(entity);
    }

    protected boolean spawnAnother() {
        EntityTFSwarmSpider another = new EntityTFSwarmSpider(this.field_70170_p, false);
        double sx = this.field_70165_t + (this.field_70146_Z.nextBoolean() ? 0.9 : -0.9);
        double sy = this.field_70163_u;
        double sz = this.field_70161_v + (this.field_70146_Z.nextBoolean() ? 0.9 : -0.9);
        another.func_70012_b(sx, sy, sz, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
        if (!another.func_70601_bi()) {
            another.func_70106_y();
            return false;
        }
        this.field_70170_p.func_72838_d((Entity)another);
        another.func_70656_aK();
        return true;
    }

    protected boolean func_70814_o() {
        int chunkZ;
        int chunkX = MathHelper.func_76128_c((double)this.field_70165_t) >> 4;
        return TFFeature.getNearestFeature(chunkX, chunkZ = MathHelper.func_76128_c((double)this.field_70161_v) >> 4, this.field_70170_p) == TFFeature.hedgeMaze || super.func_70814_o();
    }

    public boolean shouldSpawnMore() {
        return this.shouldSpawn;
    }

    public void setSpawnMore(boolean flag) {
        this.shouldSpawn = flag;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("SpawnMore", this.shouldSpawnMore());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setSpawnMore(nbttagcompound.func_74767_n("SpawnMore"));
    }

    public void func_70645_a(DamageSource source) {
        int chunkZ;
        int chunkX;
        super.func_70645_a(source);
        if (source.func_76346_g() instanceof EntityPlayerMP && TFFeature.getNearestFeature(chunkX = MathHelper.func_76128_c((double)this.field_70165_t) >> 4, chunkZ = MathHelper.func_76128_c((double)this.field_70161_v) >> 4, this.field_70170_p) == TFFeature.hedgeMaze) {
            PlayerHelper.grantCriterion((EntityPlayerMP)source.func_76346_g(), new ResourceLocation("twilightforest", "hedge"), "swarm_spider");
        }
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f;
    }

    public int func_70641_bl() {
        return 16;
    }
}

