/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.BlockTFRoots;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.RootVariant;
import twilightforest.item.ItemTF;
import twilightforest.item.TFItems;
import twilightforest.world.TFGenerator;

public class ItemTFOreMagnet
extends ItemTF {
    private static final float WIGGLE = 10.0f;

    protected ItemTFOreMagnet() {
        this.func_77637_a(TFItems.creativeTab);
        this.field_77777_bU = 1;
        this.func_77656_e(12);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return !itemstack.func_190926_b() && itemstack.func_77973_b() == TFItems.oreMagnet ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public void func_77615_a(ItemStack par1ItemStack, World world, EntityLivingBase living, int useRemaining) {
        int useTime = this.func_77626_a(par1ItemStack) - useRemaining;
        if (!world.field_72995_K && useTime > 10) {
            int moved = this.doMagnet(world, living, 0.0f, 0.0f);
            if (moved == 0) {
                moved = this.doMagnet(world, living, 10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 0.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, -10.0f, 10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, -10.0f, 0.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, -10.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 0.0f, -10.0f);
            }
            if (moved == 0) {
                moved = this.doMagnet(world, living, 10.0f, -10.0f);
            }
            if (moved > 0) {
                par1ItemStack.func_77972_a(moved, living);
                world.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_187534_aX, living.func_184176_by(), 1.0f, 1.0f);
            }
        }
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    private int doMagnet(World world, EntityLivingBase living, float yawOffset, float pitchOffset) {
        double range = 32.0;
        Vec3d srcVec = new Vec3d(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v);
        Vec3d lookVec = this.getOffsetLook(living, yawOffset, pitchOffset);
        Vec3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        return ItemTFOreMagnet.doMagnet(world, new BlockPos(srcVec), new BlockPos(destVec));
    }

    public static int doMagnet(World world, BlockPos usePos, BlockPos destPos) {
        int blocksMoved = 0;
        BlockPos[] lineArray = TFGenerator.getBresehnamArrays(usePos, destPos);
        IBlockState foundState = Blocks.field_150350_a.func_176223_P();
        BlockPos foundPos = null;
        BlockPos basePos = null;
        boolean isNetherrack = false;
        for (BlockPos coord : lineArray) {
            IBlockState searchState = world.func_180495_p(coord);
            if (basePos == null) {
                if (ItemTFOreMagnet.isReplaceable(world, searchState, coord)) {
                    basePos = coord;
                } else if (ItemTFOreMagnet.isNetherReplaceable(world, searchState, coord)) {
                    isNetherrack = true;
                    basePos = coord;
                }
            }
            if (searchState.func_177230_c() == Blocks.field_150350_a || !ItemTFOreMagnet.isOre(searchState)) continue;
            foundState = searchState;
            foundPos = coord;
            break;
        }
        if (basePos != null && foundState.func_177230_c() != Blocks.field_150350_a) {
            HashSet<BlockPos> veinBlocks = new HashSet<BlockPos>();
            ItemTFOreMagnet.findVein(world, foundPos, foundState, veinBlocks);
            int offX = basePos.func_177958_n() - foundPos.func_177958_n();
            int offY = basePos.func_177956_o() - foundPos.func_177956_o();
            int offZ = basePos.func_177952_p() - foundPos.func_177952_p();
            for (BlockPos coord : veinBlocks) {
                BlockPos replacePos = coord.func_177982_a(offX, offY, offZ);
                IBlockState replaceState = world.func_180495_p(replacePos);
                if (!(!isNetherrack ? ItemTFOreMagnet.isReplaceable(world, replaceState, replacePos) : ItemTFOreMagnet.isNetherReplaceable(world, replaceState, replacePos)) && replaceState.func_177230_c() != Blocks.field_150350_a) continue;
                world.func_180501_a(coord, isNetherrack ? Blocks.field_150424_aL.func_176223_P() : Blocks.field_150348_b.func_176223_P(), 2);
                world.func_180501_a(replacePos, foundState, 2);
                ++blocksMoved;
            }
        }
        return blocksMoved;
    }

    private Vec3d getOffsetLook(EntityLivingBase living, float yawOffset, float pitchOffset) {
        float var2 = MathHelper.func_76134_b((float)(-(living.field_70177_z + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var3 = MathHelper.func_76126_a((float)(-(living.field_70177_z + yawOffset) * ((float)Math.PI / 180) - (float)Math.PI));
        float var4 = -MathHelper.func_76134_b((float)(-(living.field_70125_A + pitchOffset) * ((float)Math.PI / 180)));
        float var5 = MathHelper.func_76126_a((float)(-(living.field_70125_A + pitchOffset) * ((float)Math.PI / 180)));
        return new Vec3d((double)(var3 * var4), (double)var5, (double)(var2 * var4));
    }

    private static boolean isReplaceable(World world, IBlockState state, BlockPos pos) {
        if (state.func_177230_c() == Blocks.field_150346_d) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150349_c) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150351_n) {
            return true;
        }
        return state.func_177230_c() != Blocks.field_150350_a && state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150348_b));
    }

    private static boolean isNetherReplaceable(World world, IBlockState state, BlockPos pos) {
        if (state.func_177230_c() == Blocks.field_150424_aL) {
            return true;
        }
        return state.func_177230_c() != Blocks.field_150350_a && state.func_177230_c().isReplaceableOreGen(state, (IBlockAccess)world, pos, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL));
    }

    private static boolean findVein(World world, BlockPos here, IBlockState oreState, Set<BlockPos> veinBlocks) {
        if (veinBlocks.contains(here)) {
            return false;
        }
        if (veinBlocks.size() >= 24) {
            return false;
        }
        if (world.func_180495_p(here) == oreState) {
            veinBlocks.add(here);
            for (EnumFacing e : EnumFacing.field_82609_l) {
                ItemTFOreMagnet.findVein(world, here.func_177972_a(e), oreState, veinBlocks);
            }
            return true;
        }
        return false;
    }

    private static boolean isOre(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150365_q) {
            return false;
        }
        if (state.func_177230_c() == Blocks.field_150366_p) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150482_ag) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150412_bA) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150352_o) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150369_x) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150450_ax) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150439_ay) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150449_bY) {
            return true;
        }
        if (state == TFBlocks.root.func_176223_P().func_177226_a(BlockTFRoots.VARIANT, (Comparable)((Object)RootVariant.LIVEROOT))) {
            return true;
        }
        return state.func_177230_c().func_149739_a().toLowerCase().contains("ore");
    }
}

