/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.stronghold;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.structures.stronghold.StructureTFStrongholdComponent;
import twilightforest.world.TFGenSmallRainboak;
import twilightforest.world.TFGenSmallTwilightOak;

public class ComponentTFStrongholdAtrium
extends StructureTFStrongholdComponent {
    private boolean enterBottom;

    public ComponentTFStrongholdAtrium() {
    }

    public ComponentTFStrongholdAtrium(int i, EnumFacing facing, int x, int y, int z) {
        super(i, facing, x, y, z);
    }

    @Override
    protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        super.func_143012_a(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("enterBottom", this.enterBottom);
    }

    @Override
    protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager templateManager) {
        super.func_143011_b(par1NBTTagCompound, templateManager);
        this.enterBottom = par1NBTTagCompound.func_74767_n("enterBottom");
    }

    @Override
    public StructureBoundingBox generateBoundingBox(EnumFacing facing, int x, int y, int z) {
        if (y > 17) {
            this.enterBottom = false;
        } else if (y < 11) {
            this.enterBottom = true;
        } else {
            boolean bl = this.enterBottom = (z & 1) == 0;
        }
        if (this.enterBottom) {
            return StructureTFStrongholdComponent.getComponentToAddBoundingBox(x, y, z, -4, -1, 0, 18, 14, 18, facing);
        }
        return StructureTFStrongholdComponent.getComponentToAddBoundingBox(x, y, z, -13, -8, 0, 18, 14, 18, facing);
    }

    public void func_74861_a(StructureComponent parent, List list, Random random) {
        super.func_74861_a(parent, list, random);
        if (this.enterBottom) {
            this.addDoor(4, 1, 0);
            this.addNewComponent(parent, list, random, Rotation.CLOCKWISE_180, 13, 8, -1);
        } else {
            this.addDoor(13, 8, 0);
            this.addNewComponent(parent, list, random, Rotation.CLOCKWISE_180, 4, 1, -1);
        }
        this.addNewComponent(parent, list, random, Rotation.NONE, 13, 1, 18);
        this.addNewComponent(parent, list, random, Rotation.NONE, 4, 8, 18);
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        this.placeStrongholdWalls(world, sbb, 0, 0, 0, 17, 13, 17, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 1, 6, 1, 16, 7, 16, false, rand, this.deco.randomBlocks);
        this.func_175804_a(world, sbb, 5, 8, 5, 12, 8, 12, this.deco.fenceState, AIR, false);
        this.func_74878_a(world, sbb, 6, 6, 6, 11, 8, 11);
        this.placeBalconyPillar(world, sbb, Rotation.NONE);
        this.placeBalconyPillar(world, sbb, Rotation.CLOCKWISE_90);
        this.placeBalconyPillar(world, sbb, Rotation.CLOCKWISE_180);
        this.placeBalconyPillar(world, sbb, Rotation.COUNTERCLOCKWISE_90);
        this.func_74882_a(world, sbb, 1, 1, 1, 1, 12, 2, false, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 2, 1, 1, 2, 12, 1, false, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 16, 1, 1, 16, 12, 2, false, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 15, 1, 1, 15, 12, 1, false, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 1, 1, 15, 1, 12, 16, false, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 2, 1, 16, 2, 12, 16, false, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 16, 1, 15, 16, 12, 16, false, rand, this.deco.randomBlocks);
        this.func_74882_a(world, sbb, 15, 1, 16, 15, 12, 16, false, rand, this.deco.randomBlocks);
        IBlockState grass = Blocks.field_150349_c.func_176223_P();
        this.func_189914_a(world, sbb, rand, 0.5f, 6, 0, 6, 11, 0, 11, grass, grass, false, 0);
        this.func_175804_a(world, sbb, 7, 0, 7, 10, 0, 10, grass, AIR, false);
        this.spawnATree(world, rand.nextInt(5), 8, 1, 8, sbb);
        this.placeCornerStatue(world, 2, 8, 2, 0, sbb);
        this.placeCornerStatue(world, 2, 1, 15, 1, sbb);
        this.placeCornerStatue(world, 15, 1, 2, 2, sbb);
        this.placeCornerStatue(world, 15, 8, 15, 3, sbb);
        this.placeDoors(world, rand, sbb);
        return true;
    }

    private void spawnATree(World world, int treeNum, int x, int y, int z, StructureBoundingBox sbb) {
        BlockPos pos = this.getBlockPosWithOffset(x, y, z);
        if (sbb.func_175898_b((Vec3i)pos)) {
            TFGenSmallTwilightOak treeGen;
            int minHeight = 8;
            switch (treeNum) {
                default: {
                    IBlockState oakWood = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK);
                    IBlockState oakLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK);
                    treeGen = new WorldGenTrees(true, minHeight, oakWood, oakLeaves, false);
                    break;
                }
                case 1: {
                    IBlockState jungleWood = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
                    IBlockState jungleLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE);
                    treeGen = new WorldGenTrees(true, minHeight, jungleWood, jungleLeaves, false);
                    break;
                }
                case 2: {
                    IBlockState birchWood = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH);
                    IBlockState birchLeaves = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH);
                    treeGen = new WorldGenTrees(true, minHeight, birchWood, birchLeaves, false);
                    break;
                }
                case 3: {
                    treeGen = new TFGenSmallTwilightOak(false, minHeight);
                    break;
                }
                case 4: {
                    treeGen = new TFGenSmallRainboak(false);
                }
            }
            for (int i = 0; i < 100 && !treeGen.func_180709_b(world, world.field_73012_v, pos); ++i) {
            }
        }
    }

    private void placeBalconyPillar(World world, StructureBoundingBox sbb, Rotation rotation) {
        this.fillBlocksRotated(world, sbb, 5, 1, 5, 5, 12, 5, this.deco.pillarState, rotation);
        this.setBlockStateRotated(world, ComponentTFStrongholdAtrium.getStairState(this.deco.stairState, Rotation.COUNTERCLOCKWISE_90.func_185831_a(EnumFacing.WEST), rotation, false), 5, 1, 6, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFStrongholdAtrium.getStairState(this.deco.stairState, Rotation.CLOCKWISE_180.func_185831_a(EnumFacing.WEST), rotation, false), 6, 1, 5, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFStrongholdAtrium.getStairState(this.deco.stairState, Rotation.COUNTERCLOCKWISE_90.func_185831_a(EnumFacing.WEST), rotation, true), 5, 5, 6, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFStrongholdAtrium.getStairState(this.deco.stairState, Rotation.CLOCKWISE_180.func_185831_a(EnumFacing.WEST), rotation, true), 6, 5, 5, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFStrongholdAtrium.getStairState(this.deco.stairState, Rotation.COUNTERCLOCKWISE_90.func_185831_a(EnumFacing.WEST), rotation, true), 5, 12, 6, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFStrongholdAtrium.getStairState(this.deco.stairState, Rotation.CLOCKWISE_180.func_185831_a(EnumFacing.WEST), rotation, true), 6, 12, 5, rotation, sbb);
    }
}

