/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import twilightforest.block.BlockTFMagicLog;
import twilightforest.block.TFBlocks;
import twilightforest.block.enums.MagicWoodVariant;
import twilightforest.world.TFGenerator;
import twilightforest.world.TFTreeGenerator;
import twilightforest.world.TFWorld;

public class TFGenMinersTree
extends TFTreeGenerator {
    public TFGenMinersTree() {
        this(false);
    }

    public TFGenMinersTree(boolean notify) {
        super(notify);
        this.treeState = TFBlocks.magicLog.func_176223_P().func_177226_a(BlockTFMagicLog.VARIANT, (Comparable)((Object)MagicWoodVariant.MINE));
        this.branchState = this.treeState.func_177226_a((IProperty)BlockTFMagicLog.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE);
        this.leafState = TFBlocks.magicLeaves.func_176223_P().func_177226_a(BlockTFMagicLog.VARIANT, (Comparable)((Object)MagicWoodVariant.MINE));
        this.rootState = TFBlocks.root.func_176223_P();
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        Material materialUnder = world.func_180495_p(pos.func_177977_b()).func_185904_a();
        if (materialUnder != Material.field_151577_b && materialUnder != Material.field_151578_c || pos.func_177956_o() >= TFWorld.MAXHEIGHT - 12) {
            return false;
        }
        for (int dy = 0; dy < 10; ++dy) {
            this.func_175903_a(world, pos.func_177981_b(dy), this.branchState);
        }
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 9, 1), true);
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 9, 2), false);
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 8, 3), false);
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 7, 4), false);
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 6, 5), false);
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 9, -1), true);
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 9, -2), false);
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 8, -3), false);
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 7, -4), false);
        this.putBranchWithLeaves(world, pos.func_177982_a(0, 6, -5), false);
        this.func_175903_a(world, pos.func_177984_a(), TFBlocks.magicLogSpecial.func_176223_P().func_177226_a(BlockTFMagicLog.VARIANT, (Comparable)((Object)MagicWoodVariant.MINE)));
        world.func_175684_a(pos.func_177984_a(), TFBlocks.magicLogSpecial, TFBlocks.magicLogSpecial.func_149738_a(world));
        if (TFGenerator.hasAirAround(world, pos.func_177977_b())) {
            this.func_175903_a(world, pos.func_177977_b(), this.treeState);
        } else {
            this.func_175903_a(world, pos.func_177977_b(), this.rootState);
        }
        int numRoots = 3 + rand.nextInt(2);
        double offset = rand.nextDouble();
        for (int b = 0; b < numRoots; ++b) {
            this.buildRoot(world, pos, offset, b);
        }
        return true;
    }

    protected void putBranchWithLeaves(World world, BlockPos pos, boolean bushy) {
        this.func_175903_a(world, pos, this.branchState);
        for (int lx = -1; lx <= 1; ++lx) {
            for (int ly = -1; ly <= 1; ++ly) {
                for (int lz = -1; lz <= 1; ++lz) {
                    if (!bushy && Math.abs(ly) > 0 && Math.abs(lx) > 0) continue;
                    TFGenerator.putLeafBlock(this, world, pos.func_177982_a(lx, ly, lz), this.leafState);
                }
            }
        }
    }
}

