/*
 * Decompiled with CFR 0.152.
 */
package info.creepershift.wificharge.block.tile;

import info.creepershift.wificharge.block.tile.ForgeEnergyImpl;
import info.creepershift.wificharge.config.Config;
import info.creepershift.wificharge.util.EnergyHelper;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TilePersonalCharger
extends TileEntity
implements ITickable {
    private final ForgeEnergyImpl storage = new ForgeEnergyImpl(Config.personalCapacity, Config.personalMaxInput, Config.personalMaxOutput);
    private boolean hasRedstone = false;
    private UUID playerUUID;
    private int hardLimit = (int)((float)Config.personalMaxOutput * 0.1f);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            EntityPlayerMP p = this.getPlayer();
            if (!this.hasRedstone && p != null && this.storage.getEnergyStored() >= 5000 && (Config.transferDimension || p.func_130014_f_() == this.field_145850_b)) {
                this.chargeItems(p);
            }
        }
    }

    private void chargeItems(EntityPlayerMP player) {
        List<NonNullList> list = Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c);
        for (NonNullList inventoryList : list) {
            for (ItemStack stack : inventoryList) {
                int energy;
                boolean otherWorldCost;
                if (!this.isItemValid(stack)) continue;
                int maxOut = Config.personalMaxOutput;
                int stored = this.storage.getEnergyStored();
                boolean reachedLimit = false;
                boolean bl = otherWorldCost = Config.dimensionCost && player.func_130014_f_() != this.field_145850_b;
                if (Config.personalRangeCost && !otherWorldCost) {
                    maxOut = (int)Math.floor(this.outputByRange((EntityPlayer)player, Config.personalMaxOutput, this.func_174877_v()));
                    stored = (int)Math.floor(this.outputByRange((EntityPlayer)player, stored, this.func_174877_v()));
                    if (Config.rangeHardLimit && maxOut < this.hardLimit) {
                        maxOut = this.hardLimit;
                        stored = (int)((float)stored * 0.1f);
                        reachedLimit = true;
                    }
                } else if (otherWorldCost) {
                    maxOut = (int)Math.floor(this.outputByDimension(Config.personalMaxOutput));
                    stored = (int)Math.floor(this.outputByDimension(stored));
                }
                int cost = energy = Math.min(EnergyHelper.chargeItem(stack, maxOut, true), stored);
                if (energy <= 0) continue;
                if (reachedLimit) {
                    cost = (int)((float)cost / 0.1f);
                } else if (Config.personalRangeCost && !otherWorldCost) {
                    cost = (int)this.costByRange((EntityPlayer)player, energy, this.func_174877_v());
                } else if (otherWorldCost) {
                    cost = (int)Math.floor(this.costByDimension(energy));
                }
                if (cost > this.storage.getEnergyStored()) continue;
                EnergyHelper.chargeItem(stack, energy, false);
                this.storage.extractEnergy(cost, false);
            }
        }
    }

    private double outputByRange(EntityPlayer player, double energy, BlockPos pos) {
        BlockPos playerPos = player.func_180425_c();
        double distance = Math.floor(pos.func_185332_f(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p()));
        return energy / (1.0 + (double)Config.rangeRate / 1000.0 * Math.max(1.0, distance / 100.0));
    }

    private double costByRange(EntityPlayer player, double cost, BlockPos pos) {
        BlockPos playerPos = player.func_180425_c();
        double distance = Math.floor(pos.func_185332_f(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p()));
        return cost * (1.0 + (double)Config.rangeRate / 1000.0 * Math.max(1.0, distance / 100.0));
    }

    private double costByDimension(double cost) {
        return cost * (1.0 + (double)(Config.dimensionRate / 100));
    }

    private double outputByDimension(double energy) {
        return energy / (1.0 + (double)(Config.dimensionRate / 100));
    }

    private boolean isItemValid(ItemStack stack) {
        return stack != ItemStack.field_190927_a && (!Config.ignoreBlocks || !(stack.func_77973_b() instanceof ItemBlock) && EnergyHelper.isItemValid(stack));
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setRedstone(boolean redstone) {
        this.hasRedstone = redstone;
    }

    public void setPlayer(EntityPlayerMP player) {
        this.playerUUID = player.func_110124_au();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.storage.readFromNBT(compound);
        this.playerUUID = compound.func_186857_a("Player");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.storage.writeToNBT(compound);
        compound.func_186854_a("Player", this.playerUUID);
        return compound;
    }

    private EntityPlayerMP getPlayer() {
        PlayerList pl = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al();
        if (this.playerUUID != null) {
            return pl.func_177451_a(this.playerUUID);
        }
        return null;
    }
}

