/*
 * Decompiled with CFR 0.152.
 */
package info.creepershift.wificharge.block.tile;

import info.creepershift.wificharge.block.tile.ForgeEnergyImpl;
import info.creepershift.wificharge.config.Config;
import info.creepershift.wificharge.util.EnergyHelper;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileWirelessCharger
extends TileEntity
implements ITickable {
    private final ForgeEnergyImpl storage = new ForgeEnergyImpl(Config.blockCapacity, Config.maxInput, Config.maxOutput);
    private int counter = 0;
    private boolean hasRedstone = false;

    public void func_73660_a() {
        if (!this.hasRedstone && !this.field_145850_b.field_72995_K && this.storage.getEnergyStored() >= 5000) {
            if (Config.isPerformance) {
                if (this.counter >= 20) {
                    this.getItems();
                    this.counter = 0;
                }
                ++this.counter;
            } else {
                this.getItems();
            }
        }
    }

    private void getItems() {
        List list = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.func_174877_v().func_177982_a(-Config.wirelessRange, -Config.wirelessRange, -Config.wirelessRange), this.func_174877_v().func_177982_a(Config.wirelessRange, Config.wirelessRange, Config.wirelessRange)));
        for (EntityPlayer player : list) {
            this.chargeItems(Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c), player);
        }
    }

    private void chargeItems(List<NonNullList<ItemStack>> list, EntityPlayer player) {
        for (NonNullList<ItemStack> inventoryList : list) {
            for (ItemStack stack : inventoryList) {
                int energy;
                if (!this.isItemValid(stack)) continue;
                int maxOut = Config.maxOutput;
                int stored = this.storage.getEnergyStored();
                if (Config.wirelessRangeEnergy) {
                    maxOut = (int)Math.floor(this.outputByRange(player, Config.maxOutput, this.func_174877_v()));
                    stored = (int)Math.floor(this.outputByRange(player, stored, this.func_174877_v()));
                }
                int cost = energy = Math.min(EnergyHelper.chargeItem(stack, Config.isPerformance ? maxOut * 20 : maxOut, true, 4, Config.isPerformance), stored);
                if (energy <= 0) continue;
                if (Config.wirelessRangeEnergy) {
                    cost = (int)this.costByRange(player, energy, this.func_174877_v());
                }
                if (cost > this.storage.getEnergyStored()) continue;
                EnergyHelper.chargeItem(stack, energy, false, 4, Config.isPerformance);
                this.storage.extractEnergyFast(cost, false, Config.isPerformance);
            }
        }
    }

    private boolean isItemValid(ItemStack stack) {
        return stack != ItemStack.field_190927_a && (!Config.ignoreBlocks || !(stack.func_77973_b() instanceof ItemBlock) && EnergyHelper.isItemValid(stack));
    }

    private double outputByRange(EntityPlayer player, double energy, BlockPos pos) {
        BlockPos playerPos = player.func_180425_c();
        double distance = Math.floor(pos.func_185332_f(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p()));
        return energy / (1.0 + (double)Config.wirelessRangeEnergyRate / 1000.0 * distance);
    }

    private double costByRange(EntityPlayer player, double cost, BlockPos pos) {
        BlockPos playerPos = player.func_180425_c();
        double distance = Math.floor(pos.func_185332_f(playerPos.func_177958_n(), playerPos.func_177956_o(), playerPos.func_177952_p()));
        return cost * (1.0 + (double)Config.wirelessRangeEnergyRate / 1000.0 * distance);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.getCapability(capability, facing) != null;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setRedstone(boolean redstone) {
        this.hasRedstone = redstone;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.storage.readFromNBT(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.storage.writeToNBT(compound);
        return compound;
    }
}

