/*
 * Decompiled with CFR 0.152.
 */
package info.creepershift.wificharge.util;

import info.creepershift.wificharge.Main;
import info.creepershift.wificharge.config.Config;
import info.creepershift.wificharge.util.compat.FluxCompat;
import info.creepershift.wificharge.util.compat.IC2Compat;
import info.creepershift.wificharge.util.compat.IECompat;
import info.creepershift.wificharge.util.compat.TeslaCompat;
import net.minecraft.item.ItemStack;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHelper {
    private EnergyHelper() {
    }

    public static int chargeItem(ItemStack stack, int energy, boolean simulate) {
        return EnergyHelper.chargeItem(stack, energy, simulate, 4, false);
    }

    public static int chargeItem(ItemStack stack, int energy, boolean simulate, int tier, boolean ignoreChargeLimit) {
        if (stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            IEnergyStorage cap = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            return cap.receiveEnergy(energy, simulate);
        }
        if (Main.teslaLoaded && TeslaCompat.hasTesla(stack)) {
            return TeslaCompat.chargeItem(stack, energy, simulate);
        }
        if (Main.redstonefluxLoaded && FluxCompat.hasFlux(stack)) {
            return FluxCompat.chargeItem(stack, energy, simulate);
        }
        if (Main.immersiveLoaded && IECompat.hasIE(stack)) {
            return IECompat.chargeItem(stack, energy, simulate);
        }
        if (Main.ic2Loaded && Config.allowIC2 && IC2Compat.hasIC2(stack)) {
            return IC2Compat.chargeItem(stack, energy, simulate, tier, ignoreChargeLimit);
        }
        return 0;
    }

    public static boolean isItemValid(ItemStack stack) {
        return stack.hasCapability(CapabilityEnergy.ENERGY, null) || Main.teslaLoaded && TeslaCompat.hasTesla(stack) || Main.redstonefluxLoaded && FluxCompat.hasFlux(stack) || Main.immersiveLoaded && IECompat.hasIE(stack) || Main.ic2Loaded && Config.allowIC2 && IC2Compat.hasIC2(stack);
    }
}

